/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Vector3D;

public class CameraPose
extends Pose {
    public Vector3D v;
    public float lat;
    public float lon;
    public float roll;
    public float range;
    public int angle;
    public boolean perspective;
    public byte[] interpX = new byte[4];
    public byte[] interpY = new byte[4];
    public byte[] interpZ = new byte[4];
    public byte[] interpR = new byte[4];
    public byte[] interpRange = new byte[4];
    public byte[] interpProjection = new byte[4];

    public CameraPose() {
        this.v = new Vector3D();
        this.roll = 0.0f;
        this.lon = 0.0f;
        this.lat = 0.0f;
        this.range = 10.0f;
        this.angle = 25;
        this.perspective = true;
        this.interpX = new byte[]{20, 20, 107, 107};
        this.interpY = new byte[]{20, 20, 107, 107};
        this.interpZ = new byte[]{20, 20, 107, 107};
        this.interpR = new byte[]{20, 20, 107, 107};
        this.interpRange = new byte[]{20, 20, 107, 107};
        this.interpProjection = new byte[]{20, 20, 107, 107};
        this.nameOfBone = "\u30ab\u30e1\u30e9";
    }

    public CameraPose(CameraPose other) {
        super(other);
        this.v = other.v.clone();
        this.lat = other.lat;
        this.lon = other.lon;
        this.roll = other.roll;
        this.range = other.range;
        this.angle = other.angle;
        this.perspective = other.perspective;
        this.interpX = new byte[4];
        this.interpY = new byte[4];
        this.interpZ = new byte[4];
        this.interpR = new byte[4];
        this.interpRange = new byte[4];
        this.interpProjection = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.interpX[i] = other.interpX[i];
            this.interpY[i] = other.interpY[i];
            this.interpZ[i] = other.interpZ[i];
            this.interpR[i] = other.interpR[i];
            this.interpRange[i] = other.interpRange[i];
            this.interpProjection[i] = other.interpProjection[i];
        }
    }

    @Override
    public String toCSV() {
        byte[] unknown;
        StringBuilder line = new StringBuilder(256);
        line.append(this.frame).append(",").append(this.range).append(",").append(this.v).append(",").append((double)(this.lat * 180.0f) / Math.PI).append(",").append((double)(this.lon * 180.0f) / Math.PI).append(",").append((double)(this.roll * 180.0f) / Math.PI);
        line.append(",0x");
        for (byte b : unknown = this.unknown()) {
            line.append((b & 0xF0) == 0 ? "0" : "").append(Integer.toHexString(b).toUpperCase());
        }
        line.append(",").append(this.angle);
        line.append(",").append(this.perspective);
        for (byte b : this.interpX) {
            line.append(",").append(b);
        }
        for (byte b : this.interpY) {
            line.append(",").append(b);
        }
        for (byte b : this.interpZ) {
            line.append(",").append(b);
        }
        for (byte b : this.interpR) {
            line.append(",").append(b);
        }
        for (byte b : this.interpRange) {
            line.append(",").append(b);
        }
        for (byte b : this.interpProjection) {
            line.append(",").append(b);
        }
        return line.append("\n").toString();
    }

    public static CameraPose fromCSV(String line) throws NumberFormatException {
        String[] column = CsvSpliter.split(line);
        if (column.length < 9) {
            return null;
        }
        CameraPose p = new CameraPose();
        p.frame = Integer.parseInt(column[0]);
        p.range = Float.parseFloat(column[1]);
        p.v = new Vector3D(Double.parseDouble(column[2]), Double.parseDouble(column[3]), Double.parseDouble(column[4]));
        p.lat = (float)(Double.parseDouble(column[5]) * Math.PI / 180.0);
        p.lon = (float)(Double.parseDouble(column[6]) * Math.PI / 180.0);
        p.roll = (float)(Double.parseDouble(column[7]) * Math.PI / 180.0);
        p.angle = 0;
        for (int i = 0; i < 58; i += 2) {
            String hex = column[8].substring(i + 2, i + 4);
            byte t = Byte.parseByte(hex, 16);
            if (i < 8) {
                p.interpX[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 16) {
                p.interpY[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 24) {
                p.interpZ[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 32) {
                p.interpR[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 40) {
                p.interpRange[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 48) {
                p.interpProjection[(i >> 2 & 1) + (i & 2)] = t;
                continue;
            }
            if (i < 56) {
                p.angle |= t << (i - 48) * 4;
                continue;
            }
            p.perspective = t == 0;
        }
        if (column.length > 9) {
            // empty if block
        }
        return p;
    }

    @Override
    protected byte[] toVMD() {
        ByteBuffer ret = ByteBuffer.allocate(61).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(this.frame);
        ret.putFloat(this.range);
        double[] rv = this.v.toDouble();
        ret.putFloat((float)rv[0]);
        ret.putFloat((float)rv[1]);
        ret.putFloat((float)rv[2]);
        ret.putFloat(this.lat);
        ret.putFloat(this.lon);
        ret.putFloat(this.roll);
        ret.put(this.unknown());
        return ret.array();
    }

    private byte[] unknown() {
        int i;
        byte[] ret = new byte[29];
        for (i = 0; i < 4; ++i) {
            ret[i] = this.interpX[((i & 2) >> 1) + (i & 1) * 2];
        }
        for (i = 4; i < 8; ++i) {
            ret[i] = this.interpY[((i & 2) >> 1) + (i & 1) * 2];
        }
        for (i = 8; i < 12; ++i) {
            ret[i] = this.interpZ[((i & 2) >> 1) + (i & 1) * 2];
        }
        for (i = 12; i < 16; ++i) {
            ret[i] = this.interpR[((i & 2) >> 1) + (i & 1) * 2];
        }
        for (i = 16; i < 20; ++i) {
            ret[i] = this.interpRange[((i & 2) >> 1) + (i & 1) * 2];
        }
        for (i = 20; i < 24; ++i) {
            ret[i] = this.interpProjection[((i & 2) >> 1) + (i & 1) * 2];
        }
        ret[24] = (byte)(0xFF & this.angle);
        ret[25] = (byte)(0xFF & this.angle >> 8);
        ret[26] = (byte)(0xFF & this.angle >> 16);
        ret[27] = (byte)(0xFF & this.angle >> 24);
        ret[28] = (byte)(!this.perspective ? 1 : 0);
        return ret;
    }

    @Override
    public CameraPose clone() {
        CameraPose p = new CameraPose(this);
        return p;
    }
}

