/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class AboutDialog
extends JDialog {
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton okButton;

    public AboutDialog(Frame parent, boolean modal, Class clazz, String message) {
        super(parent, modal);
        this.initComponents();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.doClose();
            }
        });
        URL u = clazz.getResource(clazz.getSimpleName() + ".class");
        String s = u.toExternalForm();
        Properties p = new Properties();
        if (s.startsWith("jar")) {
            s = s.substring(0, s.lastIndexOf("!/"));
            try {
                JarURLConnection jarConnection = (JarURLConnection)new URL(s + "!/").openConnection();
                Attributes attr = jarConnection.getMainAttributes();
                String artifactId = s.substring(s.lastIndexOf("/") + 1);
                artifactId = artifactId.substring(0, artifactId.indexOf("-"));
                message = message + "\n\n" + this.packName(attr, artifactId);
                message = message + "\n\n\u4f9d\u5b58\u6027: \n";
                s = s.substring(0, s.lastIndexOf("/") + 1);
                String el = attr.getValue("Extension-List");
                for (String l : el.split(" ")) {
                    String name = attr.getValue(l + "-Extension-Name");
                    String ver = attr.getValue(l + "-Implementation-Version");
                    JarURLConnection jarConnection2 = (JarURLConnection)new URL(s + name + "-" + ver + ".jar!/").openConnection();
                    Attributes attr2 = jarConnection2.getMainAttributes();
                    message = message + this.packName(attr2, l);
                }
            }
            catch (MalformedURLException ex) {
                message = message + ex;
            }
            catch (IOException ex) {
                message = message + ex;
            }
        } else {
            s = s.substring(0, s.lastIndexOf("classes/"));
            try {
                InputStream is = new URL(s + "maven-archiver/pom.properties").openStream();
                p.load(is);
                is.close();
                message = message + "(" + p.getProperty("groupId") + "." + p.getProperty("artifactId") + ") Version: " + p.getProperty("version");
                message = message + "\n\n\u4f9d\u5b58\u6027: \n";
                message = message + "TogaGem (jp.sourceforge.mikutoga.togagem) http://mikutoga.sourceforge.jp/ Version: 3.101.4-mod\n";
            }
            catch (MalformedURLException ex) {
                message = message + ex;
            }
            catch (IOException ex) {
                message = message + ex;
            }
        }
        this.jTextArea1.setText(message);
    }

    private String packName(Attributes attr, String artifactID) throws IOException {
        String ret = attr.getValue("Implementation-Title");
        ret = ret + " (" + attr.getValue("Implementation-Vendor-Id") + "." + artifactID + ") ";
        ret = ret + attr.getValue("Implementation-URL");
        ret = ret + " Version: " + attr.getValue("Implementation-Version") + "\n";
        if (attr.getValue("Copyright") != null) {
            ret = ret + "    " + attr.getValue("Copyright") + "\n\n";
        }
        return ret;
    }

    public void show(String title) {
        this.setTitle(title + " \u306b\u3064\u3044\u3066");
        this.setVisible(true);
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.okButton);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 32));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

