/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.DatatypeConverter;
import jp.sfjp.mikutoga.xml.TogaXmlException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomUtils {
    private static final char BS_CHAR = '\\';

    private DomUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static String getStringAttr(Element elem, String attrName) throws TogaXmlException {
        String result;
        if (!elem.hasAttribute(attrName)) {
            String message = "Attr:[" + attrName + "] " + "was not found in " + "Elem:[" + elem.getTagName() + "]";
            throw new TogaXmlException(message);
        }
        try {
            result = elem.getAttribute(attrName);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid attribute form [" + attrName + "]";
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static boolean getBooleanAttr(Element elem, String attrName) throws TogaXmlException {
        boolean result;
        String value = DomUtils.getStringAttr(elem, attrName);
        try {
            result = DatatypeConverter.parseBoolean((String)value);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid boolean attribute form [" + attrName + "][" + value + "]";
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static int getIntegerAttr(Element elem, String attrName) throws TogaXmlException {
        int result;
        String value = DomUtils.getStringAttr(elem, attrName);
        try {
            result = DatatypeConverter.parseInt((String)value);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid integer attribute form [" + attrName + "][" + value + "]";
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static float getFloatAttr(Element elem, String attrName) throws TogaXmlException {
        float result;
        String value = DomUtils.getStringAttr(elem, attrName);
        try {
            result = DatatypeConverter.parseFloat((String)value);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid float attribute form [" + attrName + "][" + value + "]";
            throw new TogaXmlException(message, e);
        }
        return result;
    }

    public static String getSjisFileNameAttr(Element elem, String attrName) throws TogaXmlException {
        String result;
        try {
            result = DomUtils.getStringAttr(elem, attrName);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid winfile attribute form [" + attrName + "]";
            throw new TogaXmlException(message, e);
        }
        result = result.replace("\u00a5", "\\");
        return result;
    }

    public static Element getChild(Element parent, String tagName) throws TogaXmlException {
        Element result = null;
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element elem;
            String elemTagName;
            if (node.getNodeType() != 1 || !tagName.equals(elemTagName = (elem = (Element)node).getTagName())) continue;
            result = elem;
            break;
        }
        if (result == null) {
            String message = "Elem:[" + tagName + "] was not found in " + "Elem:[" + parent.getTagName() + "]";
            throw new TogaXmlException(message);
        }
        return result;
    }

    public static boolean hasChild(Element parent, String tagName) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element elem;
            String elemTagName;
            if (node.getNodeType() != 1 || !tagName.equals(elemTagName = (elem = (Element)node).getTagName())) continue;
            return true;
        }
        return false;
    }

    public static List<Element> getChildList(Element parent, String childTag) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element elem;
            String tagName;
            if (node.getNodeType() != 1 || !childTag.equals(tagName = (elem = (Element)node).getTagName())) continue;
            result.add(elem);
        }
        return result;
    }

    public static Iterator<Element> getChildIterator(Element parent, String childTag) {
        Element firstElem;
        try {
            firstElem = DomUtils.getChild(parent, childTag);
        }
        catch (TogaXmlException e) {
            firstElem = null;
        }
        ElemIterator result = new ElemIterator(firstElem);
        return result;
    }

    public static Iterable<Element> getEachChild(Element parent, String childTag) {
        final Iterator<Element> iterator = DomUtils.getChildIterator(parent, childTag);
        Iterable<Element> result = new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return iterator;
            }
        };
        return result;
    }

    public static Element nextElement(Element elem) {
        Node nextNode = elem;
        while ((nextNode = nextNode.getNextSibling()) != null && nextNode.getNodeType() != 1) {
        }
        return (Element)nextNode;
    }

    public static Element nextNamedElement(Element elem) {
        String tagName = elem.getTagName();
        Element nextElem = elem;
        while ((nextElem = DomUtils.nextElement(nextElem)) != null && !tagName.equals(nextElem.getTagName())) {
        }
        return nextElem;
    }

    private static final class ElemIterator
    implements Iterator<Element> {
        private Element next;

        ElemIterator(Element elem) {
            this.next = elem;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Element result = this.next;
            this.next = DomUtils.nextNamedElement(this.next);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

