﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace MecabDotNet
{
    /// <summary>
    /// Mecabラッパ
    /// </summary>
    public class Mecab : _Mecab
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Mecab() : this("") { }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="arg"></param>
        public Mecab(string arg)
        {
            this.ptrMecab = this._mecab_new2(arg);
        }

        /// <summary>
        /// mecab の version を文字列として取得します.
        /// </summary>
        /// <returns></returns>
        public string mecab_version
        {
            get { return this._mecab_version(); }
        }

        /// <summary>
        /// エラーの内容を返します。
        /// </summary>
        /// <returns></returns>
        public string mecab_strerror()
        {
            return this._mecab_strerror();
        }

        public string mecab_sparse_tostr(string str)
        {
            return this._mecab_sparse_tostr(str);
        }

        public string mecab_sparse_tostr2(int n, string str, int length)
        {
            return this._mecab_nbest_sparse_tostr2(n, str, length);
        }

        public string mecab_sparse_tostr3(string strSrc, out string strDst, int olen)
        {
            return this._mecab_sparse_tostr3(strSrc, out strDst, olen);
        }

        public string mecab_nbest_sparse_tostr(int n, string strSrc)
        {
            return this._mecab_nbest_sparse_tostr(n, strSrc);
        }

        public string mecab_nbest_sparse_tostr2(int n, string strSrc, int length)
        {
            return this._mecab_nbest_sparse_tostr2(n, strSrc, length);
        }

        public string mecab_nbest_sparse_tostr3(
            int n,
            string strSrc,
            int length,
            out string strDst,
            int olen)
        {
            return this._mecab_nbest_sparse_tostr3(
                n,
                strSrc,
                length,
                out strDst,
                olen
            );
        }

        public int mecab_nbest_init(string strSrc)
        {
            return this._mecab_nbest_init(strSrc);
        }

        public int mecab_nbest_init2(string strSrc, int length)
        {
            return this._mecab_nbest_init2(strSrc, length);
        }

        public string mecab_nbest_next_tostr()
        {
            return this._mecab_nbest_next_tostr();
        }

        public string mecab_nbest_nbest_tostr2(out string strDst, int olen)
        {
            return this._mecab_nbest_next_tostr2(out strDst, olen);
        }

        public void mecab_destroy()
        {
            this._mecab_destroy();
        }

    }

    /// <summary>
    /// このクラスのインスタンスを直接利用しないでください。
    /// </summary>
    public class _Mecab : IDisposable
    {
        protected IntPtr ptrMecab;

        // path/to/libmecab.dll | libmecab.so
        protected const string libmecab = @"C:\Program Files\MeCab\bin\libmecab.dll";

        /*
        /// <summary>
        /// コンストラクタ.
        /// mecab のインスタンスを生成します.
        /// 引数には, C 言語の, main 関数で使用される argc, argv スタイルの引数を与えます.
        /// この引数は, mecab コマンドと同じ方法で処理されます.
        /// 成功すれば, mecab_t 型のポインタが返ってきます. このポインタを通して解析 を行います. 失敗すれば NULL が返ってきます.
        /// </summary>
        /// <param name="arg"></param>
        /// <returns></returns>
        [DllImport(libmecab)]
        private extern IntPtr mecab_new(int argc, string arg);
         */

        /// <summary>
        /// コンストラクタ
        /// mecab のインスタンスを生成します.
        /// 引数には, 一つの文字列として表現したパラメータを与えます.
        /// 成功すれば, mecab_t 型のポインタが返ってきます. このポインタを通して解析を行います.
        /// </summary>
        /// <param name="arg"></param>
        /// <returns></returns>
        [DllImport(libmecab)]
        private static extern IntPtr mecab_new2(string arg);

        protected IntPtr _mecab_new2(string arg)
        {
            return mecab_new2(arg);
        }

        [DllImport(libmecab)]
        private static extern string mecab_version();

        protected string _mecab_version()
        {
            return mecab_version();
        }

        [DllImport(libmecab)]
        private static extern string mecab_strerror(IntPtr ptrMecab);

        protected string _mecab_strerror()
        {
            return mecab_strerror(this.ptrMecab);
        }

        [DllImport(libmecab)]
        private static extern string mecab_sparse_tostr(IntPtr ptrMecab, string str);
        protected string _mecab_sparse_tostr(string str)
        {
            return mecab_sparse_tostr(this.ptrMecab, str);
        }

        [DllImport(libmecab)]
        private static extern string mecab_sparse_tostr2(IntPtr ptrMecab, string str, int length);
        protected string _mecab_sparse_tostr2(string str, int length)
        {
            return mecab_sparse_tostr2(this.ptrMecab, str, length);
        }

        [DllImport(libmecab)]
        private static extern string mecab_sparse_tostr3(
            IntPtr ptrMecab,
            string strSrc,
            out string strDst,
            int olen
        );
        protected string _mecab_sparse_tostr3(
            string strSrc,
            out string strDst,
            int olen)
        {
            return mecab_sparse_tostr3(
                this.ptrMecab,
                strSrc,
                out strDst,
                olen
            );
        }

        [DllImport(libmecab)]
        private static extern string mecab_nbest_sparse_tostr(IntPtr ptrMecab, int n, string str);
        protected string _mecab_nbest_sparse_tostr(int n, string str)
        {
            return mecab_nbest_sparse_tostr(this.ptrMecab, n, str);
        }

        [DllImport(libmecab)]
        private static extern string mecab_nbest_sparse_tostr2(
            IntPtr ptrMecab,
            int n,
            string str,
            int length
        );
        protected string _mecab_nbest_sparse_tostr2(int n, string str, int length)
        {
            return mecab_nbest_sparse_tostr2(this.ptrMecab, n, str, length);
        }

        [DllImport(libmecab)]
        private static extern string mecab_nbest_sparse_tostr3(
            IntPtr ptrMecab,
            int n,
            string strSrc,
            int length,
            out string strDst,
            int olen
        );
        protected string _mecab_nbest_sparse_tostr3(
            int n,
            string strSrc,
            int length,
            out string strDst,
            int olen)
        {
            return mecab_nbest_sparse_tostr3(
                this.ptrMecab,
                n,
                strSrc,
                length,
                out strDst,
                olen
            );
        }

        [DllImport(libmecab)]
        private static extern int mecab_nbest_init(IntPtr ptrMecab, string strSrc);
        protected int _mecab_nbest_init(string strSrc)
        {
            return mecab_nbest_init(this.ptrMecab, strSrc);
        }

        [DllImport(libmecab)]
        private static extern int mecab_nbest_init2(IntPtr ptrMecab, string strSrc, int length);
        protected int _mecab_nbest_init2(string strSrc, int length)
        {
            return mecab_nbest_init2(this.ptrMecab, strSrc, length);
        }

        [DllImport(libmecab)]
        private static extern string mecab_nbest_next_tostr(IntPtr ptrMecab);
        protected string _mecab_nbest_next_tostr()
        {
            return mecab_nbest_next_tostr(this.ptrMecab);
        }

        [DllImport(libmecab)]
        private static extern string mecab_nbest_next_tostr2(IntPtr ptrMecab, out string strDst, int olen);
        protected string _mecab_nbest_next_tostr2(out string strDst, int olen)
        {
            return mecab_nbest_next_tostr2(this.ptrMecab, out strDst, olen);
        }

        [DllImport(libmecab)]
        private static extern void mecab_destroy(IntPtr ptrMecab);
        protected void _mecab_destroy()
        {
            mecab_destroy(this.ptrMecab);
        }



        public void Dispose()
        {
            GC.SuppressFinalize(this);
        }
    }
}
