/*
 * Decompiled with CFR 0.152.
 */
package org.manjyu.rss.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ManjyuRssDateUtil {
    public static String date2Rfc822String(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        return sdf.format(date);
    }

    public static Date rfc822String2Date(String rfc822string) throws IOException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            return sdf.parse(rfc822string);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                return sdf.parse(rfc822string);
            }
            catch (ParseException e1) {
                throw new IOException("Cannot recognized RFC822 date format: [" + rfc822string + "]", e1);
            }
        }
    }

    public static Date w3cdtfString2Date(String w3cdtfString) throws IOException {
        if ((w3cdtfString = w3cdtfString.replace('T', '_')).length() > 24 && w3cdtfString.charAt(24) == ':') {
            w3cdtfString = w3cdtfString.substring(0, 24) + w3cdtfString.substring(25, w3cdtfString.length());
        }
        if (w3cdtfString.length() > 22 && w3cdtfString.charAt(22) == ':') {
            w3cdtfString = w3cdtfString.substring(0, 22) + w3cdtfString.substring(23, w3cdtfString.length());
        }
        if (w3cdtfString.length() > 19 && w3cdtfString.charAt(19) == ':') {
            w3cdtfString = w3cdtfString.substring(0, 19) + w3cdtfString.substring(20, w3cdtfString.length());
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SZ", Locale.US);
            return sdf.parse(w3cdtfString);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ssZ", Locale.US);
                return sdf.parse(w3cdtfString);
            }
            catch (ParseException e1) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mmZ", Locale.US);
                    return sdf.parse(w3cdtfString);
                }
                catch (ParseException e2) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                        return sdf.parse(w3cdtfString);
                    }
                    catch (ParseException e3) {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM", Locale.US);
                            return sdf.parse(w3cdtfString);
                        }
                        catch (ParseException e4) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy", Locale.US);
                                return sdf.parse(w3cdtfString);
                            }
                            catch (ParseException e5) {
                                throw new IOException("Cannot recognized W3CDTF date format: [" + w3cdtfString + "]", e1);
                            }
                        }
                    }
                }
            }
        }
    }
}

