﻿using System;
using System.Windows;
using System.Windows.Controls;
using Emgu.CV;
using Emgu.CV.Structure;
using Microsoft.Kinect;
using System.ComponentModel;
using ImageManipulationExtensionMethods;

namespace FaceFinder
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        KinectSensor _kinectSensor;

        String faceFileName = "haarcascade_frontalface_default.xml";


        public MainWindow()
        {
            InitializeComponent();

            this.Unloaded += delegate
            {
                _kinectSensor.ColorStream.Disable();
            };

            this.Loaded += delegate
            {
                _kinectSensor = KinectSensor.KinectSensors[0];
                _kinectSensor.ColorStream.Enable();
                _kinectSensor.Start();

                BackgroundWorker bw = new BackgroundWorker();
                bw.RunWorkerCompleted += (a, b) => bw.RunWorkerAsync();
                bw.DoWork += delegate { Pulse(); };
                bw.RunWorkerAsync();
            };


        }


        public void Pulse()
        {
            using (HaarCascade face = new HaarCascade(faceFileName)) //EmguのBinフォルダからdllをCOPYしていないとエラーになる
            {
                var frame = _kinectSensor.ColorStream.OpenNextFrame(100);
                var image = frame.ToOpenCVImage<Rgb, Byte>();
                using (Image<Gray, Byte> gray = image.Convert<Gray, Byte>()) //Convert it to Grayscale
                {
                    //normalizes brightness and increases contrast of the image
                    gray._EqualizeHist();

                    //Detect the faces  from the gray scale image and store the locations as rectangle
                    //The first dimensional is the channel
                    //The second dimension is the index of the rectangle in the specific channel
                    MCvAvgComp[] facesDetected = face.Detect(
                       gray,
                       1.1,
                       10,
                       Emgu.CV.CvEnum.HAAR_DETECTION_TYPE.DO_CANNY_PRUNING,
                       new System.Drawing.Size(20, 20));

                    Image<Rgb, Byte> laughingMan = new Image<Rgb, byte>("neko_02.png");
                    foreach (MCvAvgComp f in facesDetected)
                    {

                        //image.Draw(f.rect, new Rgb(System.Drawing.Color.Blue), 2);
                        var rect = new System.Drawing.Rectangle(f.rect.X - f.rect.Width / 2
                            , f.rect.Y - f.rect.Height / 2
                            , f.rect.Width * 2
                            , f.rect.Height * 2);

                        var newImage = laughingMan.Resize(rect.Width, 
                                                          rect.Height,
                                                          Emgu.CV.CvEnum.INTER.CV_INTER_LINEAR);

                        for (int i = 0; i < (rect.Height); i++)
                        {
                            for (int j = 0; j < (rect.Width); j++)
                            {
                                ///完全ブルーは透過する
                               if (!(newImage[i, j].Blue == 255 && newImage[i, j].Red == 0 && newImage[i, j].Green == 0))
                                   image[i + rect.Y, j + rect.X] = newImage[i, j];
                            }

                        }
                    }

                    Dispatcher.BeginInvoke(new Action(() => { rgbImage.Source = image.ToBitmapSource(); }));
                }
            }
        }
    }
}

