﻿using Microsoft.Kinect;
using System;

namespace sample1_1
{
    class Program
    {
        static void Main(string[] args)
        {
            if (KinectSensor.KinectSensors.Count > 0)
            {
                //センサーのインスタンスを作成する
                KinectSensor sensor = KinectSensor.KinectSensors[0];

                //カメラを初期化する
                sensor.DepthStream.Enable();
                sensor.DepthFrameReady += sensor_DepthFrameReady;

                //マトリックスのように表示する
                Console.ForegroundColor = ConsoleColor.Green;

                //データストリームを開始する
                sensor.Start();
                while (Console.ReadKey().Key != ConsoleKey.Spacebar) { }
            }
            else
            {
                Console.WriteLine("Kinectセンサーを接続してください。");
            }
        }
        static void sensor_DepthFrameReady(object sender, DepthImageFrameReadyEventArgs e)
        {
            using (var depthFrame = e.OpenDepthImageFrame())
            {
                if (depthFrame == null)
                    return;
                short[] bits = new short[depthFrame.PixelDataLength];
                depthFrame.CopyPixelDataTo(bits);
                foreach (var bit in bits)
                    Console.Write(bit);
            }
        }
    }
}
