/*
 BMManager.h
 BISHAMON sample manager
 Copyright (C) 2011 Matchlock, Inc.
 All Rights Reserved.
 */

#ifndef __BM_MANAGER_H__
#define __BM_MANAGER_H__

#include <bm3.h>
#include "BMObject.h"
#include "BMAllocator.h"

class BMBinary;
class BMTexture;
class BMModel;
class BMEffect;

#define MAX_VERTEX_BUFFER_SIZE  (4*1024*1024)

typedef std::map<std::wstring, BMBinary *>	BMBinaryMap;
typedef std::map<std::wstring, BMTexture *> BMTextureMap;
typedef std::map<std::wstring, BMModel *>	BMModelMap;
// ǉ
typedef std::vector<BMEffect*>	BMEffectListType;


class BMManager : public BMObject {

public:
	BMManager(){}
	~BMManager();
	// ǉF
	void Create(LPDIRECT3DDEVICE9 device, const wchar_t* databaseFolder, unsigned int maxVertexBufferSize = MAX_VERTEX_BUFFER_SIZE);

	// ǉF
	static BMManager* GetInstance(){
		return s_instance;
	}
	const std::wstring& GetDatabaseFolder() const {
		return databaseFolder;
	}
	const std::wstring& GetBmslnFolder() const {
		return databaseBmsln;
	}
	const std::wstring& GetTextureFolder() const {
		return databaseTexture;
	}
	const std::wstring& GetModelFolder() const {
		return databaseModel;
	}
	// ---- 

	void Initialize(unsigned int maxVertexBufferSize = MAX_VERTEX_BUFFER_SIZE);
	BMBinary *LoadBinary(std::wstring name);
	void ReleaseBinary(std::wstring name);
	BMEffect *CreateEffect(std::wstring name);
	BMEffect *CreateEffect(const wchar_t *name);
	void ReleaseEffect(BMEffect *effect);
	void DrawEffect(BMEffect *effect);
	void Begin();
	void Begin2D(float width, float height);
	void End();
	void SetView(const ml::matrix44 &view);
	void SetProjection(const ml::matrix44 &projection);
	void GetTotalLifeTime(BMBinary *binary);
	void GetUserData(BMBinary *binary);

	void SetMaxGeneratingScale(float scale);
	void DeviceLost();
	void ResetDevice(IDirect3DDevice9 *device,unsigned int maxVertexBufferSize = MAX_VERTEX_BUFFER_SIZE);

	// ǉF
	void UpdateAllEffect();
	void DrawAllEffect(const D3DXMATRIX* viewMatrix, const D3DXMATRIX* projMatrix);
	void DestroyAllEffect();
	void Destroy();
	// ----- 

private:
	BMTexture *RegisterTexture(std::wstring name, bm3::TextureCategory::Type type);
	BMModel *RegisterModel(std::wstring name);
	BMBinary *RegisterBinary(std::wstring name);

	void ReleaseEffect(BMEffectListType::iterator& iteEffect);

private:
	static BMManager*	s_instance;

	bm3::SequentialVertex vertexManager;
	bm3::StandardHash *hash;
	bm3::DrawInfo   drawInfo;

	BMAllocator allocator;

	std::wstring	databaseFolder;
	std::wstring	databaseBmsln;
	std::wstring	databaseTexture;
	std::wstring	databaseModel;

	std::map<std::wstring, BMBinary *> binaries;
	std::map<std::wstring, BMTexture *> textures;
	std::map<std::wstring, BMModel *> models;

	ml::matrix44    view;
	ml::matrix44    viewInverse;
	ml::matrix44    projection;

	float   maxGeneratingScale;

	LPDIRECT3DDEVICE9 device;

	// ǉFǗXg
	BMEffectListType listEffect;
};

#endif /* __BM_MANAGER_H__ */

