'''OpenGL extension OES.draw_elements_base_vertex

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.draw_elements_base_vertex to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/draw_elements_base_vertex.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.draw_elements_base_vertex import *
from OpenGL.raw.GLES2.OES.draw_elements_base_vertex import _EXTENSION_NAME

def glInitDrawElementsBaseVertexOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawElementsBaseVertexOES.indices size not checked against 'count,type'
glDrawElementsBaseVertexOES=wrapper.wrapper(glDrawElementsBaseVertexOES).setInputArraySize(
    'indices', None
)
# INPUT glDrawRangeElementsBaseVertexOES.indices size not checked against 'count,type'
glDrawRangeElementsBaseVertexOES=wrapper.wrapper(glDrawRangeElementsBaseVertexOES).setInputArraySize(
    'indices', None
)
# INPUT glDrawElementsInstancedBaseVertexOES.indices size not checked against 'count,type'
glDrawElementsInstancedBaseVertexOES=wrapper.wrapper(glDrawElementsInstancedBaseVertexOES).setInputArraySize(
    'indices', None
)
# INPUT glMultiDrawElementsBaseVertexOES.basevertex size not checked against 'drawcount'
# INPUT glMultiDrawElementsBaseVertexOES.count size not checked against 'drawcount'
# INPUT glMultiDrawElementsBaseVertexOES.indices size not checked against 'drawcount'
glMultiDrawElementsBaseVertexOES=wrapper.wrapper(glMultiDrawElementsBaseVertexOES).setInputArraySize(
    'basevertex', None
).setInputArraySize(
    'count', None
).setInputArraySize(
    'indices', None
)
### END AUTOGENERATED SECTION