'''OpenGL extension EXT.draw_elements_base_vertex

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.draw_elements_base_vertex to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/draw_elements_base_vertex.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.draw_elements_base_vertex import *
from OpenGL.raw.GLES2.EXT.draw_elements_base_vertex import _EXTENSION_NAME

def glInitDrawElementsBaseVertexEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawElementsBaseVertexEXT.indices size not checked against 'count,type'
glDrawElementsBaseVertexEXT=wrapper.wrapper(glDrawElementsBaseVertexEXT).setInputArraySize(
    'indices', None
)
# INPUT glDrawRangeElementsBaseVertexEXT.indices size not checked against 'count,type'
glDrawRangeElementsBaseVertexEXT=wrapper.wrapper(glDrawRangeElementsBaseVertexEXT).setInputArraySize(
    'indices', None
)
# INPUT glDrawElementsInstancedBaseVertexEXT.indices size not checked against 'count,type'
glDrawElementsInstancedBaseVertexEXT=wrapper.wrapper(glDrawElementsInstancedBaseVertexEXT).setInputArraySize(
    'indices', None
)
# INPUT glMultiDrawElementsBaseVertexEXT.basevertex size not checked against 'drawcount'
# INPUT glMultiDrawElementsBaseVertexEXT.count size not checked against 'drawcount'
# INPUT glMultiDrawElementsBaseVertexEXT.indices size not checked against 'drawcount'
glMultiDrawElementsBaseVertexEXT=wrapper.wrapper(glMultiDrawElementsBaseVertexEXT).setInputArraySize(
    'basevertex', None
).setInputArraySize(
    'count', None
).setInputArraySize(
    'indices', None
)
### END AUTOGENERATED SECTION