/*
 * Decompiled with CFR 0.152.
 */
package com.mylyane.tools.propedit;

import com.mylyane.afx.IApplication;
import com.mylyane.afx.IStatusInformation;
import com.mylyane.afx.ITask;
import com.mylyane.afx.UIModule;
import com.mylyane.afx.plugin.IPlugin;
import com.mylyane.afx.swing.IIconManager;
import com.mylyane.afx.swing.IUIProvider;
import com.mylyane.afx.swing.IconManager;
import com.mylyane.afx.swing.SwingUIModule;
import com.mylyane.afx.swing.tree.ITreeIconResolver;
import com.mylyane.afx.swing.tree.XComparableTreeNode;
import com.mylyane.lang.CharUtility;
import com.mylyane.lang.CharsBuffer;
import com.mylyane.sound.AudioClipManager;
import com.mylyane.tools.propedit.PreviewTask;
import com.mylyane.tools.propedit.PropeditBundle;
import com.mylyane.tools.propedit.PropertiesEditorKit;
import com.mylyane.tools.propedit.PropertiesUniProvider;
import com.mylyane.tools.propedit.afx.ActionDefinition;
import com.mylyane.tools.propedit.afx.IConstants;
import com.mylyane.tools.propedit.afx.INodeConstants;
import com.mylyane.tools.propedit.afx.IPropertiesUniversalProvider;
import com.mylyane.tools.propedit.afx.model.IPropertiesModel;
import com.mylyane.tools.propedit.afx.model.PropertiesContext;
import com.mylyane.tools.propedit.afx.model.PropertiesModelManager;
import com.mylyane.tools.propedit.ui.EditorTabPane;
import com.mylyane.tools.propedit.ui.PropertiesTreePane;
import com.mylyane.tools.propedit.ui.UniIconManager;
import com.mylyane.ui.DelayStatus;
import com.mylyane.ui.swing.JFontChooser;
import com.mylyane.ui.swing.SimpleTextPane;
import com.mylyane.ui.swing.StatusLabel;
import com.mylyane.ui.swing.XMainFrame;
import com.mylyane.util.MapEntry;
import com.mylyane.util.PropertiesX;
import com.mylyane.util.StopWatch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

final class Main
extends XMainFrame
implements ActionListener,
KeyListener,
TreeSelectionListener,
IConstants,
INodeConstants {
    static final int VALUE_EDITOR_ID = 0;
    static final int PREVIEW_EDITOR_ID = 1;
    private static final int ACTIVE_EDITOR_ID = -1;
    private static final String TREE_ICONs_ROOT = "images/treeicons/";
    private static final Font PREVIEW_FONT = new Font("SansSerif", 0, 13);
    protected static final String APP_TITLE = "Java Properties Editor";
    private static final int OPERATION_MENU_INDEX = 1;
    private static final int PLUGIN_MENU_INDEX = 2;
    private static final int MENUITEM_ID_AS_PREVIEW = 0;
    private static final int MENUITEM_ID_DEL_ON_ALERT = 1;
    private static final int MENUITEM_ID_ASK_ON_NEWENTRY = 2;
    private static final int MENUITEM_ID_PLAYSND = 3;
    private static final int MENUITEM_ID_ASK_NEWFILE = 4;
    static final int SORT_SND = 0;
    static final int ABOUT_SND = 1;
    static final int UPDATE_SND = 2;
    static final int REMOVE_SND = 3;
    static final int ALERT_SND = 4;
    static final int SAVE_SND = 5;
    private JMenuBar main_menu;
    private JMenu check_menu;
    private JToolBar toolbar;
    private JSplitPane splitPane;
    PropertiesTreePane treePane;
    private EditorTabPane edit_pane;
    private StatusLabel status_label;
    private JTree propTree;
    IPropertiesUniversalProvider pprovider;
    private PropertiesEditorKit prop_kit;
    private IIconManager app_icon_mgr;
    private AudioClipManager snd;
    private DelayStatus delay_status;
    private StopWatch stopwatch = new StopWatch();
    private StrGen generator = new StrGen("key.");
    JWindow pop_wnd = null;
    private ITask task;

    public static IApplication GetInstance() {
        return new Main();
    }

    private Main() {
        this(APP_TITLE);
    }

    private Main(String string) {
        super(string);
        this.dialog_title = APP_TITLE;
        super.setFileDescription("properties file (*.properties).");
        super.setFileExtensions("properties");
        this.init();
        this.snd = new AudioClipManager();
        this.snd.loadSounds(this.getClass(), PropeditBundle.getString("propedit.sounds"), '|');
        this.delay_status = new DelayStatus((IStatusInformation)this.status_label, 5000, true);
    }

    public void acceptPlugin(IPlugin iPlugin) {
        JMenuItem jMenuItem = iPlugin.getPluginMenuItem();
        if (jMenuItem != null) {
            this.getJMenuBar().getMenu(2).add(jMenuItem);
        }
    }

    public boolean onFileOpen(File[] fileArray) {
        if (fileArray.length == 0) {
            return false;
        }
        PropertiesModelManager propertiesModelManager = this.pprovider.getPropertiesModelManager();
        boolean bl = true;
        char c = this.pprovider.getSectionDelimiter();
        this.stopwatch.start();
        for (int i = 0; i < fileArray.length; ++i) {
            IPropertiesModel iPropertiesModel;
            String string = null;
            try {
                string = fileArray[i].getCanonicalPath();
                if (propertiesModelManager.isContained(fileArray[i])) {
                    this.alert(PropeditBundle.getString("propedit.alert.fileopend", new Object[]{string}));
                    bl = false;
                    continue;
                }
                iPropertiesModel = propertiesModelManager.addBind(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            PropertiesContext propertiesContext = new PropertiesContext(string);
            this.treePane.addPropertiesNode(propertiesContext, iPropertiesModel.keys(), i == fileArray.length - 1, c);
        }
        this.stopwatch.stop();
        if (bl) {
            this.showStatus("File open: files=" + fileArray.length + ", UseMillis=" + this.stopwatch.getUseMillis());
        }
        this.updateDefalutStatus();
        return bl;
    }

    public boolean onFileSave(File file) {
        try {
            this.saveSelectedProperties(file.getAbsolutePath());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected String getSaveFileName() {
        XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedProperties();
        if (xComparableTreeNode != null) {
            PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
            return propertiesContext.canonical_name;
        }
        return null;
    }

    public void showStatus(String string) {
        this.delay_status.dispatch((Object)string);
    }

    public void alert(String string) {
        this.playSound(4);
        super.alert(string);
    }

    public void warning(String string) {
        super.warning(PropeditBundle.getString("propedit.warn.format", new Object[]{string}));
    }

    public void about() {
        if (this.pop_wnd == null) {
            try {
                Class<?> clazz = super.getClass();
                PropertiesX propertiesX = new PropertiesX(11);
                Object[] objectArray = clazz.getResource("version").openStream();
                propertiesX.load((InputStream)objectArray);
                objectArray.close();
                objectArray = new Object[]{clazz.getResource("images/logo.jpg"), propertiesX.getProperty("application.".concat("name")), propertiesX.getProperty("application.".concat("fullversion")), propertiesX.getProperty("application.".concat("copy.notice"))};
                this.pop_wnd = SwingUIModule.PopupInfomation((String)PropeditBundle.getString("propedit.about.format", objectArray), (Container)((Object)this), (int)-1, (boolean)true);
                this.pop_wnd.setSize(370, 320);
                SwingUIModule.ToCenterByWindow((Object)this.pop_wnd, (Window)((Object)this));
                this.pop_wnd.setVisible(true);
                new Thread("Popup-Infomation-Thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            while (Main.this.pop_wnd.isShowing()) {
                                Thread.sleep(200L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            Main.this.pop_wnd.dispose();
                            Main.this.pop_wnd = null;
                        }
                    }
                }.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.alert(PropeditBundle.getString("propedit.about.msg"));
            }
            this.playSound(4);
        }
    }

    protected Icon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(TREE_ICONs_ROOT.concat(string));
        return uRL != null ? new ImageIcon(uRL) : IconManager.CreateDummyIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIconManager getIconManager() {
        Main main = this;
        synchronized (main) {
            if (this.app_icon_mgr == null) {
                UniIconManager uniIconManager = new UniIconManager();
                Icon[] iconArray = SwingUIModule.CreateImageIcons((String)"icons/file16.gif|icons/open.gif|icons/save.gif|icons/saveas.gif|icons/stop.gif|icons/refresh2.gif|icons/stop.gif|icons/sort.gif|icons/sort.gif|icons/new-entry.gif|icons/on-preview.gif|icons/up-value.gif|icons/undo.gif|icons/del.gif|icons/normalview.gif|icons/on-preview.gif");
                String[] stringArray = SwingUIModule.SplitString((String)KNOWN_ACTIONS, (char)'|');
                for (int i = iconArray.length - 1; i >= 0; --i) {
                    uniIconManager.registerIcon(stringArray[i], iconArray[i]);
                }
                uniIconManager.registerIcon("tree.icon.root", this.createImageIcon("root.jpg"));
                uniIconManager.registerIcon("tree.icon.file", this.createImageIcon("file18.gif"));
                uniIconManager.registerIcon("tree.icon.xfile", this.createImageIcon("file18-invalid.gif"));
                uniIconManager.registerIcon("tree.icon.rnfile", this.createImageIcon("file18-off.gif"));
                uniIconManager.registerIcon("tree.icon.rfile", this.createImageIcon("file18-readonly.gif"));
                uniIconManager.registerIcon("tree.icon.section", this.createImageIcon("prop.jpg"));
                uniIconManager.registerIcon("tree.icon.rnsection", this.createImageIcon("prop-edit.jpg"));
                uniIconManager.registerIcon("tree.icon.leaf", this.createImageIcon("key.jpg"));
                uniIconManager.registerIcon("tree.icon.xleaf", this.createImageIcon("dirty-key.jpg"));
                uniIconManager.registerIcon("tree.icon.rnleaf", this.createImageIcon("key-rename.jpg"));
                this.app_icon_mgr = uniIconManager;
            }
        }
        return this.app_icon_mgr;
    }

    public ITreeIconResolver getTreeIconResolver() {
        return (ITreeIconResolver)this.getIconManager();
    }

    public void release() {
        super.release();
        this.delay_status.terminate();
        this.snd.release();
        this.snd = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = ActionDefinition.ActionCommandToID(actionEvent);
        switch (n) {
            case 0: {
                String string = null;
                if (this.isOptionSelected(4) && (string = (String)JOptionPane.showInputDialog((Component)((Object)this), "Please decide the file name.", APP_TITLE, 3, null, null, "unknown.properties")) == null) break;
                this.pprovider.createProperties(string);
                this.updateDefalutStatus();
                break;
            }
            case 1: {
                super.openFileEvent();
                break;
            }
            case 2: {
                this.saveSelectedProperties(null);
                break;
            }
            case 3: {
                TreePath treePath = this.propTree.getSelectionPath();
                if (treePath == null || this.treePane.isRootNode(treePath.getLastPathComponent())) break;
                super.saveFileEvent();
                break;
            }
            case 4: {
                if (!this.pprovider.closeAllProperties()) break;
                this.showStatus("All file closed.");
                this.updateDefalutStatus();
                break;
            }
            case 5: {
                CharsBuffer.DumpShared();
                break;
            }
            case 6: 
            case 7: {
                TreePath treePath = this.propTree.getSelectionPath();
                if (treePath == null) break;
                XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)treePath.getLastPathComponent();
                if (xComparableTreeNode == null) {
                    return;
                }
                int n2 = xComparableTreeNode.getNodeType();
                if (n2 == 3 || xComparableTreeNode.getChildCount() <= 1) break;
                this.stopwatch.start();
                this.treePane.sortChildren(xComparableTreeNode);
                this.stopwatch.stop();
                this.showStatus("Sort UseMillis=" + this.stopwatch.getUseMillis());
                this.playSound(0);
                if (n2 != 1 && n2 != 2) break;
                this.previewProperties(xComparableTreeNode, true);
                break;
            }
            case 8: {
                this.about();
                break;
            }
            case 9: {
                MapEntry mapEntry = this.askKeyStringPrefix("Please, make a new key string...", this.generator.getPrefix());
                if (mapEntry == null) {
                    return;
                }
                if (mapEntry.k == Boolean.TRUE) {
                    this.generator.reset();
                }
                this.generator.setPrefix((String)mapEntry.v);
                break;
            }
            case 10: {
                XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedProperties();
                if (xComparableTreeNode == null) break;
                PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
                boolean bl = this.task.isAlive();
                if (bl) {
                    this.task.interruptRequest();
                }
                this.stopwatch.start();
                boolean bl2 = this.pprovider.restoreProperties(xComparableTreeNode, propertiesContext.canonical_name);
                this.stopwatch.stop();
                if (!bl2) break;
                propertiesContext.setCanonicalName(propertiesContext.canonical_name);
                this.showStatus("File '" + propertiesContext.name + "' reload, UseMillis=" + this.stopwatch.getUseMillis());
                this.updateDefalutStatus();
                if (!bl) break;
                this.previewProperties(xComparableTreeNode, true);
                break;
            }
            case 11: {
                XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedProperties();
                if (xComparableTreeNode == null) break;
                this.pprovider.unloadProperties(xComparableTreeNode);
                this.updateDefalutStatus();
                break;
            }
            case 12: {
                XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedKey();
                if (xComparableTreeNode == null) break;
                PropertiesContext propertiesContext = this.pprovider.getPropertiesContextFrom(xComparableTreeNode);
                IPropertiesModel iPropertiesModel = this.pprovider.getPropertiesModel(propertiesContext.canonical_name);
                String string = iPropertiesModel.getValue(this.pprovider.solveUncertainKeyStringOf(xComparableTreeNode));
                if (string == null) break;
                JTextComponent jTextComponent = this.edit_pane.getTextEditor(0);
                jTextComponent.setText(new String(CharUtility.ToUnicodeEscape((char[])string.toCharArray())));
                this.behaviorWithUndesirableView(jTextComponent);
                this.showStatus("Escape display");
                break;
            }
            case 13: {
                XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedKey();
                if (xComparableTreeNode == null) break;
                CharsBuffer charsBuffer = CharsBuffer.GetShared((int)2048).append(this.edit_pane.getTextEditor(0).getText());
                charsBuffer.replace("\\\n", "");
                this.pprovider.handlePropertyValueChange(xComparableTreeNode, CharUtility.ReleaseUnicodeEscapeIf((String)charsBuffer.flushToString(), (boolean)false));
                CharsBuffer.Replace((CharsBuffer)charsBuffer);
                PropertiesContext propertiesContext = this.pprovider.getPropertiesContextFrom(xComparableTreeNode);
                this.showStatus("Value update, \"" + propertiesContext.name + "\", key {" + this.pprovider.solveUncertainKeyStringOf(xComparableTreeNode) + "}");
                propertiesContext.setFileStateOr(16);
                this.playSound(2);
                this.propTree.repaint();
                this.updateDefalutStatus();
                break;
            }
            case 15: {
                int n3 = this.propTree.getSelectionCount();
                if (n3 <= 0) break;
                if (n3 > 1) {
                    this.removePropertySelection();
                    break;
                }
                this.removeProperty();
                break;
            }
            case 16: {
                String string;
                if (this.isOptionSelected(2)) {
                    MapEntry mapEntry = this.askKeyStringPrefix("Please, make a new key string...", this.generator.getPrefix());
                    if (mapEntry == null) {
                        return;
                    }
                    if (mapEntry.k == Boolean.TRUE) {
                        this.generator.reset();
                    }
                    string = (String)mapEntry.v;
                } else {
                    string = this.generator.gen();
                }
                int n4 = this.pprovider.addProperty(string, "");
                if (!this.isSuccess(n4, string)) break;
                this.showStatus("Add Property key={" + string + "}, items=" + n4);
                this.updateDefalutStatus();
                break;
            }
            case 17: 
            case 18: {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) {
                    return;
                }
                JMenuItem jMenuItem = (JMenuItem)object;
                object = n == 17 ? this.treePane.getTree() : this.edit_pane.getTextEditor(-1);
                JFontChooser jFontChooser = new JFontChooser();
                JFrame jFrame = jFontChooser.createFontFrame((Component)object);
                jFrame.setTitle(jMenuItem.getText());
                UIModule.ToCenterScreen((Object)jFrame);
                jFrame.setVisible(true);
                break;
            }
            case 19: {
                XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)this.propTree.getLastSelectedPathComponent();
                if (xComparableTreeNode == null) {
                    return;
                }
                int n5 = xComparableTreeNode.getNodeType();
                if (n5 != 1 && n5 != 2) break;
                this.previewProperties(xComparableTreeNode, false);
                break;
            }
            case 20: {
                this.valueChanged(null);
                break;
            }
        }
    }

    private boolean askUserIf(int n, String string, String string2) {
        if (this.isOptionSelected(n)) {
            return JOptionPane.showConfirmDialog((Component)((Object)this), PropeditBundle.getString(string2), string, 0) == 0;
        }
        return true;
    }

    private void removeProperty() {
        int n;
        int n2;
        XComparableTreeNode xComparableTreeNode;
        if (this.propTree.getSelectionCount() == 0) {
            return;
        }
        TreePath treePath = this.propTree.getSelectionPath();
        XComparableTreeNode xComparableTreeNode2 = xComparableTreeNode = treePath == null ? null : (XComparableTreeNode)treePath.getLastPathComponent();
        if (xComparableTreeNode == null || (n2 = xComparableTreeNode.getNodeType()) != 3 && n2 != 2) {
            return;
        }
        PropertiesContext propertiesContext = this.pprovider.getPropertiesContextFrom(xComparableTreeNode);
        if (propertiesContext != null && this.askUserIf(1, "Delete Property entry.", "propedit.ask.delete") && this.isSuccess(n = this.pprovider.removeProperty(xComparableTreeNode), propertiesContext.name)) {
            this.playSound(3);
            this.showStatus("Item remove, \"" + propertiesContext.name + "\", item={" + xComparableTreeNode.toString() + "}, items=" + n);
            this.updateDefalutStatus();
        }
    }

    private void removePropertySelection() {
        int n;
        int n2;
        TreePath[] treePathArray = this.propTree.getSelectionPaths();
        if (treePathArray == null || (n2 = treePathArray.length) == 0) {
            return;
        }
        PropertiesContext propertiesContext = this.pprovider.getPropertiesContextFrom((XComparableTreeNode)treePathArray[0].getLastPathComponent());
        if (propertiesContext != null && this.askUserIf(1, "Delete Property items.", "propedit.ask.delete") && this.isSuccess(n = this.pprovider.removeProperty(treePathArray), propertiesContext.name)) {
            this.playSound(3);
            this.showStatus("Item remove, \"" + propertiesContext.name + "\", items=" + n + ", removed=" + n2);
            this.updateDefalutStatus();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 115) {
            String string = ActionDefinition.IDsToActionCommands(new int[]{13});
            SwingUIModule.DispatchActionPerform((JComponent)this.toolbar, (String)string);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        XComparableTreeNode xComparableTreeNode = (XComparableTreeNode)this.propTree.getLastSelectedPathComponent();
        if (xComparableTreeNode == null) {
            return;
        }
        String string = null;
        Object object = xComparableTreeNode.getUserObject();
        PropertiesContext propertiesContext = null;
        int n = -1;
        if (xComparableTreeNode.getNodeType() == 3) {
            Object object2 = this.treePane.getParentNode(xComparableTreeNode, 1);
            if (object2 == null) {
                return;
            }
            propertiesContext = (PropertiesContext)object2.getUserObject();
            object2 = this.pprovider.solveUncertainKeyStringOf(xComparableTreeNode);
            IPropertiesModel iPropertiesModel = this.pprovider.getPropertiesModel(propertiesContext.canonical_name);
            if (iPropertiesModel == null) {
                this.showStatus("Missing IPropertiesModel not found...");
                return;
            }
            string = iPropertiesModel.getValue((String)object2);
            if (this.isOptionSelected(0)) {
                string = new String(CharUtility.ToUnicodeEscape((char[])string.toCharArray()));
            }
            n = 0;
            this.edit_pane.getTextEditor(n).setText(string);
        } else if (xComparableTreeNode.getNodeType() == 2) {
            this.showStatus("Section \"" + xComparableTreeNode.getUserObject() + "\" items=" + xComparableTreeNode.getChildCount());
            this.previewProperties(xComparableTreeNode, true);
            n = 1;
        } else if (object instanceof PropertiesContext) {
            propertiesContext = (PropertiesContext)object;
            IPropertiesModel iPropertiesModel = this.pprovider.getPropertiesModel(propertiesContext.canonical_name);
            if (iPropertiesModel == null) {
                return;
            }
            n = 1;
            this.previewProperties(xComparableTreeNode, true);
            this.showStatus("File \"" + propertiesContext.name + "\", items=" + iPropertiesModel.size());
        }
        if (n != -1) {
            if (n != 1) {
                this.behaviorWithUndesirableView(this.edit_pane.getTextEditor(n));
            }
            this.edit_pane.setSelectedIndex(n);
        }
        if (propertiesContext != null) {
            super.upDateTitle(new File(propertiesContext.canonical_name));
        }
    }

    protected void updateDefalutStatus() {
        String string;
        if (!this.treePane.isRootNodeEmpty()) {
            CharsBuffer charsBuffer;
            Enumeration enumeration = this.treePane.getRootNode().children();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                charsBuffer = (XComparableTreeNode)enumeration.nextElement();
                PropertiesContext propertiesContext = (PropertiesContext)charsBuffer.getUserObject();
                int n4 = propertiesContext.getFileState();
                if ((n4 & 0x40) != 0) {
                    ++n;
                }
                if ((n4 & 0x20) != 0) {
                    ++n3;
                }
                if ((n4 & 0x10) == 0) continue;
                ++n2;
            }
            charsBuffer = CharsBuffer.GetShared((int)200);
            if (n > 0) {
                charsBuffer.append("loaded files :").add(n);
            }
            if (n2 > 0) {
                charsBuffer.append(charsBuffer.length() > 0 ? ", " : "").append("unpreservation :").add(n2);
            }
            if (n3 > 0) {
                charsBuffer.append(charsBuffer.length() > 0 ? ", " : "").append("uncertain files :").add(n3);
            }
            string = charsBuffer.length() > 0 ? charsBuffer.flushToString() : "Ready.";
            CharsBuffer.Replace((CharsBuffer)charsBuffer);
        } else {
            string = "Ready.";
            super.setTitle(APP_TITLE);
        }
        this.status_label.setDefalut(string);
    }

    private boolean isSuccess(int n, String string) {
        String string2 = null;
        boolean bl = true;
        switch (this.pprovider.getErrorCode(n)) {
            case 0x10000000: {
                string2 = "newKey is invalid...";
                break;
            }
            case 0x20000000: {
                string2 = "key={" + string + "} is already exists.";
                break;
            }
            case 0x30000000: {
                string2 = "File is invalid.";
                break;
            }
            case 0x40000000: {
                string2 = "File is already exits.";
                break;
            }
            case 0x50000000: {
                string2 = "File is readonly.";
                break;
            }
            case 0x60000000: {
                string2 = "The selection over two or more properties node is invalid. item={" + string + '}';
                break;
            }
            case -268435456: {
                string2 = "Operation failed, item={" + string + '}';
            }
        }
        if (string2 != null) {
            this.showStatus(string2);
            this.updateDefalutStatus();
            bl = false;
        }
        return bl;
    }

    void behaviorWithUndesirableView(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            jTextComponent = this.edit_pane.getTextEditor(-1);
        }
        jTextComponent.select(0, 0);
    }

    IUIProvider getTextComponentPane(int n) {
        return (IUIProvider)this.edit_pane.getComponent(n);
    }

    private void playSound(int n) {
        if (!this.isOptionSelected(3)) {
            this.snd.play(n);
        }
    }

    private MapEntry askKeyStringPrefix(String string, String string2) {
        JOptionPane jOptionPane = SwingUIModule.CreateStdInputPane((String)string, (String)string2);
        JDialog jDialog = jOptionPane.createDialog((Component)((Object)this), APP_TITLE);
        JCheckBox jCheckBox = new JCheckBox("The counter is reset :" + this.generator.getNum());
        jCheckBox.setHorizontalAlignment(0);
        jDialog.getContentPane().add((Component)jCheckBox, "South");
        jDialog.pack();
        jDialog.setVisible(true);
        Object object = jOptionPane.getInputValue();
        if (object == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return new MapEntry((Object)(jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE), object);
    }

    private void previewProperties(XComparableTreeNode xComparableTreeNode, boolean bl) {
        PropertiesContext propertiesContext = this.pprovider.getPropertiesContextFrom(xComparableTreeNode);
        if (propertiesContext == null) {
            return;
        }
        IPropertiesModel iPropertiesModel = this.pprovider.getPropertiesModel(propertiesContext.canonical_name);
        if (iPropertiesModel == null) {
            return;
        }
        Object[] objectArray = new Object[]{xComparableTreeNode, this.pprovider, this.prop_kit.getDocumentManipulator(), iPropertiesModel, new Boolean(bl)};
        if (this.task == null || !this.task.isAlive()) {
            this.task = new PreviewTask(new ITask.ITaskCallBack(){

                public void onTaskDone() {
                    Main.this.behaviorWithUndesirableView(null);
                }
            });
            this.task.setDefaultParameter((Object)objectArray);
            this.task.begin();
        } else if (this.task.isAlive()) {
            this.task.interruptRequest();
            this.task.updateParameter((Object)objectArray);
        }
    }

    private boolean isOptionSelected(int n) {
        return this.check_menu.getItem(n).isSelected();
    }

    private String getDefaultMenuParam() {
        return "File\nNew Properties|Open properties|-|Save Current properties|Save as ...|-|Close Current properties|-|Exit tool\n0|1|-|2|3|-|11|-|5;Preference\nSet tree font|Set editor font|Set key string prefix\n17|18|9;Plugin\n\n;Infomation\nAbout this tool|!Go to Support page\n8|-1\n";
    }

    private void addCheckBoxItemTo(JMenu jMenu, String string, boolean bl) {
        jMenu.add(new JCheckBoxMenuItem(PropeditBundle.getString(string), bl));
    }

    private void init() {
        super.getContentPane().setLayout(new BorderLayout());
        Object object = PropeditBundle.getString("propedit.menu");
        if (((String)object).equals("propedit.menu")) {
            object = this.getDefaultMenuParam();
        }
        this.main_menu = SwingUIModule.BuildJMenuBarByParamsEx((String)object, (char)';', (ActionListener)this);
        this.check_menu = new JMenu("Options");
        this.addCheckBoxItemTo(this.check_menu, "propedit.options.escapevalue", false);
        this.addCheckBoxItemTo(this.check_menu, "propedit.options.askondelete", true);
        this.addCheckBoxItemTo(this.check_menu, "propedit.options.askonnew", false);
        this.addCheckBoxItemTo(this.check_menu, "propedit.options.playsound", false);
        this.addCheckBoxItemTo(this.check_menu, "propedit.options.asknewfilename", true);
        this.main_menu.getMenu(1).add(this.check_menu);
        this.main_menu.setBorder(BorderFactory.createBevelBorder(1));
        SwingUIModule.SetAcceleratorTo((JMenuBar)this.main_menu, (String)PropeditBundle.getString("propedit.menu.accelerators.0"));
        SwingUIModule.SetAcceleratorTo((JMenuBar)this.main_menu, (String)PropeditBundle.getString("propedit.menu.accelerators.1"));
        super.setJMenuBar(this.main_menu);
        object = (IconManager)this.getIconManager();
        this.treePane = new PropertiesTreePane();
        this.pprovider = PropertiesUniProvider.GetInstance((IApplication)this);
        this.pprovider.setTreeProvider(this.treePane);
        this.pprovider.init(this);
        this.treePane.initTree(null, this, this.pprovider, this.getTreeIconResolver());
        this.treePane.init();
        this.treePane.setPreferredSize(new Dimension(240, 500));
        this.propTree = this.treePane.getTree();
        Serializable serializable = SwingUIModule.CreateIconToolBarByParamsEx((String)(ActionDefinition.IDsToActionCommands(new int[]{0, 1, 2, 3, Integer.MIN_VALUE, 10, 11, 7, Integer.MIN_VALUE, 16, 12, 13, 32782, 15}) + '\n' + PropeditBundle.getString("propedit.toolbar.tips")), (int)0, (int)1, (ActionListener)this, (IIconManager)object);
        this.getContentPane().add((Component)serializable, "North");
        this.toolbar = serializable;
        object = new EditorTabPane();
        serializable = new JTextArea();
        ((JTextComponent)serializable).setMargin(new Insets(1, 1, 1, 1));
        ((JTextArea)serializable).setLineWrap(false);
        serializable.addKeyListener(this);
        ((JTabbedPane)object).insertTab("Property value.", null, (Component)new SimpleTextPane((JTextComponent)serializable, null), "", 0);
        serializable = new PropertiesEditorKit();
        this.prop_kit = serializable;
        _3 _32 = new _3();
        _32.setEditorKit((EditorKit)serializable);
        _32.setFont(PREVIEW_FONT);
        SimpleTextPane simpleTextPane = new SimpleTextPane((JTextComponent)_32, null);
        simpleTextPane.getViewport().setBackground(new Color(240, 240, 245));
        ((JTabbedPane)object).insertTab("Preview.", null, (Component)simpleTextPane, "", 1);
        this.edit_pane = object;
        this.edit_pane.setPreferredSize(new Dimension(400, 500));
        this.splitPane = new JSplitPane(1, true, (Component)((Object)this.treePane), this.edit_pane);
        this.splitPane.setDividerSize(8);
        this.splitPane.setDividerLocation(230);
        this.splitPane.setOneTouchExpandable(true);
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)this.splitPane, "Center");
        serializable = new StatusLabel("Ready.");
        ((Container)object).add((Component)serializable, "South");
        this.status_label = serializable;
        this.getContentPane().add((Component)object, "Center");
    }

    private void saveSelectedProperties(String string) {
        try {
            XComparableTreeNode xComparableTreeNode = this.treePane.currentSelectedProperties();
            if (xComparableTreeNode != null && this.pprovider.savePropertiesAs(xComparableTreeNode, string)) {
                PropertiesContext propertiesContext = (PropertiesContext)xComparableTreeNode.getUserObject();
                this.showStatus("File \"" + propertiesContext.name + "\" was preserved.");
                this.updateDefalutStatus();
                this.propTree.repaint();
                this.playSound(5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final class _3
    extends JTextPane {
        private _3() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }

    private static final class StrGen {
        int suffix_num = 0;
        String prefix;

        StrGen(String string) {
            this.prefix = string;
        }

        void reset() {
            this.suffix_num = 0;
        }

        int getNum() {
            return this.suffix_num;
        }

        String gen() {
            return CharsBuffer.GetShared((int)128).append(this.prefix).append(this.suffix_num++).flushToString();
        }

        String getPrefix() {
            return this.prefix;
        }

        void setPrefix(String string) {
            this.prefix = string;
        }
    }
}

