/*
copyright (c) 2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include <stdio.h>


int
main (int   argc,
      char *argv[])
{
  char buf[BUFSIZ];

  fputs ("static const char *gtk_win32_default_css = ", stdout);
  while (fgets (buf, sizeof (buf) / sizeof (char) - 1, stdin))
    {
      char *p;

      fputs ("\n  \"", stdout);
      for (p = buf; *p != '\0'; p++)
        switch (*p)
          {
            case '\a': fputs ("\\a", stdout); break;
            case '\b': fputs ("\\b", stdout); break;
            case '\f': fputs ("\\f", stdout); break;
            case '\n': fputs ("\\n", stdout); break;
            case '\r': fputs ("\\r", stdout); break;
            case '\t': fputs ("\\t", stdout); break;
            case '\v': fputs ("\\v", stdout); break;
            case '\\': fputs ("\\\\", stdout); break;
            case '\?': fputs ("\\\?", stdout); break;
            case '\'': fputs ("\\\'", stdout); break;
            case '\"': fputs ("\\\"", stdout); break;
            default:
              if (isprint (*p))
                fputc (*p, stdout);
              else
                printf ("\\%03o", (unsigned char)*p);
          }
      fputc ('\"', stdout);
    }
  fputs (";\n", stdout);
  return 0;
}
