/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Fine Kernel Project, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Fine Kernel Project, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/SRFParser.H>
#include <FK/Error.H>
#include <algorithm>

using namespace std;

fk_SRFParser::fk_SRFParser(void)
{
	return;
}

fk_SRFParser::~fk_SRFParser()
{
	return;
}

bool fk_SRFParser::ReadSRFFile(string argFileName)
{
	FILE					*srfFP;
	vector<fk_Vector>		vData;
	vector< vector<int> >	lIndex;

	if(meshData == (fk_ParserData *)NULL) return false;

	meshData->Init();

	if((srfFP = fopen(argFileName.c_str(), "r")) == (FILE *)NULL) {
		return false;
	}

	if(CheckSRFFile(srfFP) == false) {
		fclose(srfFP);
		return false;
	}

	if(ReadSRFVertexData(srfFP, &vData) == false) {
		fclose(srfFP);
		return false;
	}

	if(ReadSRFPolygonData(srfFP, int(vData.size())-1, &lIndex) == false) {
		fclose(srfFP);
		return false;
	}

	fclose(srfFP);
	return meshData->MakeMesh(&vData, &lIndex);
}

bool fk_SRFParser::CheckSRFFile(FILE *argSRF_FP)
{
	char		buffer[512];
	string		lineStr;
	char		*eofStatus;

	eofStatus = fgets(buffer, 500, argSRF_FP);
	lineStr = buffer;
	if(lineStr.find("SURF") == string::npos) return false;
	return true;
}


bool fk_SRFParser::ReadSRFVertexData(FILE *argSRF_FP,
									 vector<fk_Vector> *argVData)
{
	char		buffer[1024];
	string		segName, strLine;
	double		tmpX, tmpY, tmpZ;
	fk_Vector	tmpVec;
	char		*eofStatus;


	argVData->clear();
	eofStatus = fgets(buffer, 1023, argSRF_FP);
	while((feof(argSRF_FP) == 0 && eofStatus != (char *)NULL)) {
		strLine = buffer;
		segName = PopWord(&strLine);
		if(segName == "V") {
			tmpX = Str2Double(PopWord(&strLine));
			tmpY = Str2Double(PopWord(&strLine));
			tmpZ = Str2Double(PopWord(&strLine));
			tmpVec.set(tmpX, tmpY, tmpZ);
			argVData->push_back(tmpVec);
		} else {
			break;
		}

		eofStatus = fgets(buffer, 511, argSRF_FP);
	}

	if(segName == "F") return true;
	return false;
}

bool fk_SRFParser::ReadSRFPolygonData(FILE *argSRF_FP, int argMaxID,
									  vector< vector<int> > *argLIndex)
{
	vector<int>							polyIndex;
	char								buffer[1024];
	string								lineStr, numStr, keyStr;
	int									vID;
	char								*eofStatus = &buffer[0];
	bool								faceFlg, firstFlg;

	argLIndex->clear();
	polyIndex.clear();

	lineStr = "F";
	faceFlg = false;
	firstFlg = true;

	while(feof(argSRF_FP) == 0 && eofStatus != (char *)NULL) {

		if(firstFlg == false) {
			lineStr = buffer;
		} else {
			firstFlg = false;
		}
			
		eofStatus = fgets(buffer, 1023, argSRF_FP);

		keyStr = PopWord(&lineStr);

		if(keyStr == "F") {
			if(faceFlg == false) {
				faceFlg = true;
				continue;
			} else {
				fk_Printf("Error Code 1");
				return false;
			}
		}

		if(keyStr == "E") {
			if(faceFlg == true) {
				faceFlg = false;
				//reverse(polyIndex.begin(), polyIndex.end());
				argLIndex->push_back(polyIndex);
				polyIndex.clear();
				continue;
			}
		}

		if(faceFlg == false) continue;

		if(keyStr == "V") {
			numStr = PopWord(&lineStr);
			while(numStr.empty() == false) {
				vID = Str2Int(numStr);
				if(vID < 0 || vID > argMaxID) {
					return false;
				}
				polyIndex.push_back(vID+1);
				numStr = PopWord(&lineStr);
			}
		}
	}

	return true;
}
