/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <TinyFK/TFK_Window.h>
#include "TFK_API.h"

using namespace std;

TFK_Window::TFK_Window(void)
{
	base = TFK_API::getBasePointer();
	winBase = base->getWindowBase();
	return;
}

TFK_Window::TFK_Window(const TFK_Window &argW)
{
	base = argW.base;
	winBase = argW.winBase;
}

TFK_Window::~TFK_Window()
{
	check();
	return;
}

TFK_Window & TFK_Window::operator =(const TFK_Window &argW)
{
	base = argW.base;
	winBase = argW.winBase;

	return *this;
}

void TFK_Window::setBaseSize(int argW, int argH)
{
	winBase->setBaseSize(argW, argH);
	return;
}

void TFK_Window::setBasePosition(int argX, int argY)
{
	winBase->setBasePosition(argX, argY);
	return;
}

void TFK_Window::setCanvas(int argX, int argY, int argW, int argH)
{
	winBase->setCanvas(argX, argY, argW, argH);
	return;
}

void TFK_Window::open(void)
{
	winBase->openWindow();
	return;
}

void TFK_Window::draw(void)
{
	winBase->drawWindow();
	return;
}

bool TFK_Window::wait(void)
{
	return winBase->waitEvent();
}

bool TFK_Window::wait(double argTime)
{
	return winBase->waitEvent(argTime);
}

bool TFK_Window::check(void)
{
	return winBase->checkEvent();
}

void TFK_Window::sleep(double argTime)
{
	winBase->sleepTime(argTime);
	return;
}

void TFK_Window::setBGColor(double argR, double argG, double argB)
{
	base->setBGColor(argR, argG, argB);
	return;
}

void TFK_Window::setBlendMode(bool argMode)
{
	winBase->setBlendMode(argMode);
	return;
}

bool TFK_Window::getBlendMode(void)
{
	return winBase->getBlendMode();
}

void TFK_Window::setESCExitMode(bool argMode)
{
	winBase->setESCExitMode(argMode);
	return;
}

void TFK_Window::clearAllPoint(void)
{
	base->getPointBase()->clear(-1);
	return;
}

void TFK_Window::clearAllLine(void)
{
	base->getLineBase()->clear(-1);
	return;
}

void TFK_Window::clearAllPolygon(void)
{
	base->getPolygonBase()->clear(-1);
	return;
}

void TFK_Window::clearAllBlock(void)
{
	base->getBlockBase()->clear(-1);
	return;
}

void TFK_Window::clearAllSphere(void)
{
	base->getSphereBase()->clear(-1);
	return;
}

void TFK_Window::clearAllPrism(void)
{
	base->getPrismBase()->clear(-1);
	return;
}

void TFK_Window::clearAllCone(void)
{
	base->getConeBase()->clear(-1);
	return;
}

void TFK_Window::clearAllMesh(void)
{
	base->getMeshBase()->clear(-1);
	return;
}

void TFK_Window::clearAllTexture(void)
{
	base->getTextureBase()->clear(-1);
	return;
}

void TFK_Window::clearAllLight(void)
{
	base->getLightBase()->clear(-1);
	return;
}

void TFK_Window::setAllPointPalette(int argCID)
{
	base->getPointBase()->changePalette(-1, argCID);
	return;
}

void TFK_Window::setAllLinePalette(int argCID)
{
	base->getLineBase()->changePalette(-1, argCID);
	return;
}

void TFK_Window::setAllPolygonPalette(int argCID)
{
	base->getPolygonBase()->changePalette(-1, argCID);
	return;
}

void TFK_Window::setDefaultPointPalette(int argCID)
{
	base->getPointBase()->setDefaultPalette(argCID);
	return;
}

void TFK_Window::setDefaultLinePalette(int argCID)
{
	base->getLineBase()->setDefaultPalette(argCID);
	return;
}

void TFK_Window::setDefaultPolygonPalette(int argCID)
{
	base->getPolygonBase()->setDefaultPalette(argCID);
	return;
}

void TFK_Window::setAllPointSize(double argSize)
{
	base->getPointBase()->setSize(-1, argSize);
	return;
}

void TFK_Window::setAllLineWidth(double argWidth)
{
	base->getLineBase()->setWidth(-1, argWidth);
	return;
}

void TFK_Window::setDefaultPointSize(double argSize)
{
	base->getPointBase()->setDefaultSize(argSize);
	return;
}

void TFK_Window::setDefaultLineWidth(double argWidth)
{
	base->getLineBase()->setDefaultWidth(argWidth);
	return;
}

bool TFK_Window::getMouseStatus(int argButton)
{
	return winBase->getMouseStatus(argButton);
}

fk_Vector TFK_Window::getMousePosition(void)
{
	return winBase->getMousePosition();
}

fk_Vector TFK_Window::waitMouse(int argButton)
{
	return winBase->waitMouse(argButton);
}

bool TFK_Window::getKeyStatus(char argC)
{
	return winBase->getKeyStatus(argC);
}

bool TFK_Window::getSpecialKeyStatus(TFK_SpecialKey argK)
{
	return winBase->getSpecialKeyStatus(argK);
}

void TFK_Window::makeButton(int argID, int argType,
							int argX, int argY, int argW, int argH,
							string argCaption)
{
	winBase->makeButton(argID, argType, argX, argY, argW, argH, argCaption);
	return;
}

bool TFK_Window::getButtonStatus(int argID)
{
	return winBase->getButtonStatus(argID);
}

void TFK_Window::setButtonStatus(int argID, bool argStatus)
{
	winBase->setButtonStatus(argID, argStatus);
	return;
}

void TFK_Window::makeTextBox(int argID, int argX, int argY,
							 int argW, int argH, string argText)
{
	winBase->makeTextBox(argID, argX, argY, argW, argH, argText);
	return;
}

string TFK_Window::getTextBoxString(int argID)
{
	return winBase->getTextBoxString(argID);
}

void TFK_Window::setTextBoxString(int argID, string argText)
{
	winBase->setTextBoxString(argID, argText);
	return;
}

void TFK_Window::makeGroup(int argID, int argX, int argY,
						   int argW, int argH)
{
	winBase->makeGroup(argID, argX, argY, argW, argH);
	return;
}

void TFK_Window::entryButton(int argBID, int argGID)
{
	winBase->entryButton(argBID, argGID);
	return;
}

void TFK_Window::entryTextBox(int argTID, int argGID)
{
	winBase->entryTextBox(argTID, argGID);
	return;
}

string TFK_Window::fileChooser(int argMode)
{
	return winBase->fileChooser(argMode);
}

fk_Color TFK_Window::colorChooser(void)
{
	return winBase->colorChooser();
}

fk_Color TFK_Window::colorChooser(fk_Color argCol)
{
	return winBase->colorChooser(argCol);
}

void TFK_Window::put(const char *argFormat, ...)
{
	va_list		ap;
	char		buffer[1024];

	va_start(ap, argFormat);
	vsnprintf(buffer, 1023, argFormat, ap);
	va_end(ap);
	winBase->putString(string(buffer));
	return;
}

void TFK_Window::put(string argStr)
{
	winBase->putString(argStr);
	return;
}

void TFK_Window::openPutWindow(int argW, int argH)
{
	winBase->openPutWindow(argW, argH);
	return;
}

void TFK_Window::openPutWindow(int argX, int argY, int argW, int argH)
{
	winBase->openPutWindow(argX, argY, argW, argH);
	return;
}

void TFK_Window::closePutWindow(void)
{
	winBase->closePutWindow();
	return;
}

void TFK_Window::clearPutWindow(void)
{
	winBase->clearPutWindow();
	return;
}

bool TFK_Window::snap(string argStr)
{
	if(argStr.length() == 0) return false;
	return winBase->snapImage(argStr);
}

bool TFK_Window::save(string argFile, bool argMode)
{
	if(argFile.length() == 0) return false;
	if(argMode == true) {
		return base->saveFile(argFile, FK_TEXT_FILE);
	}
	return base->saveFile(argFile);
}

bool TFK_Window::load(string argFile, bool argMode)
{
	if(argFile.length() == 0) return false;
	if(argMode == true) {
		return base->loadFile(argFile, FK_TEXT_FILE);
	}
	return base->loadFile(argFile);
}

void TFK_Window::message(string argStr)
{
	winBase->message(argStr);
	return;
}

void TFK_Window::alert(string argStr)
{
	winBase->alert(argStr);
	return;
}

bool TFK_Window::ask(string argStr)
{
	return winBase->ask(argStr);
}

void TFK_Window::setPlaneMode(bool argFlg)
{
	base->setPlaneMode(argFlg);
	return;
}

bool TFK_Window::getPlaneMode(void)
{
	return base->getPlaneMode();
}
