/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <TinyFK/TFK_MultModel.h>
#include "TFK_API.h"

static fk_Vector dummy(0.0, 0.0, 0.0);
static fk_Angle dummyAng(0.0, 0.0, 0.0);

TFK_MultModel::TFK_MultModel(void)
{
	return;
}

TFK_MultModel::~TFK_MultModel()
{
	return;
}

bool TFK_MultModel::isArive(void)
{
	if(id == -1) return false;
	if(base->isArive(id) == false) {
		id = -1;
		model = (fk_Model *)NULL;
		return false;
	}
	return true;
}

void TFK_MultModel::setPos(double argX, double argY, double argZ)
{
	if(isArive() == false) return;

	model->glMoveTo(argX, argY, argZ);
	return;
}

void TFK_MultModel::setPos(fk_Vector argPos)
{
	if(isArive() == false) return;

	model->glMoveTo(argPos);
	return;
}

void TFK_MultModel::setVec(double argX, double argY, double argZ)
{
	if(isArive() == false) return;

	model->glVec(argX, argY, argZ);
	return;
}

void TFK_MultModel::setVec(fk_Vector argVec)
{
	if(isArive() == false) return;

	model->glVec(argVec);
	return;
}

void TFK_MultModel::setUpvec(double argX, double argY, double argZ)
{
	if(isArive() == false) return;

	model->glUpvec(argX, argY, argZ);
	return;
}

void TFK_MultModel::setUpvec(fk_Vector argUV)
{
	if(isArive() == false) return;

	model->glUpvec(argUV);
	return;
}

void TFK_MultModel::setAngle(double argH, double argP, double argB)
{
	if(isArive() == false) return;

	model->glAngle(argH, argP, argB);
	return;
}

void TFK_MultModel::setAngle(fk_Angle argAngle)
{
	if(isArive() == false) return;

	model->glAngle(argAngle);
	return;
}

fk_Vector TFK_MultModel::getPos(void)
{
	if(isArive() == false) return dummy;

	return model->getPosition();
}

fk_Vector TFK_MultModel::getVec(void)
{
	if(isArive() == false) return dummy;

	return model->getVec();
}

fk_Vector TFK_MultModel::getUpvec(void)
{
	if(isArive() == false) return dummy;

	return model->getUpVec();
}

fk_Angle TFK_MultModel::getAngle(void)
{
	if(isArive() == false) return dummyAng;

	return model->getAngle();
}

void TFK_MultModel::rotate(int argAxis, double argAngle, bool argFlg)
{
	fk_Axis		axis = fk_X;

	if(isArive() == false) return;

	switch(argAxis) {
	  case 1:
		axis = fk_X;
		break;

	  case 2:
		axis = fk_Y;
		break;

	  case 3:
		axis = fk_Z;
		break;

	  default:
		return;
	}

	if(argFlg == true) {
		model->glRotateWithVec(0.0, 0.0, 0.0, axis, argAngle);
	} else {
		model->glRotate(0.0, 0.0, 0.0, axis, argAngle);
	}

	return;
}

void TFK_MultModel::rotate(fk_Vector argOrg, fk_Vector argAxis,
					   double argAngle, bool argFlg)
{
	if(isArive() == false) return;

	if(argFlg == true) {
		model->glRotateWithVec(argOrg, argAxis, argAngle);
	} else {
		model->glRotate(argOrg, argAxis, argAngle);
	}

	return;
}

void TFK_MultModel::translate(double argX, double argY, double argZ)
{
	if(isArive() == false) return;

	model->glTranslate(argX, argY, argZ);
	return;
}

void TFK_MultModel::translate(fk_Vector argVec)
{
	if(isArive() == false) return;

	model->glTranslate(argVec);
	return;
}

void TFK_MultModel::focus(double argX, double argY, double argZ)
{
	if(isArive() == false) return;

	model->glFocus(argX, argY, argZ);
	return;
}

void TFK_MultModel::focus(fk_Vector argPos)
{
	if(isArive() == false) return;

	model->glFocus(argPos);
	return;
}

void TFK_MultModel::setPalette(int argCID)
{
	if(isArive() == false) return;

	base->changePalette(id, argCID);
	return;
}

int TFK_MultModel::getPalette(void)
{
	if(isArive() == false) return -1;
	return base->getPalette(id);
}

void TFK_MultModel::clear(void)
{
	if(isArive() == false) return;

	base->clear(id);
	id = -1;
	model = (fk_Model *)NULL;
	return;
}

void TFK_MultModel::setParent(TFK_MultModel *argModel)
{
	if(argModel == (TFK_MultModel *)NULL) return;
	model->setParent(argModel->model);
	return;
}

void TFK_MultModel::deleteParent(void)
{
	model->deleteParent();
	return;
}

bool TFK_MultModel::haveParent(void)
{
	if(model->getParent() == (fk_Model *)NULL) return false;
	return true;
}
