/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <TinyFK/TinyFK.h>

int main(int, char *[])
{
	TFK_Window	win;
	TFK_Polygon	poly;
	TFK_Palette	pal;
	bool		moveFlag;

	win.setBaseSize(520, 640);
	win.setCanvas(10, 10, 500, 500);
	pal.setColor(1, 1.0, 0.0, 0.0);
	pal.setColor(2, 0.0, 1.0, 0.0);
	pal.setColor(3, 0.0, 0.0, 1.0);

	// 各ボタン生成
	win.makeButton(1, 1, 120, 560, 60, 30, "Right");
	win.makeButton(2, 1, 20, 560, 60, 30, "Left");
	win.makeButton(3, 1, 70, 520, 60, 30, "Up");
	win.makeButton(4, 1, 70, 600, 60, 30, "Down");
	win.makeButton(5, 1, 200, 520, 80, 30, "Create");
	win.makeButton(6, 1, 200, 560, 80, 30, "Save");
	win.makeButton(7, 1, 200, 600, 80, 30, "Load");

	// ここからはラジオボタン
	win.makeButton(8, 5, 320, 530, 60, 20, "Red");
	win.makeButton(9, 5, 320, 560, 60, 20, "Green");
	win.makeButton(10, 5, 320, 590, 60, 20, "Blue");

	// スイッチボタンの作成
	win.makeButton(11, 3, 410, 530, 100, 30, "Rectangle");

	// 終了ボタン
	win.makeButton(12, 1, 430, 600, 80, 30, "Exit");

	// 色用グループ生成
	win.makeGroup(1, 310, 520, 80, 110);

	// グループにラジオボタンを登録
	win.entryButton(8, 1);
	win.entryButton(9, 1);
	win.entryButton(10, 1);

	win.open();

	// 「Red」をあらかじめ選択した状態にしておく
	win.setButtonStatus(8, true);

	// ESC キーで突然終了しないようにしておく
	win.setESCExitMode(false);

	// 「Create」ボタンが押されたときに生成されるように設定
	moveFlag = true;

	while(win.check() == true) {
		win.sleep(0.01);

		if(win.getButtonStatus(12) == true) {
			// 終了ボタンがおされているとき, ループ脱出
			break;
		}

		if(win.getButtonStatus(1) == true) {
			// 「Right」ボタンが押されたとき
			poly.translate(0.1, 0.0);
			moveFlag = true;
		}
		if(win.getButtonStatus(2) == true) {
			// 「Left」ボタンが押されたとき
			poly.translate(-0.1, 0.0);
			moveFlag = true;
		}
		if(win.getButtonStatus(3) == true) {
			// 「Up」ボタンが押されたとき
			poly.translate(0.0, 0.1);
			moveFlag = true;
		}
		if(win.getButtonStatus(4) == true) {
			// 「Down」ボタンが押されたとき
			poly.translate(0.0, -0.1);
			moveFlag = true;
		}

		if(win.getButtonStatus(5) == true && moveFlag == true) {
			// 「Create」ボタンが押されたとき
			if(win.getButtonStatus(11) == true) {
				// スイッチボタンが ON の場合, 四角形描画
				poly.create(4);
				poly.move(0, -0.5, -0.5);
				poly.move(1, 0.5, -0.5);
				poly.move(2, 0.5, 0.5);
				poly.move(3, -0.5, 0.5);
			} else {
				// スイッチボタンが OFF の場合, 三角形描画
				poly.create(3);
				poly.move(0, 0.0, 0.5);
				poly.move(1, -0.5, -0.5);
				poly.move(2, 0.5, -0.5);
			}
			// 多角形が動かされるまで, 新たに生成しないようにする
			moveFlag = false;
		}
		if(win.getButtonStatus(6) == true) {
			// 「Save」ボタンが押されたとき
			win.save(win.fileChooser(1));
		}
		if(win.getButtonStatus(7) == true) {
			// 「Load」ボタンが押されたとき
			win.load(win.fileChooser(2));
		}
		if(win.getButtonStatus(8) == true) {
			// 「Red」が選択されているとき
			poly.setPalette(1);
		}
		if(win.getButtonStatus(9) == true) {
			// 「Green」が選択されているとき
			poly.setPalette(2);
		}
		if(win.getButtonStatus(10) == true) {
			// 「Blue」が選択されているとき
			poly.setPalette(3);
		}

		win.draw();
	}

	// 終了する前に, データ保存の確認
	if(win.ask("Save Data?") == true) {
		win.save(win.fileChooser(1));
	}

	return 0;
}
