/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/RDSParser.h>

fk_RDSParser::fk_RDSParser(void)
{
	return;
}

fk_RDSParser::~fk_RDSParser()
{
	return;
}

bool fk_RDSParser::readRDSFile(string argFileName, bool argSolidFlg)
{
	FILE					*rdsFP;
	vector<fk_Vector>		vData;
	vector<int>				vMap;
	vector< vector<int> >	lIndex;

	if(meshData == (fk_ParserData *)NULL) return false;

	if((rdsFP = fopen(argFileName.c_str(), "r")) == (FILE *)NULL) {
		return false;
	}

	if(CheckRDSFile(rdsFP) == false) {
		fclose(rdsFP);
		return false;
	}

	if(ReadRDSVertexData(rdsFP, &vData, &vMap, argSolidFlg) == false) {
		fclose(rdsFP);
		return false;
	}

	fseek(rdsFP, 0L, 0);

	if(ReadRDSPolygonData(rdsFP, &lIndex, &vMap) == false) {
		fclose(rdsFP);
		return false;
	}

	fclose(rdsFP);

	meshData->Init();

	return meshData->MakeMesh(&vData, &lIndex,
							  (vector<int> *)NULL, argSolidFlg);
}

bool fk_RDSParser::CheckRDSFile(FILE *argFP)
{
	char		buffer[256];
	string		lineString;

	fgets(buffer, 255, argFP);
	lineString = buffer;

	if(lineString.find("3DC") != 0) {
		return false;
	}

	return true;
}

bool fk_RDSParser::ReadRDSVertexData(FILE *argFP, vector<fk_Vector> *argVData,
									 vector<int> *argVMap, bool solidFlg)
{
	char					buffer[512];
	string					lineStr;
	string					coordStr;
	fk_Vector				tmpVec;
	bool					startFlg, existFlg;
	int						tabNum, vTagNum;
	string::size_type		numS;
	unsigned int			size;
	int						index;
	char					*eofStatus;
	fk_HeapBase<fk_Vector>	heap;


	startFlg = false;
	vTagNum = 0;
	tabNum = 0;
	argVMap->clear();

	eofStatus = fgets(buffer, 511, argFP);
	while(feof(argFP) == 0 && eofStatus != (char *)NULL) {
		lineStr = buffer;
		if(tabNum == 0) {
			if(lineStr.find("Vrts") != string::npos) {
				tabNum++;
				startFlg = true;
				eofStatus = fgets(buffer, 511, argFP);
				continue;
			}

			if(lineStr.find("vmda") != string::npos) {
				vTagNum = argVData->size();
				heap.clear();
				eofStatus = fgets(buffer, 511, argFP);
				continue;
			}
		}

		if(startFlg == true) {
			if(lineStr.find("VerS") != string::npos) {
				tabNum++;
			} else if(lineStr.find("Posn") != string::npos) {
				numS = lineStr.find_first_of("0123456789-.");
				coordStr = lineStr.substr(numS, string::npos);
				tmpVec.x = Str2Double(PopWord(&coordStr));
				tmpVec.y = Str2Double(PopWord(&coordStr));
				tmpVec.z = Str2Double(PopWord(&coordStr));

				if(solidFlg == true) {

					size = argVData->size();
					existFlg = false;

					index = heap.getID(&tmpVec) + vTagNum - 1;
					if(index != int(size)) {
						argVMap->push_back(index);
						existFlg = true;
					}

					if(existFlg == false) {
						argVMap->push_back(argVData->size());
						argVData->push_back(tmpVec);
					}

				} else {
					argVMap->push_back(argVData->size());
					argVData->push_back(tmpVec);
				}

			} else if(lineStr.find("}") != string::npos) {
				tabNum--;
			}

			if(tabNum == 0) {
				startFlg = false;
			}
		}
		eofStatus = fgets(buffer, 511, argFP);
	}

	return true;
}

bool fk_RDSParser::ReadRDSPolygonData(FILE *argFP,
									  vector< vector<int> > *argLIndex,
									  vector<int> *argVMap)
{
	char				buffer[512];
	string				lineStr;
	string				subStr;
	string::size_type	numTag, tag;
	bool				startFlg;
	int					vtNum, objID, vID, tmpVID;
	vector<int>			polyIndex;
	char				*eofStatus;

	startFlg = false;
	vtNum = -1;
	objID = -1;

	eofStatus = fgets(buffer, 511, argFP);
	while(feof(argFP) == 0 && eofStatus != (char *)NULL) {

		lineStr = buffer;
		if(lineStr.find("Pgns") != string::npos) {
			startFlg = true;
			eofStatus = fgets(buffer, 511, argFP);
			continue;
		}

		if(startFlg == true) {
			if((tag = lineStr.find("PgSz")) != string::npos) {

				subStr = lineStr.substr(tag + 5, string::npos);
				vtNum = Str2Int(PopWord(&subStr));

			} else if((tag = lineStr.find("Pgon")) != string::npos) {

				numTag = 0;
				tag += 5;
				polyIndex.clear();
				while(numTag != string::npos) {
					numTag = lineStr.find(",", tag);
					subStr = lineStr.substr(tag, numTag - 1);
					tmpVID = atoi(subStr.c_str());

					if(tmpVID >= (int)argVMap->size()) {
						return false;
					}

					vID = (*argVMap)[tmpVID] + 1;
					polyIndex.push_back(vID);
					tag = numTag + 1;
				}

				if(polyIndex.size() != (unsigned int)vtNum) {
					return false;
				} else {
					argLIndex->push_back(polyIndex);
				}

			} else if(lineStr.find("}") != string::npos) {
				startFlg = false;
			}

		}

		eofStatus = fgets(buffer, 511, argFP);
	}

	return true;
}
