/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_SHAPE_VIEWER_HEADER__
#define __FK_SHAPE_VIEWER_HEADER__

#include <FK/Window.h>
#include <FK/MatExample.h>
#include <FK/Line.h>
#include <FK/Texture.h>
#include <FK/Model.h>
#include <FK/Light.h>
#include <FK/Scene.h>
#include <map>

enum fk_ShapeGUIMenuItem {
	FK_SV_GUI_NONE,
	FK_SV_GUI_WRLOPEN,
	FK_SV_GUI_STLOPEN,
	FK_SV_GUI_DXFOPEN,
	FK_SV_GUI_WRLSAVE,
	FK_SV_GUI_STLSAVE,
	FK_SV_GUI_IMAGESNAP,
	FK_SV_GUI_QUIT,
	FK_SV_GUI_POLYDRAW,
	FK_SV_GUI_EDGEDRAW,
	FK_SV_GUI_VERTEXDRAW,
	FK_SV_GUI_LIGHTROTATE,
	FK_SV_GUI_AXISDRAW,
	FK_SV_GUI_AMBIENT,
	FK_SV_GUI_DIFFUSE,
	FK_SV_GUI_SPECULAR,
	FK_SV_GUI_EMISSION,
	FK_SV_GUI_SHININESS,
	FK_SV_GUI_VERTEXCOLOR,
	FK_SV_GUI_EDGECOLOR
};

class fk_GUI_;

class fk_ShapeViewer : public fk_BaseObject {
 private:

	fk_Dimension		fkWinSize;
	fk_Dimension		allWinSize;
	fk_Dimension		groupPos;
	fk_Dimension		mousePos;

	int					mouseX, mouseY;

	// Window
	Fl_Window			*mainWindow;
	fk_Window			*viewWin;

	// GUI
	fk_GUI_				*gui;

	// flag
	bool				changeFlag;
	bool				lightFlag;
	bool				materialFlag;
	bool				moveFlag;
	bool				oldMoveFlag;
	fk_DrawMode			drawMode;

	// FK Object
	fk_Model				parentModel;
	vector<fk_Model *>		modelArray;
	map<int, int>			IDMap;
	fk_Model				lightModel[2], camera, axisModel;
	fk_Solid				localSolid;
	fk_Line					axisLine;
	fk_Light				light;
	fk_Scene				scene;
	vector<fk_Material *>	polyMaterial;
	vector<fk_Color *>		edgeColor;
	vector<fk_Color *>		vertexColor;

	void				InitValue(void);
	void				InitFlag(void);
	void				InitWindow(void);
	void				InitGUI(void);
	void				LightInit(void);
	void				AxisInit(void);
	void				ViewInit(void);
	void				ModelInit(int, fk_Shape *);
	void				RotateLight(double);
	bool				MenuSelect(void);
	void				SetOrientation(double, double, double, double);
	void				SetAxisLine(double);
	void				MovePosition(double, double, double);
	void				DragShape(void);
	void				KeyHandle(void);
	string				CommonFileChooser(string, int, string);
	void				SetAllMaterial(void);
	void				SetSceneFlg(fk_ShapeGUIMenuItem, bool);

	void				GetMaterial(int, fk_ShapeGUIMenuItem,
									double *, double *, double *);
	void				SetMaterial(int, fk_ShapeGUIMenuItem,
									double, double, double);
	void				SetDrawMode(void);

 public:
	fk_ShapeViewer(int = 300, int = 360);
	virtual ~fk_ShapeViewer();

	bool				draw(void);
	void				setWindowSize(int, int);
	void				setShape(fk_Shape *);
	void				setShape(int, fk_Shape *);
	void				setDrawMode(fk_DrawMode);
	void				setDrawMode(int, fk_DrawMode);
	void				setFrameMode(fk_FrameMode);
	void				setFrameInterval(int);
	void				setBGColor(fk_Color);
	void				setBGColor(float, float, float);
	void				setHead(double);
	void				setPitch(double);
	void				setBank(double);
	void				setScale(double);
	void				setAxisScale(double);
	void				clearModel(void);
	void				setPosition(int, fk_Vector);
	void				setPosition(int, double, double, double);
	void				setMaterial(int, fk_Material);
	void				setEdgeColor(int, fk_Color);
	void				setVertexColor(int, fk_Color);
	void				setAngle(int, fk_Angle);
	void				setAngle(int, double, double, double);
	void				setVec(int, fk_Vector);
	void				setVec(int, double, double, double);
	void				setUpvec(int, fk_Vector);
	void				setUpvec(int, double, double, double);
	void				setLineWidth(int, double);
	void				setPointSize(int, double);

	int					getModelNum(void);
	fk_Shape *			getShape(int = 0);
	fk_DrawMode			getDrawMode(void);
	fk_DrawMode			getDrawMode(int);
	fk_FrameMode		getFrameMode(void);
	int					getFrameInterval(void);
	double				getHead(void);
	double				getPitch(void);
	double				getBank(void);
	double				getScale(void);
	double				getAxisScale(void);
	fk_Vector			getCenter(void);
	double				getLineWidth(int);
	double				getPointSize(int);

	virtual bool		shapeProcess(fk_Solid *);

	bool				snapImage(const string);
	bool				snapImage(fk_Image *);

	void				setPutStrMode(const fk_PutStrMode);
	fk_PutStrMode		getPutStrMode(void);
	bool				setPutFile(const string &);
	void				putString(const string &);
	void				printf(const char *, ...);
	void				clearBrowser(void);
};

#endif // !__FK_SHAPE_VIEWER_HEADER__
