/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_MATADMIN_HEADER__
#define __FK_MATADMIN_HEADER__

#include <FK/Base.h>
#include <FK/Matrix.h>
#include <FK/Angle.h>

class fk_MatrixAdmin : public fk_BaseObject {

 protected:

	fk_UnitMatrix	UnitaryMatrix;	// Model Base Matrix
	fk_HVector		Position;		// Model Position
	fk_HVector		Vec, UpVec;		// Model Vector & Up Vector
	fk_Angle		Angle;			// Model Angle (Heading Pitch Bank)
	double			Scale;			// Model Scale
	double			xScale, yScale, zScale;	// Axis Scale
	bool			ScaleMode;

	void			RotateLtoG(fk_Vector *, const fk_Vector *,
							   const fk_Angle *) const;
	void			VectorToHeadPitch(fk_Angle *, const fk_Vector *) const;
	void			VectorToAngle(fk_Angle *, const fk_Vector *,
								  const fk_Vector *) const;
	void			AngleToVector(fk_Vector *, fk_Vector *,
								  const fk_Angle *) const;
	void			AddAngle(fk_Angle *, const fk_Angle *) const;
	
	void			AdjustAngleToVec(void);
	void			AdjustVecToAngle(void);

	void			UpdateMatrix(bool = true);

	fk_UnitMatrix	OrthonormalMatrix(const fk_Vector &, const fk_Vector &,
									  const double) const;
	void			SetScaleMode(void);

	void			GlRotate_(const fk_Vector &, const fk_Vector &,
							  const double);
	void			LoRotate_(const fk_Vector &, const fk_Vector &,
							  const double);

	void			GlRotateWithVec_(const fk_Vector &,
									 const fk_Vector &,
									 double);

	void			LoRotateWithVec_(const fk_Vector &,
									 const fk_Vector &,
									 double);

 public:

	fk_MatrixAdmin(fk_ObjectType = FK_MATRIXADMIN);
	~fk_MatrixAdmin();


	fk_Vector		getPosition(void) const;
	fk_Vector		getVec(void) const;
	fk_Vector		getUpVec(void) const;
	fk_Angle		getAngle(void) const;
	fk_Matrix		getMatrix(void) const;
	fk_Matrix		getInvMatrix(void) const;
	fk_UnitMatrix	getBaseMatrix(void) const;

	bool			setScale(const double);
	bool			setScale(const double, fk_Axis);
	bool			setScale(const double, const double, const double);

	bool			prdScale(const double);
	bool			prdScale(const double, fk_Axis);
	bool			prdScale(const double, const double, const double);

	double			getScale(void) const;
	double			getScale(fk_Axis) const;
	bool			getScaleMode(void) const;

	bool			glRotate(fk_Vector, fk_Axis, double);
	bool 			glRotate(double, double, double, fk_Axis, double);
	bool 			glRotate(fk_Vector, fk_Vector, double);
	bool			glRotate(double, double, double,
							 double, double, double, double);
	bool			loRotate(fk_Vector, fk_Axis, double);
	bool			loRotate(double, double, double, fk_Axis, double);
	bool			loRotate(fk_Vector, fk_Vector, double);
	bool			loRotate(double, double, double,
							 double, double, double, double);
	bool			glRotateWithVec(fk_Vector, fk_Axis, double);
	bool			glRotateWithVec(double, double, double, fk_Axis, double);
	bool			glRotateWithVec(fk_Vector, fk_Vector, double);
	bool			glRotateWithVec(double, double, double,
									double, double, double, double);
	bool			loRotateWithVec(fk_Vector, fk_Axis, double);
	bool			loRotateWithVec(double, double, double, fk_Axis, double);
	bool			loRotateWithVec(fk_Vector, fk_Vector, double);
	bool			loRotateWithVec(double, double, double,
									double, double, double, double);
	bool			glFocus(fk_Vector);
	bool			glFocus(double, double, double);
	bool			loFocus(fk_Vector);
	bool			loFocus(double, double, double);
	bool			glVec(fk_Vector);
	bool			glVec(double, double, double);
	bool			glUpvec(fk_Vector);
	bool			glUpvec(double, double, double);
	bool			loUpvec(fk_Vector);
	bool			loUpvec(double, double, double);
	bool			glAngle(fk_Angle);
	bool			glAngle(double, double, double);
	bool			loAngle(fk_Angle);
	bool			loAngle(double, double, double);
	bool			glTranslate(fk_Vector);
	bool			glTranslate(double, double, double);
	bool			loTranslate(fk_Vector);
	bool			loTranslate(double, double, double);
	bool			glMoveTo(fk_Vector);
	bool			glMoveTo(double, double, double);

	void			snapShot(void);
	void			restore(void);
	void			restore(double);
};

#endif // !__FK_MATADMIN_HEADER__
