/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class ToStringBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("toString");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ToString(this, config, parent, child, context);
    }

    private static final class ToString
    extends AbstractCommand {
        private final String fieldName;
        private final boolean trim;

        public ToString(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, "field");
            this.trim = this.getConfigs().getBoolean(config, "trim", false);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            ListIterator<String> iter = record.get(this.fieldName).listIterator();
            while (iter.hasNext()) {
                String str = iter.next().toString();
                if (this.trim) {
                    str = str.trim();
                }
                iter.set(str);
            }
            return super.doProcess(record);
        }
    }
}

