/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.shaded.org.apache.commons.math3.random.RandomGenerator;
import org.kitesdk.morphline.shaded.org.apache.commons.math3.random.Well19937c;

public final class GenerateUUIDBuilder
implements CommandBuilder {
    public static final String FIELD_NAME = "field";
    public static final String PRESERVE_EXISTING_NAME = "preserveExisting";
    public static final String PREFIX_NAME = "prefix";

    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("generateUUID");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new GenerateUUID(this, config, parent, child, context);
    }

    private static enum Type {
        secure,
        nonSecure;

    }

    private static final class GenerateUUID
    extends AbstractCommand {
        private final String fieldName;
        private final boolean preserveExisting;
        private final String prefix;
        private final RandomGenerator prng;

        public GenerateUUID(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, GenerateUUIDBuilder.FIELD_NAME, "id");
            this.preserveExisting = this.getConfigs().getBoolean(config, GenerateUUIDBuilder.PRESERVE_EXISTING_NAME, true);
            this.prefix = this.getConfigs().getString(config, GenerateUUIDBuilder.PREFIX_NAME, "");
            Type type = (Type)new Validator().validateEnum(config, this.getConfigs().getString(config, "type", Type.secure.toString()), Type.class, new Type[0]);
            if (type == Type.secure) {
                this.prng = null;
            } else {
                SecureRandom rand = new SecureRandom();
                int[] seed = new int[624];
                for (int i = 0; i < seed.length; ++i) {
                    seed[i] = rand.nextInt();
                }
                this.prng = new Well19937c(seed);
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (!this.preserveExisting || !record.getFields().containsKey((Object)this.fieldName)) {
                record.replaceValues(this.fieldName, this.generateUUID());
            }
            return super.doProcess(record);
        }

        protected String getPrefix() {
            return this.prefix;
        }

        protected String generateUUID() {
            UUID uuid = this.prng == null ? UUID.randomUUID() : new UUID(this.prng.nextLong(), this.prng.nextLong());
            return this.getPrefix() + uuid.toString();
        }
    }
}

