/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdlib.AbstractAddValuesCommand;

public final class AddValuesIfAbsentBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("addValuesIfAbsent");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new AddValuesIfAbsent(this, config, parent, child, context);
    }

    private static final class AddValuesIfAbsent
    extends AbstractAddValuesCommand {
        public AddValuesIfAbsent(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
        }

        @Override
        protected void putAll(Record record, String key, Collection values) {
            for (Object value : values) {
                this.put(record, key, value);
            }
        }

        @Override
        protected void put(Record record, String key, Object value) {
            record.putIfAbsent(key, value);
        }
    }
}

