/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdio;

import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadLineBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readLine");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadLine(this, config, parent, child, context);
    }

    private static final class ReadLine
    extends AbstractParser {
        private final Charset charset;
        private final boolean ignoreFirstLine;
        private final String commentPrefix;

        public ReadLine(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.ignoreFirstLine = this.getConfigs().getBoolean(config, "ignoreFirstLine", false);
            String cprefix = this.getConfigs().getString(config, "commentPrefix", "");
            if (cprefix.length() > 1) {
                throw new MorphlineCompilationException("commentPrefix must be at most one character long: " + cprefix, config);
            }
            this.commentPrefix = cprefix.length() > 0 ? cprefix : null;
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            String line;
            Record template = inputRecord.copy();
            ReadLine.removeAttachments(template);
            template.removeAll("message");
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            BufferedReader lineReader = new BufferedReader(reader, this.getBufferSize(stream));
            boolean isFirst = true;
            while ((line = lineReader.readLine()) != null) {
                if (isFirst && this.ignoreFirstLine) {
                    isFirst = false;
                    continue;
                }
                if (line.length() == 0 || this.commentPrefix != null && line.startsWith(this.commentPrefix)) continue;
                Record outputRecord = template.copy();
                outputRecord.put("message", line);
                this.incrementNumRecords();
                if (this.getChild().process(outputRecord)) continue;
                return false;
            }
            return true;
        }
    }
}

