/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.base;

import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;

public final class Notifications {
    public static final String LIFE_CYCLE = "lifecycle";
    @Deprecated
    public static final String LIFE_CYLCLE = "lifecycle";

    public static List getLifecycleEvents(Record notification) {
        return notification.get("lifecycle");
    }

    public static void notifyBeginTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.BEGIN_TRANSACTION);
    }

    public static void notifyCommitTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.COMMIT_TRANSACTION);
    }

    public static void notifyRollbackTransaction(Command command) {
        Notifications.notify(command, LifecycleEvent.ROLLBACK_TRANSACTION);
    }

    public static void notifyShutdown(Command command) {
        Notifications.notify(command, LifecycleEvent.SHUTDOWN);
    }

    public static void notifyStartSession(Command command) {
        Notifications.notify(command, LifecycleEvent.START_SESSION);
    }

    private static void notify(Command command, LifecycleEvent event) {
        Record notification = new Record();
        notification.put("lifecycle", (Object)event);
        command.notify(notification);
    }

    public static boolean containsLifecycleEvent(Record notification, LifecycleEvent event) {
        return Notifications.getLifecycleEvents(notification).contains((Object)event);
    }

    public static enum LifecycleEvent {
        BEGIN_TRANSACTION,
        COMMIT_TRANSACTION,
        ROLLBACK_TRANSACTION,
        SHUTDOWN,
        START_SESSION;

    }
}

