/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.base;

import com.google.common.base.Preconditions;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;

final class Connector
implements Command {
    private Command parent;
    private Command child;
    private final boolean ignoreNotifications;

    public Connector(boolean ignoreNotifications) {
        this.ignoreNotifications = ignoreNotifications;
    }

    @Override
    public Command getParent() {
        return this.parent;
    }

    public void setParent(Command parent) {
        Preconditions.checkNotNull((Object)parent);
        this.parent = parent;
    }

    public void setChild(Command child) {
        Preconditions.checkNotNull((Object)child);
        this.child = child;
    }

    @Override
    public void notify(Record notification) {
        Preconditions.checkNotNull((Object)notification);
        Preconditions.checkNotNull((Object)this.parent);
        Preconditions.checkNotNull((Object)this.child);
        if (!this.ignoreNotifications) {
            this.child.notify(notification);
        }
    }

    @Override
    public boolean process(Record record) {
        Preconditions.checkNotNull((Object)record);
        return this.child.process(record);
    }
}

