/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.base;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kitesdk.morphline.api.MorphlineCompilationException;

public final class Configs {
    private final Set<String> recognizedArguments = new LinkedHashSet<String>();

    private Set<String> getRecognizedArguments() {
        return this.recognizedArguments;
    }

    private void addRecognizedArgument(String arg) {
        this.recognizedArguments.add(arg);
    }

    public void validateArguments(Config config) {
        Set<String> recognizedArgs = this.getRecognizedArguments();
        for (String key : config.root().keySet()) {
            if (recognizedArgs.contains(key)) continue;
            throw new MorphlineCompilationException("Unrecognized command argument: " + key + ", recognized arguments: " + recognizedArgs, config);
        }
    }

    public String getString(Config config, String path, String defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getString(path);
        }
        return defaults;
    }

    public String getString(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getString(path);
    }

    public List<String> getStringList(Config config, String path, List<String> defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getStringList(path);
        }
        return defaults;
    }

    public List<String> getStringList(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getStringList(path);
    }

    public List<? extends Config> getConfigList(Config config, String path, List<? extends Config> defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getConfigList(path);
        }
        return defaults;
    }

    public List<? extends Config> getConfigList(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getConfigList(path);
    }

    public Config getConfig(Config config, String path, Config defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getConfig(path);
        }
        return defaults;
    }

    public Config getConfig(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getConfig(path);
    }

    public boolean getBoolean(Config config, String path, boolean defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getBoolean(path);
        }
        return defaults;
    }

    public boolean getBoolean(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getBoolean(path);
    }

    public int getInt(Config config, String path, int defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getInt(path);
        }
        return defaults;
    }

    public int getInt(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getInt(path);
    }

    public long getLong(Config config, String path, long defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getLong(path);
        }
        return defaults;
    }

    public long getLong(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getLong(path);
    }

    public double getDouble(Config config, String path, double defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return config.getDouble(path);
        }
        return defaults;
    }

    public double getDouble(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getDouble(path);
    }

    public Charset getCharset(Config config, String path, Charset defaults) {
        String charsetName = this.getString(config, path, defaults == null ? null : defaults.name());
        Charset charset = charsetName == null ? null : Charset.forName(charsetName);
        return charset;
    }

    public long getNanoseconds(Config config, String path, long defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return this.getNanoseconds(config, path);
        }
        return defaults;
    }

    public long getNanoseconds(Config config, String path) {
        this.addRecognizedArgument(path);
        return config.getNanoseconds(path);
    }

    public TimeUnit getTimeUnit(Config config, String path, TimeUnit defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return this.getTimeUnit(config, path);
        }
        return defaults;
    }

    public TimeUnit getTimeUnit(Config config, String path) {
        this.addRecognizedArgument(path);
        return this.getTimeUnit(config.getString(path));
    }

    public TimeUnit getTimeUnit(String str) {
        if (!str.endsWith("s") && str.length() > 2) {
            str = str + "s";
        }
        if (str.equals("d") || str.equals("days")) {
            return TimeUnit.DAYS;
        }
        if (str.equals("h") || str.equals("hours")) {
            return TimeUnit.HOURS;
        }
        if (str.equals("m") || str.equals("minutes")) {
            return TimeUnit.MINUTES;
        }
        if (str.equals("s") || str.equals("seconds")) {
            return TimeUnit.SECONDS;
        }
        if (str.equals("ms") || str.equals("milliseconds")) {
            return TimeUnit.MILLISECONDS;
        }
        if (str.equals("us") || str.equals("microseconds")) {
            return TimeUnit.MICROSECONDS;
        }
        if (str.equals("ns") || str.equals("nanoseconds")) {
            return TimeUnit.NANOSECONDS;
        }
        throw new IllegalArgumentException("Illegal time unit: " + str);
    }

    public Locale getLocale(Config config, String path, Locale defaults) {
        this.addRecognizedArgument(path);
        if (config.hasPath(path)) {
            return this.getLocale(config, path);
        }
        return defaults;
    }

    public Locale getLocale(Config config, String path) {
        this.addRecognizedArgument(path);
        String str = config.getString(path);
        String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'_').split((CharSequence)str), String.class);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        throw new MorphlineCompilationException("Illegal locale: " + str, config);
    }

    public Set<Map.Entry<String, Object>> getEntrySet(Config config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : config.entrySet()) {
            map.put(this.trimQuote((String)entry.getKey()), ((ConfigValue)entry.getValue()).unwrapped());
        }
        return map.entrySet();
    }

    private String trimQuote(String str) {
        if (str.length() > 1 && str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

