/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.converter;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.sf.fess.suggest.analysis.SuggestReadingAttribute;
import jp.sf.fess.suggest.analysis.SuggestTokenizerFactory;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseTokenizerFactory;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KatakanaConverter
implements SuggestReadingConverter {
    private static final Logger logger = LoggerFactory.getLogger(KatakanaConverter.class);
    private final Transliterator transliterator = Transliterator.getInstance((String)"Hiragana-Katakana");
    protected volatile UserDictionary userDictionary;
    protected volatile boolean initialized = false;
    protected TokenizerFactory tokenizerFactory = null;

    protected void init() {
        if (this.initialized) {
            return;
        }
        if (this.tokenizerFactory == null) {
            String path = System.getProperty("fess.user.dict.path");
            String encoding = System.getProperty("fess.user.dict.encoding");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("mode", "normal");
            args.put("discardPunctuation", "false");
            if (StringUtils.isNotBlank((String)path)) {
                args.put("userDictionary", path);
            }
            if (StringUtils.isNotBlank((String)encoding)) {
                args.put("userDictionaryEncoding", encoding);
            }
            JapaneseTokenizerFactory japaneseTokenizerFactory = new JapaneseTokenizerFactory(args);
            try {
                japaneseTokenizerFactory.inform((ResourceLoader)new FilesystemResourceLoader());
            }
            catch (Exception e) {
                logger.warn("Failed to initialize.", (Throwable)e);
            }
            this.tokenizerFactory = japaneseTokenizerFactory;
        }
        this.initialized = true;
    }

    @Override
    public void start() {
        this.init();
    }

    @Override
    public void setTokenizerFactory(TokenizerFactory tokenizerFactory) {
        if (this.isEnableTokenizer(tokenizerFactory)) {
            this.tokenizerFactory = tokenizerFactory;
        } else {
            logger.warn("Invalid tokenizerFactory. " + tokenizerFactory.getClass().getName());
        }
    }

    @Override
    public List<String> convert(String text) {
        ArrayList<String> readingList = new ArrayList<String>();
        try {
            readingList.add(this.toKatakana(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return readingList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toKatakana(String inputStr) throws IOException {
        StringBuilder kanaBuf = new StringBuilder();
        StringReader rd = new StringReader(inputStr);
        TokenStream stream = null;
        try {
            stream = this.createTokenStream(rd);
            stream.reset();
            int offset = 0;
            while (stream.incrementToken()) {
                CharTermAttribute att = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                String term = att.toString();
                int pos = inputStr.substring(offset).indexOf(term);
                if (pos > 0) {
                    String tmp = inputStr.substring(offset, offset + pos);
                    kanaBuf.append(this.transliterator.transliterate(tmp));
                    offset += pos;
                } else if (pos == -1) continue;
                String reading = this.getReadingFromAttribute(stream);
                if (StringUtils.isBlank((String)reading)) {
                    reading = this.transliterator.transliterate(att.toString());
                }
                kanaBuf.append(reading);
                offset += term.length();
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return kanaBuf.toString();
    }

    protected boolean isEnableTokenizer(TokenizerFactory factory) {
        return factory instanceof JapaneseTokenizerFactory || factory instanceof SuggestTokenizerFactory;
    }

    private TokenStream createTokenStream(Reader rd) {
        if (this.tokenizerFactory instanceof JapaneseTokenizerFactory) {
            return this.tokenizerFactory.create(rd);
        }
        if (this.tokenizerFactory instanceof SuggestTokenizerFactory) {
            SuggestTokenizerFactory suggestTokenizerFactory = (SuggestTokenizerFactory)this.tokenizerFactory;
            return suggestTokenizerFactory.create(rd, true);
        }
        return null;
    }

    protected String getReadingFromAttribute(TokenStream stream) {
        if (this.tokenizerFactory instanceof JapaneseTokenizerFactory) {
            ReadingAttribute rdAttr = (ReadingAttribute)stream.getAttribute(ReadingAttribute.class);
            return rdAttr.getReading();
        }
        if (this.tokenizerFactory instanceof SuggestTokenizerFactory) {
            SuggestReadingAttribute rdAttr = (SuggestReadingAttribute)stream.getAttribute(SuggestReadingAttribute.class);
            return rdAttr.toString();
        }
        return null;
    }
}

