/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.converter;

import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.fess.suggest.converter.KatakanaConverter;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class AlphabetConverter
implements SuggestReadingConverter {
    private final Map<String, String[]> convertMap = this.generateConvertMapping();
    private final KatakanaConverter katakanaConverter = new KatakanaConverter();
    protected Transliterator fullWidthHalfWidth = Transliterator.getInstance((String)"Fullwidth-Halfwidth");
    protected Transliterator anyLower = Transliterator.getInstance((String)"Any-Lower");
    protected int maxReadingPatternNum = 10;

    @Override
    public void setTokenizerFactory(TokenizerFactory tokenizerFactory) {
        this.katakanaConverter.setTokenizerFactory(tokenizerFactory);
    }

    @Override
    public void start() {
        this.katakanaConverter.start();
    }

    @Override
    public List<String> convert(String text) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> kanaList = this.katakanaConverter.convert(text);
        if (kanaList.isEmpty()) {
            list.add(text);
            return list;
        }
        for (String kana : kanaList) {
            ArrayList<StringBuilder> bufList = new ArrayList<StringBuilder>();
            bufList.add(new StringBuilder());
            int i = 0;
            while (i < kana.length()) {
                String[] alphabets;
                if (i + 1 < kana.length() && this.convertMap.get(kana.substring(i, i + 2)) != null) {
                    alphabets = this.convertMap.get(kana.substring(i, i + 2));
                    i += 2;
                } else if (this.convertMap.get(kana.substring(i, i + 1)) != null) {
                    alphabets = this.convertMap.get(kana.substring(i, i + 1));
                    ++i;
                } else {
                    alphabets = new String[]{kana.substring(i, i + 1)};
                    ++i;
                }
                List<StringBuilder> originBufList = this.deepCopyBufList(bufList);
                for (int j = 0; j < alphabets.length; ++j) {
                    if (j == 0) {
                        for (StringBuilder buf : bufList) {
                            buf.append(alphabets[j]);
                        }
                        continue;
                    }
                    if (bufList.size() >= this.maxReadingPatternNum) continue;
                    List<StringBuilder> tmpBufList = this.deepCopyBufList(originBufList);
                    for (StringBuilder buf : tmpBufList) {
                        buf.append(alphabets[j]);
                    }
                    bufList.addAll(tmpBufList);
                }
            }
            for (StringBuilder buf : bufList) {
                String s = this.fullWidthHalfWidth.transliterate(buf.toString());
                s = this.anyLower.transliterate(s);
                list.add(s);
            }
        }
        return list;
    }

    private Map<String, String[]> generateConvertMapping() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("\u30a2", new String[]{"a"});
        map.put("\u30a4", new String[]{"i"});
        map.put("\u30a6", new String[]{"u"});
        map.put("\u30a8", new String[]{"e"});
        map.put("\u30aa", new String[]{"o"});
        map.put("\u30ab", new String[]{"ka"});
        map.put("\u30ad", new String[]{"ki"});
        map.put("\u30af", new String[]{"ku"});
        map.put("\u30b1", new String[]{"ke"});
        map.put("\u30b3", new String[]{"ko"});
        map.put("\u30b5", new String[]{"sa"});
        map.put("\u30b7", new String[]{"si", "shi"});
        map.put("\u30b9", new String[]{"su"});
        map.put("\u30bb", new String[]{"se"});
        map.put("\u30bd", new String[]{"so"});
        map.put("\u30bf", new String[]{"ta"});
        map.put("\u30c1", new String[]{"ti", "chi"});
        map.put("\u30c4", new String[]{"tu", "tsu"});
        map.put("\u30c6", new String[]{"te"});
        map.put("\u30c8", new String[]{"to"});
        map.put("\u30ca", new String[]{"na"});
        map.put("\u30cb", new String[]{"ni"});
        map.put("\u30cc", new String[]{"nu"});
        map.put("\u30cd", new String[]{"ne"});
        map.put("\u30ce", new String[]{"no"});
        map.put("\u30cf", new String[]{"ha"});
        map.put("\u30d2", new String[]{"hi"});
        map.put("\u30d5", new String[]{"hu", "fu"});
        map.put("\u30d8", new String[]{"he"});
        map.put("\u30db", new String[]{"ho"});
        map.put("\u30de", new String[]{"ma"});
        map.put("\u30df", new String[]{"mi"});
        map.put("\u30e0", new String[]{"mu"});
        map.put("\u30e1", new String[]{"me"});
        map.put("\u30e2", new String[]{"mo"});
        map.put("\u30e4", new String[]{"ya"});
        map.put("\u30e6", new String[]{"yu"});
        map.put("\u30e8", new String[]{"yo"});
        map.put("\u30e9", new String[]{"ra"});
        map.put("\u30ea", new String[]{"ri"});
        map.put("\u30eb", new String[]{"ru"});
        map.put("\u30ec", new String[]{"re"});
        map.put("\u30ed", new String[]{"ro"});
        map.put("\u30ef", new String[]{"wa"});
        map.put("\u30f2", new String[]{"wo"});
        map.put("\u30f3", new String[]{"nn", "n"});
        map.put("\u30ac", new String[]{"ga"});
        map.put("\u30ae", new String[]{"gi"});
        map.put("\u30b0", new String[]{"gu"});
        map.put("\u30b2", new String[]{"ge"});
        map.put("\u30b4", new String[]{"go"});
        map.put("\u30b6", new String[]{"za"});
        map.put("\u30b8", new String[]{"zi", "ji"});
        map.put("\u30ba", new String[]{"zu"});
        map.put("\u30bc", new String[]{"ze"});
        map.put("\u30be", new String[]{"zo"});
        map.put("\u30c0", new String[]{"da"});
        map.put("\u30c2", new String[]{"di"});
        map.put("\u30c5", new String[]{"du"});
        map.put("\u30c7", new String[]{"de"});
        map.put("\u30c9", new String[]{"do"});
        map.put("\u30d0", new String[]{"ba"});
        map.put("\u30d3", new String[]{"bi"});
        map.put("\u30d6", new String[]{"bu"});
        map.put("\u30d9", new String[]{"be"});
        map.put("\u30dc", new String[]{"bo"});
        map.put("\u30d1", new String[]{"pa"});
        map.put("\u30d4", new String[]{"pi"});
        map.put("\u30d7", new String[]{"pu"});
        map.put("\u30da", new String[]{"pe"});
        map.put("\u30dd", new String[]{"po"});
        map.put("\u30f4\u30a1", new String[]{"va"});
        map.put("\u30f4\u30a3", new String[]{"vi"});
        map.put("\u30f4", new String[]{"vu"});
        map.put("\u30f4\u30a7", new String[]{"ve"});
        map.put("\u30f4\u30a9", new String[]{"vo"});
        map.put("\u30ae\u30e3", new String[]{"gya"});
        map.put("\u30ae\u30e5", new String[]{"gyu"});
        map.put("\u30ae\u30e7", new String[]{"gyo"});
        map.put("\u30ae\u30a7", new String[]{"gye"});
        map.put("\u30b8\u30e3", new String[]{"zya", "ja", "jya"});
        map.put("\u30b8\u30e5", new String[]{"zyu", "ju", "jyu"});
        map.put("\u30b8\u30e7", new String[]{"zyo", "jo", "jyo"});
        map.put("\u30b8\u30a7", new String[]{"zye", "je", "jye"});
        map.put("\u30ad\u30e3", new String[]{"kya"});
        map.put("\u30ad\u30e5", new String[]{"kyu"});
        map.put("\u30ad\u30e7", new String[]{"kyo"});
        map.put("\u30b7\u30e3", new String[]{"sya", "sha"});
        map.put("\u30b7\u30e5", new String[]{"syu", "shu"});
        map.put("\u30b7\u30e7", new String[]{"syo", "sho"});
        map.put("\u30b7\u30a7", new String[]{"sye", "she"});
        map.put("\u30c1\u30e3", new String[]{"tya", "cha"});
        map.put("\u30c1\u30e5", new String[]{"tyu", "chu"});
        map.put("\u30c1\u30e7", new String[]{"tyo", "cho"});
        map.put("\u30c1\u30a7", new String[]{"tye", "che"});
        map.put("\u30cb\u30e3", new String[]{"nya"});
        map.put("\u30cb\u30e5", new String[]{"nyu"});
        map.put("\u30cb\u30e7", new String[]{"nyo"});
        map.put("\u30d2\u30e3", new String[]{"hya"});
        map.put("\u30d2\u30e5", new String[]{"hyu"});
        map.put("\u30d2\u30e7", new String[]{"hyo"});
        map.put("\u30d5\u30e3", new String[]{"fya"});
        map.put("\u30d5\u30e5", new String[]{"hyu", "fyu"});
        map.put("\u30d5\u30e7", new String[]{"fyo"});
        map.put("\u30d5\u30a1", new String[]{"fa"});
        map.put("\u30d5\u30a3", new String[]{"fi"});
        map.put("\u30d5\u30a7", new String[]{"fe"});
        map.put("\u30d5\u30a9", new String[]{"fo"});
        map.put("\u30df\u30e3", new String[]{"mya"});
        map.put("\u30df\u30e5", new String[]{"myu"});
        map.put("\u30df\u30e7", new String[]{"myo"});
        map.put("\u30ea\u30e3", new String[]{"rya"});
        map.put("\u30ea\u30e5", new String[]{"ryu"});
        map.put("\u30ea\u30e7", new String[]{"ryo"});
        map.put("\u30a1", new String[]{"a"});
        map.put("\u30a3", new String[]{"i"});
        map.put("\u30a5", new String[]{"u"});
        map.put("\u30a7", new String[]{"e"});
        map.put("\u30a9", new String[]{"o"});
        map.put("\u30e3", new String[]{"ya"});
        map.put("\u30e5", new String[]{"yu"});
        map.put("\u30e7", new String[]{"yo"});
        map.put("\u30c3", new String[]{"tu", "tsu"});
        return map;
    }

    private List<StringBuilder> deepCopyBufList(List<StringBuilder> bufList) {
        ArrayList<StringBuilder> list = new ArrayList<StringBuilder>();
        for (StringBuilder buf : bufList) {
            list.add(new StringBuilder(buf.toString()));
        }
        return list;
    }
}

