/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaFile {
    private RandomAccessFile archive;
    private Object LastAccessObject;
    private Vector headers;
    private Vector entryPoint;
    private Hashtable hash;
    private Vector duplicate;
    private Properties property;

    private LhaFile() {
    }

    public LhaFile(String string) throws IOException {
        Properties properties = LhaProperty.getProperties();
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(String string, Properties properties) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(File file) throws IOException {
        Properties properties = LhaProperty.getProperties();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(File file, Properties properties) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(RandomAccessFile randomAccessFile) throws IOException {
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(RandomAccessFile randomAccessFile, boolean bl) throws IOException {
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties, bl);
    }

    public LhaFile(RandomAccessFile randomAccessFile, Properties properties) throws IOException {
        this.constructerHelper(randomAccessFile, properties, false);
    }

    public LhaFile(RandomAccessFile randomAccessFile, Properties properties, boolean bl) throws IOException {
        this.constructerHelper(randomAccessFile, properties, bl);
    }

    private void constructerHelper(RandomAccessFile randomAccessFile, Properties properties, boolean bl) throws IOException {
        this.headers = new Vector();
        this.entryPoint = new Vector();
        randomAccessFile.seek(0L);
        CachedRandomAccessFileInputStream cachedRandomAccessFileInputStream = new CachedRandomAccessFileInputStream(randomAccessFile);
        byte[] byArray = LhaHeader.getFirstHeaderData(cachedRandomAccessFileInputStream);
        while (null != byArray) {
            LhaHeader lhaHeader = LhaHeader.createInstance(byArray, properties);
            this.headers.addElement(lhaHeader);
            this.entryPoint.addElement(new Long(cachedRandomAccessFileInputStream.position()));
            if (!bl) {
                cachedRandomAccessFileInputStream.skip(lhaHeader.getCompressedSize());
                byArray = LhaHeader.getNextHeaderData(cachedRandomAccessFileInputStream);
                continue;
            }
            byArray = LhaHeader.getFirstHeaderData(cachedRandomAccessFileInputStream);
        }
        cachedRandomAccessFileInputStream.close();
        this.hash = new Hashtable();
        this.duplicate = new Vector();
        for (int i = 0; i < this.headers.size(); ++i) {
            LhaHeader lhaHeader = (LhaHeader)this.headers.elementAt(i);
            if (!this.hash.containsKey(lhaHeader.getPath())) {
                this.hash.put(lhaHeader.getPath(), new Integer(i));
                continue;
            }
            this.duplicate.addElement(new Integer(i));
        }
        this.archive = randomAccessFile;
        this.property = (Properties)properties.clone();
    }

    public InputStream getInputStream(LhaHeader lhaHeader) {
        int n = this.getIndex(lhaHeader);
        if (0 <= n) {
            long l = (Long)this.entryPoint.elementAt(n);
            long l2 = lhaHeader.getCompressedSize();
            RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(l, l2);
            return CompressMethod.connectDecoder(randomAccessFileInputStream, lhaHeader.getCompressMethod(), this.property, lhaHeader.getOriginalSize());
        }
        return null;
    }

    public InputStream getInputStream(String string) {
        if (this.hash.containsKey(string)) {
            int n = (Integer)this.hash.get(string);
            LhaHeader lhaHeader = (LhaHeader)this.headers.elementAt(n);
            long l = (Long)this.entryPoint.elementAt(n);
            long l2 = lhaHeader.getCompressedSize();
            RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(l, l2);
            return CompressMethod.connectDecoder(randomAccessFileInputStream, lhaHeader.getCompressMethod(), this.property, lhaHeader.getOriginalSize());
        }
        return null;
    }

    public InputStream getInputStreamWithoutExtract(LhaHeader lhaHeader) {
        int n = this.getIndex(lhaHeader);
        if (0 <= n) {
            long l = (Long)this.entryPoint.elementAt(n);
            long l2 = lhaHeader.getCompressedSize();
            return new RandomAccessFileInputStream(l, l2);
        }
        return null;
    }

    public InputStream getInputStreamWithoutExtract(String string) {
        if (this.hash.containsKey(string)) {
            int n = (Integer)this.hash.get(string);
            LhaHeader lhaHeader = (LhaHeader)this.headers.elementAt(n);
            long l = (Long)this.entryPoint.elementAt(n);
            long l2 = lhaHeader.getCompressedSize();
            return new RandomAccessFileInputStream(l, l2);
        }
        return null;
    }

    public int size() {
        return this.headers.size();
    }

    public Enumeration entries() {
        if (this.archive != null) {
            return new HeaderEnumeration();
        }
        throw new IllegalStateException();
    }

    public LhaHeader[] getEntries() {
        LhaHeader[] lhaHeaderArray = new LhaHeader[this.headers.size()];
        for (int i = 0; i < this.headers.size(); ++i) {
            lhaHeaderArray[i] = (LhaHeader)((LhaHeader)this.headers.elementAt(i)).clone();
        }
        return lhaHeaderArray;
    }

    public void close() throws IOException {
        this.archive.close();
        this.archive = null;
        this.LastAccessObject = null;
        this.headers = null;
        this.entryPoint = null;
        this.hash = null;
        this.property = null;
        this.duplicate = null;
    }

    private int getIndex(LhaHeader lhaHeader) {
        int n = (Integer)this.hash.get(lhaHeader.getPath());
        LhaHeader lhaHeader2 = (LhaHeader)this.headers.elementAt(n);
        if (!LhaFile.equal(lhaHeader2, lhaHeader)) {
            boolean bl = false;
            for (int i = 0; i < this.duplicate.size() && !bl; ++i) {
                n = (Integer)this.duplicate.elementAt(i);
                lhaHeader2 = (LhaHeader)this.headers.elementAt(n);
                if (!LhaFile.equal(lhaHeader2, lhaHeader)) continue;
                bl = true;
            }
            if (bl) {
                return n;
            }
            return -1;
        }
        return n;
    }

    private static boolean equal(LhaHeader lhaHeader, LhaHeader lhaHeader2) {
        return lhaHeader.getPath().equals(lhaHeader2.getPath()) && lhaHeader.getCompressMethod().equals(lhaHeader2.getCompressMethod()) && lhaHeader.getLastModified().equals(lhaHeader2.getLastModified()) && lhaHeader.getCompressedSize() == lhaHeader2.getCompressedSize() && lhaHeader.getOriginalSize() == lhaHeader2.getOriginalSize() && lhaHeader.getCRC() == lhaHeader2.getCRC() && lhaHeader.getOSID() == lhaHeader2.getOSID() && lhaHeader.getHeaderLevel() == lhaHeader2.getHeaderLevel();
    }

    private class HeaderEnumeration
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            if (LhaFile.this.archive != null) {
                return this.index < LhaFile.this.headers.size();
            }
            throw new IllegalStateException();
        }

        public Object nextElement() {
            if (LhaFile.this.archive != null) {
                if (this.index < LhaFile.this.headers.size()) {
                    return ((LhaHeader)LhaFile.this.headers.elementAt(this.index++)).clone();
                }
                throw new NoSuchElementException();
            }
            throw new IllegalStateException();
        }
    }

    private static class CachedRandomAccessFileInputStream
    extends InputStream {
        private RandomAccessFile archive;
        private byte[] cache;
        private int cachePosition;
        private int cacheLimit;
        private boolean markPositionIsInCache;
        private byte[] markCache;
        private int markCachePosition;
        private int markCacheLimit;
        private long markPosition;

        public CachedRandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
            this.archive = randomAccessFile;
            this.cache = new byte[1024];
            this.cachePosition = 0;
            this.cacheLimit = 0;
        }

        public int read() throws IOException {
            if (this.cachePosition < this.cacheLimit) {
                return this.cache[this.cachePosition++] & 0xFF;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                return this.cache[this.cachePosition++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            while (0 < n2) {
                if (this.cacheLimit <= this.cachePosition) {
                    this.fillCache();
                    if (this.cacheLimit <= this.cachePosition) {
                        if (n3 != n2) break;
                        return -1;
                    }
                }
                int n4 = Math.min(n2, this.cacheLimit - this.cachePosition);
                System.arraycopy(this.cache, this.cachePosition, byArray, n, n4);
                n += n4;
                n2 -= n4;
                this.cachePosition += n4;
            }
            return n3 - n2;
        }

        public long skip(long l) throws IOException {
            long l2;
            long l3;
            long l4 = l;
            if (this.cachePosition < this.cacheLimit) {
                l3 = (long)this.cacheLimit - (long)this.cachePosition;
                l2 = Math.min(l, l3);
                l -= l2;
                this.cachePosition += (int)l2;
            }
            if (0L < l) {
                l3 = this.archive.length() - this.archive.getFilePointer();
                l2 = Math.min(l3, l);
                l -= l2;
                this.archive.seek(this.archive.getFilePointer() + l2);
            }
            return l4 - l;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            try {
                this.markPosition = this.archive.getFilePointer();
            }
            catch (IOException iOException) {
                throw new Error("caught IOException( " + iOException.getMessage() + " ) in mark()");
            }
            if (this.markCache == null) {
                this.markCache = (byte[])this.cache.clone();
            } else {
                System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
            }
            this.markCacheLimit = this.cacheLimit;
            this.markCachePosition = this.cachePosition;
            this.markPositionIsInCache = true;
        }

        public void reset() throws IOException {
            if (this.markPositionIsInCache) {
                this.cachePosition = this.markCachePosition;
            } else {
                if (this.markCache == null) {
                    throw new IOException("not marked.");
                }
                this.archive.seek(this.markPosition);
                System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
                this.cacheLimit = this.markCacheLimit;
                this.cachePosition = this.markCachePosition;
            }
        }

        public int available() {
            return this.cacheLimit - this.cachePosition;
        }

        public void close() {
            this.archive = null;
            this.cache = null;
            this.cachePosition = 0;
            this.cacheLimit = 0;
            this.markPositionIsInCache = false;
            this.markCache = null;
            this.markCachePosition = 0;
            this.markCacheLimit = 0;
            this.markPosition = 0L;
        }

        public long position() throws IOException {
            long l = this.archive.getFilePointer();
            return l -= (long)(this.cacheLimit - this.cachePosition);
        }

        private void fillCache() throws IOException {
            this.markPositionIsInCache = false;
            this.cacheLimit = 0;
            this.cachePosition = 0;
            int n = 0;
            while (0 <= n && this.cacheLimit < this.cache.length) {
                n = this.archive.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
                if (0 >= n) continue;
                this.cacheLimit += n;
            }
        }
    }

    private class RandomAccessFileInputStream
    extends InputStream {
        private long position;
        private long end;
        private long markPosition;

        public RandomAccessFileInputStream(long l, long l2) {
            this.position = l;
            this.end = l + l2;
            this.markPosition = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (this.position < this.end) {
                    int n;
                    if (LhaFile.this.LastAccessObject != this) {
                        LhaFile.this.archive.seek(this.position);
                    }
                    if (0 <= (n = LhaFile.this.archive.read())) {
                        ++this.position;
                    }
                    return n;
                }
                return -1;
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (this.position < this.end) {
                    if (LhaFile.this.LastAccessObject != this) {
                        LhaFile.this.archive.seek(this.position);
                        LhaFile.this.LastAccessObject = this;
                    }
                    n2 = (int)Math.min(this.end - this.position, (long)n2);
                    n2 = LhaFile.this.archive.read(byArray, n, n2);
                    if (0 <= n2) {
                        this.position += (long)n2;
                    }
                    return n2;
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                long l2 = Math.min(this.end - this.position, l);
                this.position += l2;
                if (LhaFile.this.LastAccessObject == this) {
                    LhaFile.this.LastAccessObject = null;
                }
                return l2;
            }
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.markPosition = this.position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IOException {
            RandomAccessFile randomAccessFile = LhaFile.this.archive;
            synchronized (randomAccessFile) {
                if (0L > this.markPosition) {
                    throw new IOException("not marked");
                }
                this.position = this.markPosition;
                if (LhaFile.this.LastAccessObject == this) {
                    LhaFile.this.LastAccessObject = null;
                }
            }
        }

        public int available() {
            return 0;
        }

        public void close() {
        }
    }
}

