/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashDefault;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class HashAndChainedListSearch
implements LzssSearchMethod {
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private char[] tooBigFlag;
    private int[] prev;
    private int SearchLimitCount;

    private HashAndChainedListSearch() {
    }

    public HashAndChainedListSearch(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, HashDefault.class.getName(), 256);
    }

    public HashAndChainedListSearch(int n, int n2, int n3, byte[] byArray, int n4) {
        this(n, n2, n3, byArray, HashDefault.class.getName(), n4);
    }

    public HashAndChainedListSearch(int n, int n2, int n3, byte[] byArray, String string) {
        this(n, n2, n3, byArray, string, 256);
    }

    public HashAndChainedListSearch(int n, int n2, int n3, byte[] byArray, String string, int n4) {
        if (0 < n4) {
            int n5;
            this.DictionarySize = n;
            this.MaxMatch = n2;
            this.Threshold = n3;
            this.TextBuffer = byArray;
            this.DictionaryLimit = this.DictionarySize;
            this.SearchLimitCount = n4;
            try {
                this.hashMethod = (HashMethod)Factory.createInstance(string, new Object[]{byArray});
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new Error(invocationTargetException.getTargetException().getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
            this.hashTable = new int[this.hashMethod.tableSize()];
            for (n5 = 0; n5 < this.hashTable.length; ++n5) {
                this.hashTable[n5] = -1;
            }
            this.prev = new int[this.DictionarySize];
            for (n5 = 0; n5 < this.prev.length; ++n5) {
                this.prev[n5] = -1;
            }
        } else {
            throw new IllegalArgumentException("SearchLimitCount must be 1 or more.");
        }
        this.tooBigFlag = new char[this.hashMethod.tableSize() >> 4];
    }

    public void put(int n) {
        int n2 = this.hashMethod.hash(n);
        this.prev[n & this.DictionarySize - 1] = this.hashTable[n2];
        this.hashTable[n2] = n;
    }

    public int searchAndPut(int n) {
        int n2;
        int n3 = this.Threshold - 1;
        int n4 = n;
        int n5 = this.MaxMatch;
        int n6 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
        int n7 = n2 = this.hashMethod.hash(n);
        int n8 = 0;
        while (this.isTooBig(n7) && n8 < this.MaxMatch - this.hashMethod.hashRequires()) {
            n7 = this.hashMethod.hash(n + ++n8);
        }
        byte[] byArray = this.TextBuffer;
        int n9 = n + this.MaxMatch;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (true) {
            int n13 = this.hashTable[n7];
            int n14 = this.SearchLimitCount;
            while (n6 <= n13 - n8 && 0 < --n14) {
                if (byArray[n13 + n3 - n8] == byArray[n + n3]) {
                    n10 = n13 - n8;
                    n11 = n;
                    while (byArray[n10] == byArray[n11]) {
                        ++n10;
                        if (n9 > ++n11) continue;
                    }
                    if (n3 < (n12 = n11 - n)) {
                        n4 = n13 - n8;
                        n3 = n12;
                        if (n9 <= n11) break;
                    }
                }
                n13 = this.prev[n13 & this.DictionarySize - 1];
            }
            if (n14 <= 0) {
                this.setTooBigFlag(n7);
            } else if (n13 < n6) {
                this.clearTooBigFlag(n7);
            }
            if (0 >= n8 || n3 >= this.hashMethod.hashRequires() + n8) break;
            n8 = 0;
            n5 = this.hashMethod.hashRequires() + n8 - 1;
            n9 = n + n5;
            n7 = n2;
        }
        this.prev[n & this.DictionarySize - 1] = this.hashTable[n2];
        this.hashTable[n2] = n;
        if (this.Threshold <= n3) {
            return LzssOutputStream.createSearchReturn(n3, n4);
        }
        return -1;
    }

    public int search(int n, int n2) {
        int n3;
        int n4 = this.Threshold - 1;
        int n5 = n;
        int n6 = Math.max(this.DictionaryLimit, n2);
        byte[] byArray = this.TextBuffer;
        int n7 = Math.min(this.TextBuffer.length, n + this.MaxMatch);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = n - 1; n6 < n3; --n3) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n4 >= n10) continue;
            n5 = n3;
            n4 = n10;
        }
        if (this.hashMethod.hashRequires() < this.TextBuffer.length - n) {
            int n11;
            int n12 = this.MaxMatch;
            n6 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
            int n13 = n11 = this.hashMethod.hash(n);
            int n14 = 0;
            while (this.isTooBig(n13) && n14 < this.MaxMatch - this.hashMethod.hashRequires()) {
                n13 = this.hashMethod.hash(n + ++n14);
            }
            while (true) {
                int n15 = this.SearchLimitCount;
                n3 = this.hashTable[n13];
                while (n6 <= n3 - n14 && 0 < --n15) {
                    if (byArray[n3 + n4 - n14] == byArray[n + n4]) {
                        n8 = n3 - n14;
                        n9 = n;
                        while (byArray[n8] == byArray[n9]) {
                            ++n8;
                            if (n7 > ++n9) continue;
                        }
                        if (n4 < (n10 = n9 - n)) {
                            n5 = n3 - n14;
                            n4 = n10;
                            if (n7 <= n9) break;
                        }
                    }
                    n3 = this.prev[n3 & this.DictionarySize - 1];
                }
                if (n15 <= 0) {
                    this.setTooBigFlag(n13);
                } else if (n3 < n6) {
                    this.clearTooBigFlag(n13);
                }
                if (0 >= n14 || n4 >= this.hashMethod.hashRequires() + n14) break;
                n14 = 0;
                n12 = this.hashMethod.hashRequires() + n14 - 1;
                n7 = Math.min(this.TextBuffer.length, n + n12);
                n13 = n11;
            }
        }
        if (this.Threshold <= n4) {
            return LzssOutputStream.createSearchReturn(n4, n5);
        }
        return -1;
    }

    public void slide() {
        int n;
        int n2;
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        for (n2 = 0; n2 < this.hashTable.length; ++n2) {
            n = this.hashTable[n2] - this.DictionarySize;
            this.hashTable[n2] = 0 <= n ? n : -1;
        }
        for (n2 = 0; n2 < this.prev.length; ++n2) {
            n = this.prev[n2] - this.DictionarySize;
            this.prev[n2] = 0 <= n ? n : -1;
        }
    }

    public int putRequires() {
        return this.hashMethod.hashRequires();
    }

    public int searchAndPut(int n, int[] nArray) {
        int n2;
        int n3 = this.Threshold - 1;
        int n4 = n;
        int n5 = this.MaxMatch;
        int n6 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
        int n7 = this.SearchLimitCount;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        n2 = this.hashTable[this.hashMethod.hash(n)];
        while (n6 < n2 && 0 < n7--) {
            if (this.TextBuffer[n2 + n3] == this.TextBuffer[n + n3]) {
                int n8 = 0;
                while (this.TextBuffer[n2 + n8] == this.TextBuffer[n + n8] && n5 > ++n8) {
                }
                if (n3 < n8) {
                    int n9 = n3 + 1 - this.Threshold;
                    int n10 = Math.min(n8 + 1 - this.Threshold, nArray.length);
                    while (n9 < n10) {
                        nArray[n9++] = n2;
                    }
                    n4 = n2;
                    n3 = n8;
                    if (n5 <= n8) break;
                }
            }
            n2 = this.prev[n2 & this.DictionarySize - 1];
        }
        this.put(n);
        if (n4 < n) {
            return LzssOutputStream.createSearchReturn(n3, n4);
        }
        return -1;
    }

    private boolean isTooBig(int n) {
        return 0 != (this.tooBigFlag[n >> 4] & 1 << (n & 0xF));
    }

    private void setTooBigFlag(int n) {
        int n2 = n >> 4;
        this.tooBigFlag[n2] = (char)(this.tooBigFlag[n2] | 1 << (n & 0xF));
    }

    private void clearTooBigFlag(int n) {
        int n2 = n >> 4;
        this.tooBigFlag[n2] = (char)(this.tooBigFlag[n2] & ~(1 << (n & 0xF)));
    }
}

