/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.monitor.MonitoringTask;
import org.apache.log4j.lf5.util.StreamUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitoringUtil {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringUtil.class);
    private static final boolean VERBOSE = false;
    private static final String MONITORING_PERIOD = "monitoringPeriod";
    private static final String MONITORING_FILE = "monitoringFile";
    private static final String BASE_CLASS = "baseClass";
    private static final String CLASS = "class";

    private MonitoringUtil() {
    }

    public static Map<String, String> createMonitorArgs(Map<String, String> baseArgs) {
        HashMap<String, String> monitorArgs = new HashMap<String, String>();
        monitorArgs.put(MONITORING_FILE, baseArgs.remove(MONITORING_FILE));
        monitorArgs.put(MONITORING_PERIOD, baseArgs.remove(MONITORING_PERIOD));
        return monitorArgs;
    }

    public static String initBaseArgs(Map<String, String> baseArgs, String luceneVersion) {
        String baseClass = baseArgs.remove(BASE_CLASS);
        baseArgs.put(CLASS, baseClass);
        baseArgs.put("luceneMatchVersion", luceneVersion);
        return baseClass;
    }

    public static <T> T createFactory(String className, Map<String, String> baseArgs, ResourceLoader loader) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(Map.class);
            Object factory = constructor.newInstance(new HashMap<String, String>(baseArgs));
            if (loader != null && factory instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)factory).inform(loader);
            }
            return (T)factory;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid parameters to create TokenizerFactory.", e);
        }
    }

    public static MonitoringTask createMonitoringTask(Map<String, String> monitorArgs, ResourceLoader loader, MonitoringTask.Callback callback) throws IOException {
        MonitoringTask.Target monitoringTarget;
        String monitoringFilePath = monitorArgs.get(MONITORING_FILE);
        final File file = new File(monitoringFilePath);
        if (file.exists()) {
            monitoringTarget = new MonitoringTask.Target(){

                @Override
                public long lastModified() {
                    return file.lastModified();
                }
            };
        } else if (loader instanceof ZkSolrResourceLoader) {
            monitoringTarget = new ZkMonitoringTarget(loader, monitoringFilePath);
        } else {
            final File targetFile = new File(((SolrResourceLoader)loader).getConfigDir(), monitoringFilePath);
            monitoringTarget = new MonitoringTask.Target(){

                @Override
                public long lastModified() {
                    return targetFile.lastModified();
                }
            };
        }
        String monitoringPeriodStr = monitorArgs.get(MONITORING_PERIOD);
        long monitoringPeriod = monitoringPeriodStr == null ? 60000L : Long.parseLong(monitoringPeriodStr);
        return new MonitoringTask(monitoringTarget, monitoringPeriod, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean diff(File file1, File file2) {
        block28: {
            block27: {
                if (file1 == file2) {
                    return false;
                }
                if (file1 == null) return true;
                if (file2 == null) {
                    return true;
                }
                is1 = null;
                is2 = null;
                try {
                    is1 = new BufferedInputStream(new FileInputStream(file1));
                    is2 = new BufferedInputStream(new FileInputStream(file2));
                    while (true) {
                        value1 = is1.read();
                        if (value1 == (value2 = is2.read())) continue;
                        var6_7 = true;
                        if (is1 == null) break block27;
                        break;
                    }
                }
                catch (IOException e) {
                    MonitoringUtil.logger.warn("Failed to compare " + file1.getAbsolutePath() + " and " + file2.getAbsolutePath(), (Throwable)e);
                    var5_6 = false;
                    if (is1 != null) {
                        try {
                            is1.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (is2 == null) return var5_6;
                    try {
                        is2.close();
                        return var5_6;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var5_6;
                }
                catch (Throwable var8_15) {
                    if (is1 != null) {
                        try {
                            is1.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (is2 == null) throw var8_15;
                    try {
                        is2.close();
                        throw var8_15;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var8_15;
                }
                try {
                    is1.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (is2 == null) return var6_7;
            try {
                is2.close();
                return var6_7;
            }
            catch (IOException e) {
                // empty catch block
            }
            return var6_7;
            {
                if (value1 != -1) ** continue;
                var6_8 = false;
                if (is1 == null) break block28;
            }
            try {
                is1.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (is2 == null) return var6_8;
        try {
            is2.close();
            return var6_8;
        }
        catch (IOException e) {
            // empty catch block
        }
        return var6_8;
    }

    public static class ZkMonitoringTarget
    implements MonitoringTask.Target {
        private final String pathname;
        private final ResourceLoader loader;
        private File file;

        public ZkMonitoringTarget(ResourceLoader loader, String pathname) throws IOException {
            this.loader = loader;
            this.pathname = pathname;
            this.file = File.createTempFile("zk_mon_", ".tmp");
            this.updateFile(this.file);
        }

        @Override
        public long lastModified() {
            block6: {
                File newFile = null;
                try {
                    newFile = File.createTempFile("zk_mon_", ".tmp");
                    this.updateFile(newFile);
                    if (MonitoringUtil.diff(this.file, newFile)) {
                        if (!this.file.delete()) {
                            logger.warn("Failed to delete " + this.file.getAbsolutePath());
                        }
                        this.file = newFile;
                    } else if (!newFile.delete()) {
                        logger.warn("Failed to delete " + newFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed to create " + newFile, (Throwable)e);
                    if (newFile == null || newFile.delete()) break block6;
                    logger.warn("Failed to delete " + newFile.getAbsolutePath());
                }
            }
            return this.file.lastModified();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFile(File file) throws IOException {
            InputStream is = null;
            BufferedOutputStream os = null;
            try {
                is = this.loader.openResource(this.pathname);
                os = new BufferedOutputStream(new FileOutputStream(file));
                StreamUtils.copy((InputStream)is, (OutputStream)os);
                ((OutputStream)os).flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is, os});
        }
    }
}

