/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.update;

import java.io.IOException;
import jp.sf.fess.solr.plugin.update.FessUpdateHandler;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilter;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SplitIndexCommand;

public class UpdateHandlerFilterChain {
    FessUpdateHandler updateHandler;
    private final UpdateHandlerFilter[] filters;
    private int position = 0;

    public UpdateHandlerFilterChain(FessUpdateHandler updateHandler, UpdateHandlerFilter[] filters) {
        this.updateHandler = updateHandler;
        this.filters = filters;
    }

    public int addDoc(AddUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            return filter.addDoc(cmd, this);
        }
        return this.updateHandler.doAddDoc(cmd);
    }

    public void delete(DeleteUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.delete(cmd, this);
        } else {
            this.updateHandler.doDelete(cmd);
        }
    }

    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.deleteByQuery(cmd, this);
        } else {
            this.updateHandler.doDeleteByQuery(cmd);
        }
    }

    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            return filter.mergeIndexes(cmd, this);
        }
        return this.updateHandler.doMergeIndexes(cmd);
    }

    public void prepareCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.prepareCommit(cmd, this);
        } else {
            this.updateHandler.doPrepareCommit(cmd);
        }
    }

    public void commit(CommitUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.commit(cmd, this);
        } else {
            this.updateHandler.doCommit(cmd);
        }
    }

    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.rollback(cmd, this);
        } else {
            this.updateHandler.doRollback(cmd);
        }
    }

    public void split(SplitIndexCommand cmd) throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.split(cmd, this);
        } else {
            this.updateHandler.doSplit(cmd);
        }
    }

    public void close() throws IOException {
        if (this.position < this.filters.length) {
            UpdateHandlerFilter filter = this.filters[this.position];
            ++this.position;
            filter.close(this);
        } else {
            this.updateHandler.doClose();
        }
    }
}

