/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.update;

import java.io.IOException;
import java.util.ArrayList;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilter;
import jp.sf.fess.solr.plugin.update.UpdateHandlerFilterChain;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.util.RefCounted;

public class DocValueUpdateHandlerFilter
extends UpdateHandlerFilter {
    private static final String TERM_PARAM = "term";
    private static final String EXTENDED_CMD = "excmd";
    private static final String UPDATE_CMD = "update";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDoc(AddUpdateCommand cmd, UpdateHandlerFilterChain chain) throws IOException {
        String exCmd = cmd.getReq().getParams().get(EXTENDED_CMD);
        if (UPDATE_CMD.equals(exCmd)) {
            String termName = cmd.getReq().getParams().get(TERM_PARAM);
            if (termName == null) {
                throw new IllegalArgumentException("term is not specified.");
            }
            int rc = -1;
            RefCounted iw = this.updateHandler.getSolrCoreState().getIndexWriter(this.updateHandler.getSolrCore());
            try {
                IndexWriter writer = (IndexWriter)iw.get();
                if (cmd.isBlock()) {
                    for (Iterable doc : cmd) {
                        this.updateNumericValue(writer, doc, termName);
                    }
                } else {
                    Document doc = cmd.getLuceneDocument();
                    this.updateNumericValue(writer, (Iterable<? extends IndexableField>)doc, termName);
                }
                rc = 1;
            }
            finally {
                iw.decref();
            }
            return rc;
        }
        return chain.addDoc(cmd);
    }

    private void updateNumericValue(IndexWriter writer, Iterable<? extends IndexableField> doc, String termName) throws IOException {
        String termValue = null;
        ArrayList<IndexableField> numericFieldList = new ArrayList<IndexableField>();
        for (IndexableField indexableField : doc) {
            if (termName.equals(indexableField.name()) && indexableField.stringValue() != null) {
                termValue = indexableField.stringValue();
                continue;
            }
            if (!(indexableField instanceof NumericDocValuesField)) continue;
            numericFieldList.add(indexableField);
        }
        if (termValue == null) {
            throw new IllegalArgumentException("A value of term is not found in the doc.");
        }
        for (IndexableField indexableField : numericFieldList) {
            writer.updateNumericDocValue(new Term(termName, termValue), indexableField.name(), Long.valueOf(indexableField.numericValue().longValue()));
        }
    }
}

