/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;

enum ParamType {
    CONTEXT{

        @Override
        boolean apply(Object param) {
            return param instanceof Context;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return ((Context)param).model();
        }
    }
    ,
    STRING{

        @Override
        boolean apply(Object param) {
            if (param instanceof String) {
                String string = (String)param;
                return string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
            }
            return false;
        }

        @Override
        Object doParse(Context scope, Object param) {
            String string = (String)param;
            return string.subSequence(1, string.length() - 1);
        }
    }
    ,
    BOOLEAN{

        @Override
        boolean apply(Object param) {
            return param instanceof Boolean;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return param;
        }
    }
    ,
    INTEGER{

        @Override
        boolean apply(Object param) {
            return param instanceof Integer;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return param;
        }
    }
    ,
    REFERENCE{

        @Override
        boolean apply(Object param) {
            return param instanceof String;
        }

        @Override
        Object doParse(Context scope, Object param) {
            return scope.get((String)param);
        }
    };


    abstract boolean apply(Object var1);

    abstract Object doParse(Context var1, Object var2);

    public static Object parse(Context context, Object param) {
        return ParamType.get(param).doParse(context, param);
    }

    private static ParamType get(Object param) {
        for (ParamType type : ParamType.values()) {
            if (!type.apply(param)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported param: " + param);
    }
}

