/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final int limitSize;

    public LruHashMap(int limitSize) {
        this(limitSize, 16, 0.75f);
    }

    public LruHashMap(int limitSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.limitSize = limitSize;
    }

    public int getLimitSize() {
        return this.limitSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.limitSize;
    }
}

