/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResult;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.AccessResultDataImpl;
import org.seasar.robot.helper.MemoryDataHelper;
import org.seasar.robot.service.DataService;
import org.seasar.robot.util.AccessResultCallback;

public class DataServiceImpl
implements DataService {
    protected static volatile long idCount = 0L;
    private static Object idCountLock = new Object();
    @Resource
    protected MemoryDataHelper dataHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(AccessResult accessResult) {
        if (accessResult == null) {
            throw new RobotSystemException("AccessResult is null.");
        }
        Object object = idCountLock;
        synchronized (object) {
            accessResult.setId(++idCount);
            AccessResultData accessResultData = accessResult.getAccessResultData();
            if (accessResultData == null) {
                accessResultData = new AccessResultDataImpl();
                accessResultData.setTransformerName("NONE");
                accessResult.setAccessResultData(accessResultData);
            }
            accessResultData.setId(accessResult.getId());
            Map<String, AccessResult> arMap = this.dataHelper.getAccessResultMap(accessResult.getSessionId());
            if (arMap.containsKey(accessResult.getUrl())) {
                throw new RobotSystemException(accessResult.getUrl() + " already exists.");
            }
            arMap.put(accessResult.getUrl(), accessResult);
        }
    }

    @Override
    public int getCount(String sessionId) {
        return this.dataHelper.getAccessResultMap(sessionId).size();
    }

    @Override
    public void delete(String sessionId) {
        this.dataHelper.deleteAccessResultMap(sessionId);
    }

    @Override
    public void deleteAll() {
        this.dataHelper.clearUrlQueueList();
    }

    @Override
    public AccessResult getAccessResult(String sessionId, String url) {
        return this.dataHelper.getAccessResultMap(sessionId).get(url);
    }

    @Override
    public List<AccessResult> getAccessResultList(String url, boolean hasData) {
        return this.dataHelper.getAccessResultList(url);
    }

    @Override
    public void iterate(String sessionId, AccessResultCallback accessResultCallback) {
        Map<String, AccessResult> arMap = this.dataHelper.getAccessResultMap(sessionId);
        for (Map.Entry<String, AccessResult> entry : arMap.entrySet()) {
            accessResultCallback.iterate(entry.getValue());
        }
    }

    @Override
    public void iterateUrlDiff(String oldSessionId, String newSessionId, AccessResultCallback accessResultCallback) {
        Map<String, AccessResult> oldAccessResultMap = this.dataHelper.getAccessResultMap(oldSessionId);
        Map<String, AccessResult> newAccessResultMap = this.dataHelper.getAccessResultMap(newSessionId);
        for (Map.Entry<String, AccessResult> newEntry : newAccessResultMap.entrySet()) {
            if (oldAccessResultMap.keySet().contains(newEntry.getKey())) continue;
            accessResultCallback.iterate(newEntry.getValue());
        }
    }

    @Override
    public void update(AccessResult accessResult) {
        Map<String, AccessResult> arMap = this.dataHelper.getAccessResultMap(accessResult.getSessionId());
        if (!arMap.containsKey(accessResult.getUrl())) {
            throw new RobotSystemException(accessResult.getUrl() + " is not found.");
        }
        arMap.put(accessResult.getUrl(), accessResult);
    }

    @Override
    public void update(List<AccessResult> accessResultList) {
        for (AccessResult accessResult : accessResultList) {
            this.update(accessResult);
        }
    }
}

