/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.interval.impl;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.interval.impl.DefaultIntervalController;
import org.seasar.robot.util.CrawlingParameterUtil;

public class HostIntervalController
extends DefaultIntervalController {
    private final ConcurrentMap<String, AtomicLong> lastTimes = new ConcurrentHashMap<String, AtomicLong>();

    public HostIntervalController() {
    }

    public HostIntervalController(Map<String, Long> params) {
        super(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delayBeforeProcessing() {
        UrlQueue urlQueue = CrawlingParameterUtil.getUrlQueue();
        if (urlQueue == null) {
            return;
        }
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url) || url.startsWith("file:")) {
            return;
        }
        try {
            URL u = new URL(url);
            String host = u.getHost();
            if (host == null) {
                return;
            }
            AtomicLong lastTime = this.lastTimes.putIfAbsent(host, new AtomicLong(System.currentTimeMillis()));
            if (lastTime == null) {
                return;
            }
            AtomicLong atomicLong = lastTime;
            synchronized (atomicLong) {
                long currentTime;
                while (true) {
                    currentTime = System.currentTimeMillis();
                    long delayTime = lastTime.get() + this.delayMillisBeforeProcessing - currentTime;
                    if (delayTime <= 0L) break;
                    lastTime.wait(delayTime);
                }
                lastTime.set(currentTime);
            }
        }
        catch (Exception e) {
            throw new RobotSystemException(e);
        }
    }
}

