/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper.impl;

import java.util.Set;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.helper.LogHelper;
import org.seasar.robot.log.LogType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelperImpl
implements LogHelper {
    private static final Logger logger = LoggerFactory.getLogger(LogHelperImpl.class);

    @Override
    public void log(LogType key, Object ... objs) {
        switch (key) {
            case START_THREAD: {
                break;
            }
            case START_CRAWLING: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isInfoEnabled()) break;
                logger.info("Crawling URL: " + urlQueue.getUrl());
                break;
            }
            case UNSUPPORTED_URL_AT_CRAWLING_STARTED: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isInfoEnabled()) break;
                logger.info("Unsupported URL: " + urlQueue.getUrl());
                break;
            }
            case CHECK_LAST_MODIFIED: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isDebugEnabled()) break;
                logger.debug("Checking the last modified: " + urlQueue.getLastModified());
                break;
            }
            case NOT_MODIFIED: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isInfoEnabled()) break;
                logger.info("Not modified URL: " + urlQueue.getUrl());
                break;
            }
            case GET_CONTENT: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isDebugEnabled()) break;
                logger.debug("Getting the content from URL: " + urlQueue.getUrl());
                break;
            }
            case REDIRECT_LOCATION: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isInfoEnabled()) break;
                logger.info("Redirect to URL: " + urlQueue.getUrl());
                break;
            }
            case PROCESS_RESPONSE: {
                ResponseData responseData = (ResponseData)objs[2];
                if (!logger.isDebugEnabled()) break;
                logger.debug("Processing the response. Http Status: " + responseData.getHttpStatusCode() + ", Exec Time: " + responseData.getExecutionTime());
                break;
            }
            case FINISHED_CRAWLING: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                if (!logger.isDebugEnabled()) break;
                logger.debug("Finished " + urlQueue.getUrl());
                break;
            }
            case PROCESS_CHILD_URLS_BY_EXCEPTION: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                Set childUrlSet = (Set)objs[2];
                if (!logger.isDebugEnabled()) break;
                for (String url : childUrlSet) {
                    logger.debug("Child URL: " + url + " from " + urlQueue.getUrl());
                }
                break;
            }
            case PROCESS_CHILD_URL_BY_EXCEPTION: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                String url = (String)objs[2];
                Throwable e = (Throwable)objs[3];
                if (!logger.isDebugEnabled()) break;
                logger.debug("Child URL: " + url + " from " + urlQueue.getUrl(), e);
                break;
            }
            case CRAWLING_ACCESS_EXCEPTION: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                RobotCrawlAccessException e = (RobotCrawlAccessException)objs[2];
                if (e.isDebugEnabled()) {
                    logger.debug("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                    break;
                }
                if (e.isInfoEnabled()) {
                    logger.info(e.getMessage());
                    break;
                }
                if (e.isWarnEnabled()) {
                    logger.warn("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                    break;
                }
                if (!e.isErrorEnabled()) break;
                logger.error("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                break;
            }
            case CRAWLING_EXCETPION: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                Throwable e = (Throwable)objs[2];
                logger.error("Crawling Exception at " + urlQueue.getUrl(), e);
                break;
            }
            case NO_URL_IN_QUEUE: {
                UrlQueue urlQueue = (UrlQueue)objs[1];
                Integer threadCheckCount = (Integer)objs[2];
                if (!logger.isDebugEnabled()) break;
                if (urlQueue != null && urlQueue.getUrl() != null) {
                    logger.debug(urlQueue.getUrl() + " is not a target url. (" + threadCheckCount + ")");
                    break;
                }
                logger.debug("The url is null. (" + threadCheckCount + ")");
                break;
            }
            case FINISHED_THREAD: {
                break;
            }
            case NO_RESPONSE_PROCESSOR: {
                ResponseData responseData = (ResponseData)objs[2];
                if (!logger.isDebugEnabled()) break;
                logger.debug("No ResponseProcessor for (" + responseData.getUrl() + ", " + responseData.getMimeType() + "). PLEASE CHECK YOUR CONFIGURATION.");
                break;
            }
            case NO_RULE: {
                ResponseData responseData = (ResponseData)objs[2];
                if (!logger.isDebugEnabled()) break;
                logger.debug("No rule for (" + responseData.getUrl() + ", " + responseData.getMimeType() + "). PLEASE CHECK YOUR CONFIGURATION.");
                break;
            }
            case SYSTEM_ERROR: {
                Throwable t = (Throwable)objs[0];
                if (!logger.isErrorEnabled()) break;
                logger.error("System Error.", t);
                break;
            }
        }
    }
}

