/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BOMInputStream;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotTxtException;
import org.seasar.robot.entity.RobotsTxt;

public class RobotsTxtHelper {
    protected static final Pattern USER_AGENT_RECORD = Pattern.compile("^user-agent:\\s*([^\\t\\n\\x0B\\f\\r]+)\\s*$", 2);
    protected static final Pattern DISALLOW_RECORD = Pattern.compile("^disallow:\\s*([^\\s]*)\\s*$", 2);
    protected static final Pattern ALLOW_RECORD = Pattern.compile("^allow:\\s*([^\\s]*)\\s*$", 2);
    protected static final Pattern CRAWL_DELAY_RECORD = Pattern.compile("^crawl-delay:\\s*([^\\s]+)\\s*$", 2);
    protected static final Pattern SITEMAP_RECORD = Pattern.compile("^sitemap:\\s*([^\\s]+)\\s*$", 2);
    protected boolean enabled = true;

    public RobotsTxt parse(InputStream stream) {
        return this.parse(stream, "UTF-8");
    }

    public RobotsTxt parse(InputStream stream, String charsetName) {
        if (!this.enabled) {
            return null;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(stream), charsetName));
            RobotsTxt robotsTxt = new RobotsTxt();
            ArrayList<RobotsTxt.Directive> currentDirectiveList = new ArrayList<RobotsTxt.Directive>();
            boolean isGroupRecodeStarted = false;
            while ((line = reader.readLine()) != null) {
                if (StringUtil.isEmpty((String)(line = this.stripComment(line).trim()))) continue;
                String value = this.getValue(USER_AGENT_RECORD, line);
                if (value != null) {
                    String userAgent;
                    RobotsTxt.Directive currentDirective;
                    if (isGroupRecodeStarted) {
                        currentDirectiveList.clear();
                        isGroupRecodeStarted = false;
                    }
                    if ((currentDirective = robotsTxt.getDirective(userAgent = value.toLowerCase(Locale.ENGLISH))) != null) continue;
                    currentDirective = new RobotsTxt.Directive(userAgent);
                    robotsTxt.addDirective(currentDirective);
                    currentDirectiveList.add(currentDirective);
                    continue;
                }
                isGroupRecodeStarted = true;
                value = this.getValue(DISALLOW_RECORD, line);
                if (value != null) {
                    if (currentDirectiveList.isEmpty() || value.length() <= 0) continue;
                    for (RobotsTxt.Directive directive : currentDirectiveList) {
                        directive.addDisallow(value);
                    }
                    continue;
                }
                value = this.getValue(ALLOW_RECORD, line);
                if (value != null) {
                    if (currentDirectiveList.isEmpty() || value.length() <= 0) continue;
                    for (RobotsTxt.Directive directive : currentDirectiveList) {
                        directive.addAllow(value);
                    }
                    continue;
                }
                value = this.getValue(CRAWL_DELAY_RECORD, line);
                if (value != null) {
                    if (currentDirectiveList.isEmpty()) continue;
                    try {
                        int crawlDelay = Integer.parseInt(value);
                        for (RobotsTxt.Directive directive : currentDirectiveList) {
                            directive.setCrawlDelay(Math.max(0, crawlDelay));
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                value = this.getValue(SITEMAP_RECORD, line);
                if (value == null || value.length() <= 0) continue;
                robotsTxt.addSitemap(value);
            }
            return robotsTxt;
        }
        catch (Exception e) {
            throw new RobotTxtException("Failed to parse robots.txt.", e);
        }
    }

    protected String getValue(Pattern pattern, String line) {
        Matcher m = pattern.matcher(line);
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    protected String stripComment(String line) {
        int commentIndex = line.indexOf(35);
        if (commentIndex != -1) {
            return line.substring(0, commentIndex);
        }
        return line;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

