/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.client.S2RobotClient;

public class S2RobotClientFactory {
    protected Map<Pattern, S2RobotClient> clientMap = new HashMap<Pattern, S2RobotClient>();

    public void addClient(String regex, S2RobotClient client) {
        if (StringUtil.isBlank((String)regex)) {
            throw new RobotSystemException("A regular expression is null.");
        }
        if (client == null) {
            throw new RobotSystemException("S2RobotClient is null.");
        }
        this.clientMap.put(Pattern.compile(regex), client);
    }

    public void addClient(List<String> regexList, S2RobotClient client) {
        if (regexList == null || regexList.isEmpty()) {
            throw new RobotSystemException("A regular expression list is null or empty.");
        }
        if (client == null) {
            throw new RobotSystemException("S2RobotClient is null.");
        }
        for (String regex : regexList) {
            if (!StringUtil.isNotBlank((String)regex)) continue;
            this.clientMap.put(Pattern.compile(regex), client);
        }
    }

    public S2RobotClient getClient(String url) {
        if (StringUtil.isBlank((String)url)) {
            return null;
        }
        for (Map.Entry<Pattern, S2RobotClient> entry : this.clientMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(url);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setInitParameterMap(Map<String, Object> params) {
        if (params != null) {
            for (S2RobotClient client : this.clientMap.values()) {
                client.setInitParameterMap(params);
            }
        }
    }
}

