/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.LoggingInfoStream;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SolrIndexConfig {
    public static final Logger log = LoggerFactory.getLogger(SolrIndexConfig.class);
    final String defaultMergePolicyClassName;
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    public final Version luceneVersion;
    @Deprecated
    public final boolean useCompoundFile;
    private boolean effectiveUseCompountFileSetting;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int maxIndexingThreads;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int writeLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final int termIndexInterval;
    public final PluginInfo mergedSegmentWarmerInfo;
    public InfoStream infoStream = InfoStream.NO_OUTPUT;
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";

    private SolrIndexConfig(SolrConfig solrConfig) {
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.effectiveUseCompountFileSetting = false;
        this.useCompoundFile = false;
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.maxIndexingThreads = 8;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = 100.0;
        this.writeLockTimeout = -1;
        this.lockType = LOCK_TYPE_NATIVE;
        this.termIndexInterval = 32;
        this.mergePolicyInfo = null;
        this.mergeSchedulerInfo = null;
        this.defaultMergePolicyClassName = TieredMergePolicy.class.getName();
        this.mergedSegmentWarmerInfo = null;
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        if (prefix == null) {
            prefix = "indexConfig";
            log.debug("Defaulting to prefix \"" + prefix + "\" for index configuration");
        }
        if (def == null) {
            def = new SolrIndexConfig(solrConfig);
        }
        Node unused = solrConfig.getNode(prefix, false);
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.assertWarnOrFail("The <mergeScheduler>myclass</mergeScheduler> syntax is no longer supported in solrconfig.xml. Please use syntax <mergeScheduler class=\"myclass\"/> instead.", solrConfig.getNode(prefix + "/mergeScheduler", false) == null || solrConfig.get(prefix + "/mergeScheduler/@class", null) != null, true);
        this.assertWarnOrFail("The <mergePolicy>myclass</mergePolicy> syntax is no longer supported in solrconfig.xml. Please use syntax <mergePolicy class=\"myclass\"/> instead.", solrConfig.getNode(prefix + "/mergePolicy", false) == null || solrConfig.get(prefix + "/mergePolicy/@class", null) != null, true);
        this.assertWarnOrFail("The <luceneAutoCommit>true|false</luceneAutoCommit> parameter is no longer valid in solrconfig.xml.", solrConfig.get(prefix + "/luceneAutoCommit", null) == null, true);
        this.defaultMergePolicyClassName = def.defaultMergePolicyClassName;
        this.effectiveUseCompountFileSetting = this.useCompoundFile = solrConfig.getBool(prefix + "/useCompoundFile", def.useCompoundFile);
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.maxIndexingThreads = solrConfig.getInt(prefix + "/maxIndexingThreads", def.maxIndexingThreads);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "/ramBufferSizeMB", def.ramBufferSizeMB);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        this.mergeSchedulerInfo = this.getPluginInfo(prefix + "/mergeScheduler", solrConfig, def.mergeSchedulerInfo);
        this.mergePolicyInfo = this.getPluginInfo(prefix + "/mergePolicy", solrConfig, def.mergePolicyInfo);
        this.termIndexInterval = solrConfig.getInt(prefix + "/termIndexInterval", def.termIndexInterval);
        boolean infoStreamEnabled = solrConfig.getBool(prefix + "/infoStream", false);
        if (infoStreamEnabled) {
            String infoStreamFile = solrConfig.get(prefix + "/infoStream/@file", null);
            if (infoStreamFile == null) {
                log.info("IndexWriter infoStream solr logging is enabled");
                this.infoStream = new LoggingInfoStream();
            } else {
                log.warn("IndexWriter infoStream file log is enabled: " + infoStreamFile + "\nThis feature is deprecated. Remove @file from <infoStream> to output messages to solr's logfile");
                File f = new File(infoStreamFile);
                File parent = f.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                try {
                    FileOutputStream fos = new FileOutputStream(f, true);
                    this.infoStream = new PrintStreamInfoStream(new PrintStream((OutputStream)fos, true, "UTF-8"));
                }
                catch (Exception e) {
                    log.error("Could not create info stream for file " + infoStreamFile, (Throwable)e);
                }
            }
        }
        this.mergedSegmentWarmerInfo = this.getPluginInfo(prefix + "/mergedSegmentWarmer", solrConfig, def.mergedSegmentWarmerInfo);
        if (this.mergedSegmentWarmerInfo != null && !solrConfig.nrtMode) {
            throw new IllegalArgumentException("Supplying a mergedSegmentWarmer will do nothing since nrtMode is false");
        }
    }

    private void assertWarnOrFail(String reason, boolean assertCondition, boolean failCondition) {
        if (assertCondition) {
            return;
        }
        if (failCondition) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, reason);
        }
        log.warn(reason);
    }

    private PluginInfo getPluginInfo(String path, SolrConfig solrConfig, PluginInfo def) {
        List<PluginInfo> l = solrConfig.readPluginInfos(path, false, true);
        return l.isEmpty() ? def : l.get(0);
    }

    public IndexWriterConfig toIndexWriterConfig(IndexSchema schema) {
        IndexWriterConfig iwc = new IndexWriterConfig(this.luceneVersion, null);
        if (this.maxBufferedDocs != -1) {
            iwc.setMaxBufferedDocs(this.maxBufferedDocs);
        }
        if (this.ramBufferSizeMB != -1.0) {
            iwc.setRAMBufferSizeMB(this.ramBufferSizeMB);
        }
        if (this.termIndexInterval != -1) {
            iwc.setTermIndexInterval(this.termIndexInterval);
        }
        if (this.writeLockTimeout != -1) {
            iwc.setWriteLockTimeout((long)this.writeLockTimeout);
        }
        iwc.setSimilarity(schema.getSimilarity());
        iwc.setMergePolicy(this.buildMergePolicy(schema));
        iwc.setMergeScheduler(this.buildMergeScheduler(schema));
        iwc.setInfoStream(this.infoStream);
        iwc.setUseCompoundFile(this.getUseCompoundFile());
        if (this.maxIndexingThreads != -1) {
            iwc.setMaxThreadStates(this.maxIndexingThreads);
        }
        if (this.mergedSegmentWarmerInfo != null) {
            IndexWriter.IndexReaderWarmer warmer = schema.getResourceLoader().newInstance(this.mergedSegmentWarmerInfo.className, IndexWriter.IndexReaderWarmer.class, null, new Class[]{InfoStream.class}, new Object[]{iwc.getInfoStream()});
            iwc.setMergedSegmentWarmer(warmer);
        }
        return iwc;
    }

    private MergePolicy buildMergePolicy(IndexSchema schema) {
        String mpClassName = this.mergePolicyInfo == null ? this.defaultMergePolicyClassName : this.mergePolicyInfo.className;
        MergePolicy policy = schema.getResourceLoader().newInstance(mpClassName, MergePolicy.class);
        if (policy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)policy;
            this.fixUseCFMergePolicyInitArg(LogMergePolicy.class);
            if (this.maxMergeDocs != -1) {
                logMergePolicy.setMaxMergeDocs(this.maxMergeDocs);
            }
            logMergePolicy.setNoCFSRatio(this.getUseCompoundFile() ? 1.0 : 0.0);
            if (this.mergeFactor != -1) {
                logMergePolicy.setMergeFactor(this.mergeFactor);
            }
        } else if (policy instanceof TieredMergePolicy) {
            TieredMergePolicy tieredMergePolicy = (TieredMergePolicy)policy;
            this.fixUseCFMergePolicyInitArg(TieredMergePolicy.class);
            tieredMergePolicy.setNoCFSRatio(this.getUseCompoundFile() ? 1.0 : 0.0);
            if (this.mergeFactor != -1) {
                tieredMergePolicy.setMaxMergeAtOnce(this.mergeFactor);
                tieredMergePolicy.setSegmentsPerTier((double)this.mergeFactor);
            }
        } else if (this.mergeFactor != -1) {
            log.warn("Use of <mergeFactor> cannot be configured if merge policy is not an instance of LogMergePolicy or TieredMergePolicy. The configured policy's defaults will be used.");
        }
        if (this.mergePolicyInfo != null) {
            SolrPluginUtils.invokeSetters(policy, this.mergePolicyInfo.initArgs);
        }
        return policy;
    }

    private MergeScheduler buildMergeScheduler(IndexSchema schema) {
        String msClassName = this.mergeSchedulerInfo == null ? DEFAULT_MERGE_SCHEDULER_CLASSNAME : this.mergeSchedulerInfo.className;
        MergeScheduler scheduler = schema.getResourceLoader().newInstance(msClassName, MergeScheduler.class);
        if (this.mergeSchedulerInfo != null) {
            if (scheduler instanceof ConcurrentMergeScheduler) {
                Integer maxThreadCount;
                NamedList args = this.mergeSchedulerInfo.initArgs.clone();
                Integer maxMergeCount = (Integer)args.remove("maxMergeCount");
                if (maxMergeCount == null) {
                    maxMergeCount = ((ConcurrentMergeScheduler)scheduler).getMaxMergeCount();
                }
                if ((maxThreadCount = (Integer)args.remove("maxThreadCount")) == null) {
                    maxThreadCount = ((ConcurrentMergeScheduler)scheduler).getMaxThreadCount();
                }
                ((ConcurrentMergeScheduler)scheduler).setMaxMergesAndThreads(maxMergeCount.intValue(), maxThreadCount.intValue());
                SolrPluginUtils.invokeSetters(scheduler, args);
            } else {
                SolrPluginUtils.invokeSetters(scheduler, this.mergeSchedulerInfo.initArgs);
            }
        }
        return scheduler;
    }

    public boolean getUseCompoundFile() {
        return this.effectiveUseCompountFileSetting;
    }

    private void fixUseCFMergePolicyInitArg(Class c) {
        if (null == this.mergePolicyInfo || null == this.mergePolicyInfo.initArgs) {
            return;
        }
        Object useCFSArg = this.mergePolicyInfo.initArgs.remove("useCompoundFile");
        if (null != useCFSArg) {
            log.warn("Ignoring 'useCompoundFile' specified as an init arg for the <mergePolicy> since it is no directly longer supported by " + c.getSimpleName());
            if (useCFSArg instanceof Boolean) {
                boolean cfs = (Boolean)useCFSArg;
                log.warn("Please update your config to specify <useCompoundFile>" + cfs + "</useCompoundFile> directly in your <indexConfig> settings.");
                this.effectiveUseCompountFileSetting = cfs;
            } else {
                log.error("MergePolicy's 'useCompoundFile' init arg is not a boolean, can not apply back compat logic to apply to the IndexWriterConfig: " + useCFSArg.toString());
            }
        }
    }
}

