/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.util.FastWriter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperInfoServlet
extends HttpServlet {
    static final Logger log = LoggerFactory.getLogger(ZookeeperInfoServlet.class);

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String detailS;
        SolrParams params;
        CoreContainer cores = (CoreContainer)request.getAttribute("org.apache.solr.CoreContainer");
        if (cores == null) {
            throw new ServletException("Missing request attribute org.apache.solr.CoreContainer.");
        }
        try {
            params = SolrRequestParsers.DEFAULT.parse(null, request.getServletPath(), request).getParams();
        }
        catch (Exception e) {
            int code = 500;
            if (e instanceof SolrException) {
                code = Math.min(599, Math.max(100, ((SolrException)((Object)e)).code()));
            }
            response.sendError(code, e.toString());
            return;
        }
        String path = params.get("path");
        String addr = params.get("addr");
        if (addr != null && addr.length() == 0) {
            addr = null;
        }
        boolean detail = (detailS = params.get("detail")) != null && detailS.equals("true");
        String dumpS = params.get("dump");
        boolean dump = dumpS != null && dumpS.equals("true");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        FastWriter out = new FastWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), IOUtils.CHARSET_UTF_8));
        ZKPrinter printer = new ZKPrinter(response, out, cores.getZkController(), addr);
        printer.detail = detail;
        printer.dump = dump;
        try {
            printer.print(path);
        }
        finally {
            printer.close();
        }
        ((Writer)out).flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    static class ZKPrinter {
        static boolean FULLPATH_DEFAULT = false;
        boolean indent = true;
        boolean fullpath = FULLPATH_DEFAULT;
        boolean detail = false;
        boolean dump = false;
        String addr;
        String keeperAddr;
        boolean doClose;
        final HttpServletResponse response;
        final Writer out;
        SolrZkClient zkClient;
        int level;
        int maxData = 95;

        public ZKPrinter(HttpServletResponse response, Writer out, ZkController controller, String addr) throws IOException {
            this.response = response;
            this.out = out;
            this.addr = addr;
            if (addr == null && controller != null) {
                this.keeperAddr = controller.getZkServerAddress();
                this.zkClient = controller.getZkClient();
                if (this.zkClient != null && this.zkClient.isConnected()) {
                    return;
                }
                addr = this.keeperAddr;
            }
            this.keeperAddr = addr;
            if (addr == null) {
                this.writeError(404, "Zookeeper is not configured for this Solr Core. Please try connecting to an alternate zookeeper address.");
                return;
            }
            try {
                this.zkClient = new SolrZkClient(addr, 10000);
                this.doClose = true;
            }
            catch (Exception e) {
                this.writeError(503, "Could not connect to zookeeper at '" + addr + "'\"");
                this.zkClient = null;
                return;
            }
        }

        public void close() {
            if (this.doClose) {
                this.zkClient.close();
            }
        }

        void print(String path) throws IOException {
            int idx;
            String parent;
            if (this.zkClient == null) {
                return;
            }
            if (path == null) {
                path = "/";
            } else {
                path.trim();
                if (path.length() == 0) {
                    path = "/";
                }
            }
            if (path.endsWith("/") && path.length() > 1) {
                path = path.substring(0, path.length() - 1);
            }
            String string = parent = (idx = path.lastIndexOf(47)) >= 0 ? path.substring(0, idx) : path;
            if (parent.length() == 0) {
                parent = "/";
            }
            CharArr chars = new CharArr();
            JSONWriter json = new JSONWriter(chars, 2);
            json.startObject();
            if (this.detail) {
                if (!this.printZnode(json, path)) {
                    return;
                }
                json.writeValueSeparator();
            }
            json.writeString((CharSequence)"tree");
            json.writeNameSeparator();
            json.startArray();
            if (!this.printTree(json, path)) {
                return;
            }
            json.endArray();
            json.endObject();
            this.out.write(chars.toString());
        }

        void writeError(int code, String msg) throws IOException {
            this.response.setStatus(code);
            CharArr chars = new CharArr();
            JSONWriter w = new JSONWriter(chars, 2);
            w.startObject();
            w.indent();
            w.writeString((CharSequence)"status");
            w.writeNameSeparator();
            w.write(code);
            w.writeValueSeparator();
            w.indent();
            w.writeString((CharSequence)"error");
            w.writeNameSeparator();
            w.writeString((CharSequence)msg);
            w.endObject();
            this.out.write(chars.toString());
        }

        boolean printTree(JSONWriter json, String path) throws IOException {
            String label = path;
            if (!this.fullpath) {
                int idx = path.lastIndexOf(47);
                label = idx > 0 ? path.substring(idx + 1) : path;
            }
            json.startObject();
            json.writeString((CharSequence)"data");
            json.writeNameSeparator();
            json.startObject();
            this.writeKeyValue(json, "title", label, true);
            json.writeValueSeparator();
            json.writeString((CharSequence)"attr");
            json.writeNameSeparator();
            json.startObject();
            this.writeKeyValue(json, "href", "zookeeper?detail=true&path=" + URLEncoder.encode(path, "UTF-8"), true);
            json.endObject();
            json.endObject();
            Stat stat = new Stat();
            try {
                byte[] data = this.zkClient.getData(path, null, stat, true);
                if (stat.getEphemeralOwner() != 0L) {
                    this.writeKeyValue(json, "ephemeral", true, false);
                    this.writeKeyValue(json, "version", stat.getVersion(), false);
                }
                if (this.dump) {
                    json.writeValueSeparator();
                    this.printZnode(json, path);
                }
            }
            catch (IllegalArgumentException e) {
                this.writeKeyValue(json, "warning", "(path gone)", false);
            }
            catch (KeeperException e) {
                this.writeKeyValue(json, "warning", e.toString(), false);
                log.warn("Keeper Exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.writeKeyValue(json, "warning", e.toString(), false);
                log.warn("InterruptedException", (Throwable)e);
            }
            if (stat.getNumChildren() > 0) {
                json.writeValueSeparator();
                if (this.indent) {
                    json.indent();
                }
                json.writeString((CharSequence)"children");
                json.writeNameSeparator();
                json.startArray();
                try {
                    List children = this.zkClient.getChildren(path, null, true);
                    Collections.sort(children);
                    boolean first = true;
                    for (String child : children) {
                        String childPath;
                        if (!first) {
                            json.writeValueSeparator();
                        }
                        if (!this.printTree(json, childPath = path + (path.endsWith("/") ? "" : "/") + child)) {
                            return false;
                        }
                        first = false;
                    }
                }
                catch (KeeperException e) {
                    this.writeError(500, e.toString());
                    return false;
                }
                catch (InterruptedException e) {
                    this.writeError(500, e.toString());
                    return false;
                }
                catch (IllegalArgumentException e) {
                    json.writeString((CharSequence)"(children gone)");
                }
                json.endArray();
            }
            json.endObject();
            return true;
        }

        String time(long ms) {
            return new Date(ms).toString() + " (" + ms + ")";
        }

        public void writeKeyValue(JSONWriter json, String k, Object v, boolean isFirst) {
            if (!isFirst) {
                json.writeValueSeparator();
            }
            if (this.indent) {
                json.indent();
            }
            json.writeString((CharSequence)k);
            json.writeNameSeparator();
            json.write(v);
        }

        boolean printZnode(JSONWriter json, String path) throws IOException {
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(path, null, stat, true);
                String dataStr = null;
                String dataStrErr = null;
                if (null != data) {
                    try {
                        dataStr = new BytesRef(data).utf8ToString();
                    }
                    catch (Exception e) {
                        dataStrErr = "data is not parsable as a utf8 String: " + e.toString();
                    }
                }
                json.writeString((CharSequence)"znode");
                json.writeNameSeparator();
                json.startObject();
                this.writeKeyValue(json, "path", path, true);
                json.writeValueSeparator();
                json.writeString((CharSequence)"prop");
                json.writeNameSeparator();
                json.startObject();
                this.writeKeyValue(json, "version", stat.getVersion(), true);
                this.writeKeyValue(json, "aversion", stat.getAversion(), false);
                this.writeKeyValue(json, "children_count", stat.getNumChildren(), false);
                this.writeKeyValue(json, "ctime", this.time(stat.getCtime()), false);
                this.writeKeyValue(json, "cversion", stat.getCversion(), false);
                this.writeKeyValue(json, "czxid", stat.getCzxid(), false);
                this.writeKeyValue(json, "ephemeralOwner", stat.getEphemeralOwner(), false);
                this.writeKeyValue(json, "mtime", this.time(stat.getMtime()), false);
                this.writeKeyValue(json, "mzxid", stat.getMzxid(), false);
                this.writeKeyValue(json, "pzxid", stat.getPzxid(), false);
                this.writeKeyValue(json, "dataLength", stat.getDataLength(), false);
                if (null != dataStrErr) {
                    this.writeKeyValue(json, "dataNote", dataStrErr, false);
                }
                json.endObject();
                if (null != dataStr) {
                    this.writeKeyValue(json, "data", dataStr, false);
                }
                json.endObject();
            }
            catch (KeeperException e) {
                this.writeError(500, e.toString());
                return false;
            }
            catch (InterruptedException e) {
                this.writeError(500, e.toString());
                return false;
            }
            return true;
        }
    }
}

