/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavabinLoader
extends ContentStreamLoader {
    public static Logger log = LoggerFactory.getLogger(JavabinLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        InputStream is = null;
        try {
            is = stream.getStream();
            this.parseAndLoadDocs(req, rsp, is, processor);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void parseAndLoadDocs(final SolrQueryRequest req, SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        UpdateRequest update = null;
        JavaBinUpdateRequestCodec.StreamingUpdateHandler handler = new JavaBinUpdateRequestCodec.StreamingUpdateHandler(){
            private AddUpdateCommand addCmd = null;

            public void update(SolrInputDocument document, UpdateRequest updateRequest, Integer commitWithin, Boolean overwrite) {
                if (document == null) {
                    try {
                        RequestHandlerUtils.handleCommit(req, processor, (SolrParams)updateRequest.getParams(), false);
                        RequestHandlerUtils.handleRollback(req, processor, (SolrParams)updateRequest.getParams(), false);
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR handling commit/rollback");
                    }
                    return;
                }
                if (this.addCmd == null) {
                    this.addCmd = JavabinLoader.this.getAddCommand(req, (SolrParams)updateRequest.getParams());
                }
                this.addCmd.solrDoc = document;
                if (commitWithin != null) {
                    this.addCmd.commitWithin = commitWithin;
                }
                if (overwrite != null) {
                    this.addCmd.overwrite = overwrite;
                }
                try {
                    processor.processAdd(this.addCmd);
                    this.addCmd.clear();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR adding document " + document);
                }
            }
        };
        FastInputStream in = FastInputStream.wrap((InputStream)stream);
        while (true) {
            try {
                update = new JavaBinUpdateRequestCodec().unmarshal((InputStream)in, handler);
            }
            catch (EOFException e) {
                break;
            }
            if (update.getDeleteByIdMap() == null && update.getDeleteQuery() == null) continue;
            this.delete(req, update, processor);
        }
    }

    private AddUpdateCommand getAddCommand(SolrQueryRequest req, SolrParams params) {
        AddUpdateCommand addCmd = new AddUpdateCommand(req);
        addCmd.overwrite = params.getBool("overwrite", true);
        addCmd.commitWithin = params.getInt("commitWithin", -1);
        return addCmd;
    }

    private void delete(SolrQueryRequest req, UpdateRequest update, UpdateRequestProcessor processor) throws IOException {
        ModifiableSolrParams params = update.getParams();
        DeleteUpdateCommand delcmd = new DeleteUpdateCommand(req);
        if (params != null) {
            delcmd.commitWithin = params.getInt("commitWithin", -1);
        }
        if (update.getDeleteByIdMap() != null) {
            Set entries = update.getDeleteByIdMap().entrySet();
            for (Map.Entry e : entries) {
                Long version;
                delcmd.id = (String)e.getKey();
                Map map = (Map)e.getValue();
                if (map != null && (version = (Long)map.get("ver")) != null) {
                    delcmd.setVersion(version);
                }
                processor.processDelete(delcmd);
                delcmd.clear();
            }
        }
        if (update.getDeleteQuery() != null) {
            Iterator i$ = update.getDeleteQuery().iterator();
            while (i$.hasNext()) {
                String s;
                delcmd.query = s = (String)i$.next();
                processor.processDelete(delcmd);
            }
        }
    }
}

