/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardFieldSortedHitQueue;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.grouping.CommandHandler;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.ShardRequestFactory;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.requestfactory.SearchGroupsRequestFactory;
import org.apache.solr.search.grouping.distributed.requestfactory.StoredFieldsShardRequestFactory;
import org.apache.solr.search.grouping.distributed.requestfactory.TopGroupsShardRequestFactory;
import org.apache.solr.search.grouping.distributed.responseprocessor.SearchGroupShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.responseprocessor.StoredFieldsShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.responseprocessor.TopGroupsShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;
import org.apache.solr.search.grouping.distributed.shardresultserializer.TopGroupsResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.GroupedEndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.MainEndResultTransformer;
import org.apache.solr.search.grouping.endresulttransformer.SimpleEndResultTransformer;
import org.apache.solr.util.SolrPluginUtils;

public class QueryComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "query";
    private static final EndResultTransformer MAIN_END_RESULT_TRANSFORMER = new MainEndResultTransformer();
    private static final EndResultTransformer SIMPLE_END_RESULT_TRANSFORMER = new SimpleEndResultTransformer();

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        SolrQueryResponse rsp = rb.rsp;
        SolrReturnFields returnFields = new SolrReturnFields(req);
        rsp.setReturnFields(returnFields);
        int flags = 0;
        if (((ReturnFields)returnFields).wantsScore()) {
            flags |= 1;
        }
        rb.setFieldFlags(flags);
        String defType = params.get("defType", "lucene");
        String queryString = rb.getQueryString();
        if (queryString == null) {
            queryString = params.get("q");
            rb.setQueryString(queryString);
        }
        try {
            String[] fqs;
            QParser parser = QParser.getParser(rb.getQueryString(), defType, req);
            Query q = parser.getQuery();
            if (q == null) {
                q = new BooleanQuery();
            }
            rb.setQuery(q);
            rb.setSortSpec(parser.getSort(true));
            rb.setQparser(parser);
            String cursorStr = rb.req.getParams().get("cursorMark");
            if (null != cursorStr) {
                CursorMark cursorMark = new CursorMark(rb.req.getSchema(), rb.getSortSpec());
                cursorMark.parseSerializedTotem(cursorStr);
                rb.setCursorMark(cursorMark);
            }
            if ((fqs = req.getParams().getParams("fq")) != null && fqs.length != 0) {
                List<Query> filters = rb.getFilters();
                filters = filters == null ? new ArrayList<Query>(fqs.length) : new ArrayList<Query>(filters);
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0) continue;
                    QParser fqp = QParser.getParser(fq, null, req);
                    filters.add(fqp.getQuery());
                }
                if (!filters.isEmpty()) {
                    rb.setFilters(filters);
                }
            }
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        if (params.getBool("group", false)) {
            this.prepareGrouping(rb);
        }
    }

    private void prepareGrouping(ResponseBuilder rb) throws IOException {
        Grouping.Format responseFormat;
        String groupSortStr;
        Sort sortWithinGroup;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (null != rb.getCursorMark()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use Grouping with cursorMark");
        }
        SolrIndexSearcher.QueryCommand cmd = rb.getQueryCommand();
        SolrIndexSearcher searcher = rb.req.getSearcher();
        GroupingSpecification groupingSpec = new GroupingSpecification();
        rb.setGroupingSpec(groupingSpec);
        Sort groupSort = searcher.weightSort(cmd.getSort());
        if (groupSort == null) {
            groupSort = Sort.RELEVANCE;
        }
        Sort sort = sortWithinGroup = (groupSortStr = params.get("group.sort")) == null ? groupSort : searcher.weightSort(QueryParsing.parseSortSpec(groupSortStr, req).getSort());
        if (sortWithinGroup == null) {
            sortWithinGroup = Sort.RELEVANCE;
        }
        groupingSpec.setSortWithinGroup(sortWithinGroup);
        groupingSpec.setGroupSort(groupSort);
        String formatStr = params.get("group.format", Grouping.Format.grouped.name());
        try {
            responseFormat = Grouping.Format.valueOf(formatStr);
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Illegal %s parameter", "group.format"));
        }
        groupingSpec.setResponseFormat(responseFormat);
        groupingSpec.setFields(params.getParams("group.field"));
        groupingSpec.setQueries(params.getParams("group.query"));
        groupingSpec.setFunctions(params.getParams("group.func"));
        groupingSpec.setGroupOffset(params.getInt("group.offset", 0));
        groupingSpec.setGroupLimit(params.getInt("group.limit", 1));
        groupingSpec.setOffset(rb.getSortSpec().getOffset());
        groupingSpec.setLimit(rb.getSortSpec().getCount());
        groupingSpec.setIncludeGroupCount(params.getBool("group.ngroups", false));
        groupingSpec.setMain(params.getBool("group.main", false));
        groupingSpec.setNeedScore((cmd.getFlags() & 1) != 0);
        groupingSpec.setTruncateGroups(params.getBool("group.truncate", false));
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = req.getParams();
        if (!params.getBool(COMPONENT_NAME, true)) {
            return;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        if (rb.getQueryCommand().getOffset() < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'start' parameter cannot be negative");
        }
        long timeAllowed = params.getInt("timeAllowed", -1);
        if (null != rb.getCursorMark() && 0L < timeAllowed) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not search using both cursorMark and timeAllowed");
        }
        String ids = params.get("ids");
        if (ids != null) {
            SchemaField idField = searcher.getSchema().getUniqueKeyField();
            List idArr = StrUtils.splitSmart((String)ids, (String)",", (boolean)true);
            int[] luceneIds = new int[idArr.size()];
            int docs = 0;
            for (int i = 0; i < idArr.size(); ++i) {
                int id = req.getSearcher().getFirstMatch(new Term(idField.getName(), idField.getType().toInternal((String)idArr.get(i))));
                if (id < 0) continue;
                luceneIds[docs++] = id;
            }
            DocListAndSet res = new DocListAndSet();
            res.docList = new DocSlice(0, docs, luceneIds, null, docs, 0.0f);
            if (rb.isNeedDocSet()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(rb.getQuery());
                List<Query> filters = rb.getFilters();
                if (filters != null) {
                    queries.addAll(filters);
                }
                res.docSet = searcher.getDocSet(queries);
            }
            rb.setResults(res);
            ResultContext ctx = new ResultContext();
            ctx.docs = rb.getResults().docList;
            ctx.query = null;
            rsp.add("response", ctx);
            return;
        }
        SolrIndexSearcher.QueryCommand cmd = rb.getQueryCommand();
        cmd.setTimeAllowed(timeAllowed);
        SolrIndexSearcher.QueryResult result = new SolrIndexSearcher.QueryResult();
        GroupingSpecification groupingSpec = rb.getGroupingSpec();
        if (groupingSpec != null) {
            try {
                boolean needScores;
                boolean bl = needScores = (cmd.getFlags() & 1) != 0;
                if (params.getBool("group.distributed.first", false)) {
                    CommandHandler.Builder topsGroupsActionBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setNeedDocSet(false).setIncludeHitCount(true).setSearcher(searcher);
                    for (String field : groupingSpec.getFields()) {
                        topsGroupsActionBuilder.addCommandField(new SearchGroupsFieldCommand.Builder().setField(searcher.getSchema().getField(field)).setGroupSort(groupingSpec.getGroupSort()).setTopNGroups(cmd.getOffset() + cmd.getLen()).setIncludeGroupCount(groupingSpec.isIncludeGroupCount()).build());
                    }
                    CommandHandler commandHandler = topsGroupsActionBuilder.build();
                    commandHandler.execute();
                    SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(searcher);
                    rsp.add("firstPhase", commandHandler.processResult(result, serializer));
                    rsp.add("totalHitCount", commandHandler.getTotalHitCount());
                    rb.setResult(result);
                    return;
                }
                if (params.getBool("group.distributed.second", false)) {
                    CommandHandler.Builder secondPhaseBuilder = new CommandHandler.Builder().setQueryCommand(cmd).setTruncateGroups(groupingSpec.isTruncateGroups() && groupingSpec.getFields().length > 0).setSearcher(searcher);
                    for (String field : groupingSpec.getFields()) {
                        String[] topGroupsParam = params.getParams("group.topgroups." + field);
                        if (topGroupsParam == null) {
                            topGroupsParam = new String[]{};
                        }
                        ArrayList<SearchGroup<BytesRef>> topGroups = new ArrayList<SearchGroup<BytesRef>>(topGroupsParam.length);
                        for (String topGroup : topGroupsParam) {
                            SearchGroup searchGroup = new SearchGroup();
                            if (!topGroup.equals("\u0001")) {
                                searchGroup.groupValue = new BytesRef((CharSequence)searcher.getSchema().getField(field).getType().readableToIndexed(topGroup));
                            }
                            topGroups.add(searchGroup);
                        }
                        secondPhaseBuilder.addCommandField(new TopGroupsFieldCommand.Builder().setField(searcher.getSchema().getField(field)).setGroupSort(groupingSpec.getGroupSort()).setSortWithinGroup(groupingSpec.getSortWithinGroup()).setFirstPhaseGroups(topGroups).setMaxDocPerGroup(groupingSpec.getGroupOffset() + groupingSpec.getGroupLimit()).setNeedScores(needScores).setNeedMaxScore(needScores).build());
                    }
                    for (String query : groupingSpec.getQueries()) {
                        secondPhaseBuilder.addCommandField(new QueryCommand.Builder().setDocsToCollect(groupingSpec.getOffset() + groupingSpec.getLimit()).setSort(groupingSpec.getGroupSort()).setQuery(query, rb.req).setDocSet(searcher).build());
                    }
                    CommandHandler commandHandler = secondPhaseBuilder.build();
                    commandHandler.execute();
                    TopGroupsResultTransformer serializer = new TopGroupsResultTransformer(rb);
                    rsp.add("secondPhase", commandHandler.processResult(result, serializer));
                    rb.setResult(result);
                    return;
                }
                int maxDocsPercentageToCache = params.getInt("group.cache.percent", 0);
                boolean cacheSecondPassSearch = maxDocsPercentageToCache >= 1 && maxDocsPercentageToCache <= 100;
                Grouping.TotalCount defaultTotalCount = groupingSpec.isIncludeGroupCount() ? Grouping.TotalCount.grouped : Grouping.TotalCount.ungrouped;
                int limitDefault = cmd.getLen();
                Grouping grouping = new Grouping(searcher, result, cmd, cacheSecondPassSearch, maxDocsPercentageToCache, groupingSpec.isMain());
                grouping.setSort(groupingSpec.getGroupSort()).setGroupSort(groupingSpec.getSortWithinGroup()).setDefaultFormat(groupingSpec.getResponseFormat()).setLimitDefault(limitDefault).setDefaultTotalCount(defaultTotalCount).setDocsPerGroupDefault(groupingSpec.getGroupLimit()).setGroupOffsetDefault(groupingSpec.getGroupOffset()).setGetGroupedDocSet(groupingSpec.isTruncateGroups());
                if (groupingSpec.getFields() != null) {
                    for (String field : groupingSpec.getFields()) {
                        grouping.addFieldCommand(field, rb.req);
                    }
                }
                if (groupingSpec.getFunctions() != null) {
                    for (String groupByStr : groupingSpec.getFunctions()) {
                        grouping.addFunctionCommand(groupByStr, rb.req);
                    }
                }
                if (groupingSpec.getQueries() != null) {
                    for (String groupByStr : groupingSpec.getQueries()) {
                        grouping.addQueryCommand(groupByStr, rb.req);
                    }
                }
                if (rb.doHighlights || rb.isDebug() || params.getBool("mlt", false)) {
                    cmd.setFlags(2);
                }
                grouping.execute();
                if (grouping.isSignalCacheWarning()) {
                    rsp.add("cacheWarning", String.format(Locale.ROOT, "Cache limit of %d percent relative to maxdoc has exceeded. Please increase cache size or disable caching.", maxDocsPercentageToCache));
                }
                rb.setResult(result);
                if (grouping.mainResult != null) {
                    ResultContext ctx = new ResultContext();
                    ctx.docs = grouping.mainResult;
                    ctx.query = null;
                    rsp.add("response", ctx);
                    rsp.getToLog().add("hits", (Object)grouping.mainResult.matches());
                } else if (!grouping.getCommands().isEmpty()) {
                    rsp.add("grouped", result.groupedResults);
                    rsp.getToLog().add("hits", (Object)grouping.getCommands().get(0).getMatches());
                }
                return;
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        searcher.search(result, cmd);
        rb.setResult(result);
        ResultContext ctx = new ResultContext();
        ctx.docs = rb.getResults().docList;
        ctx.query = rb.getQuery();
        rsp.add("response", ctx);
        rsp.getToLog().add("hits", (Object)rb.getResults().docList.matches());
        if (!rb.req.getParams().getBool("isShard", false) && null != rb.getNextCursorMark()) {
            rb.rsp.add("nextCursorMark", rb.getNextCursorMark().getSerializedTotem());
        }
        this.doFieldSortValues(rb, searcher);
        this.doPrefetch(rb);
    }

    protected void doFieldSortValues(ResponseBuilder rb, SolrIndexSearcher searcher) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        boolean fsv = req.getParams().getBool("fsv", false);
        if (fsv) {
            SortField[] sortFieldArray;
            NamedList sortVals = new NamedList();
            IndexReaderContext topReaderContext = searcher.getTopReaderContext();
            List leaves = topReaderContext.leaves();
            AtomicReaderContext currentLeaf = null;
            if (leaves.size() == 1) {
                currentLeaf = (AtomicReaderContext)leaves.get(0);
                leaves = null;
            }
            DocList docList = rb.getResults().docList;
            int nDocs = docList.size();
            long[] sortedIds = new long[nDocs];
            DocIterator it = rb.getResults().docList.iterator();
            for (int i = 0; i < nDocs; ++i) {
                sortedIds[i] = (long)it.nextDoc() << 32 | (long)i;
            }
            Arrays.sort(sortedIds);
            SortSpec sortSpec = rb.getSortSpec();
            Sort sort = searcher.weightSort(sortSpec.getSort());
            if (sort == null) {
                SortField[] sortFieldArray2 = new SortField[1];
                sortFieldArray = sortFieldArray2;
                sortFieldArray2[0] = SortField.FIELD_SCORE;
            } else {
                sortFieldArray = sort.getSort();
            }
            SortField[] sortFields = sortFieldArray;
            List<SchemaField> schemaFields = sortSpec.getSchemaFields();
            for (int fld = 0; fld < schemaFields.size(); ++fld) {
                SchemaField schemaField = schemaFields.get(fld);
                FieldType ft = null == schemaField ? null : schemaField.getType();
                SortField sortField = sortFields[fld];
                SortField.Type type = sortField.getType();
                if (type == SortField.Type.SCORE || type == SortField.Type.DOC) continue;
                FieldComparator comparator = null;
                Object[] vals = new Object[nDocs];
                int lastIdx = -1;
                int idx = 0;
                for (long idAndPos : sortedIds) {
                    int doc = (int)(idAndPos >>> 32);
                    int position = (int)idAndPos;
                    if (leaves != null) {
                        idx = ReaderUtil.subIndex((int)doc, (List)leaves);
                        currentLeaf = (AtomicReaderContext)leaves.get(idx);
                        if (idx != lastIdx) {
                            comparator = null;
                        }
                    }
                    if (comparator == null) {
                        comparator = sortField.getComparator(1, 0);
                        comparator = comparator.setNextReader(currentLeaf);
                    }
                    comparator.copy(0, doc -= currentLeaf.docBase);
                    Object val = comparator.value(0);
                    if (null != ft) {
                        val = ft.marshalSortValue(val);
                    }
                    vals[position] = val;
                }
                sortVals.add(sortField.getField(), (Object)vals);
            }
            rsp.add("sort_values", sortVals);
        }
    }

    protected void doPrefetch(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        if (!req.getParams().getBool("isShard", false) && rb.getResults().docList != null && rb.getResults().docList.size() <= 50) {
            SolrPluginUtils.optimizePreFetchDocs(rb, rb.getResults().docList, rb.getQuery(), req, rsp);
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (rb.grouping()) {
            return this.groupedDistributedProcess(rb);
        }
        return this.regularDistributedProcess(rb);
    }

    private int groupedDistributedProcess(ResponseBuilder rb) {
        int nextStage = ResponseBuilder.STAGE_DONE;
        ShardRequestFactory shardRequestFactory = null;
        if (rb.stage < ResponseBuilder.STAGE_PARSE_QUERY) {
            nextStage = ResponseBuilder.STAGE_PARSE_QUERY;
        } else if (rb.stage == ResponseBuilder.STAGE_PARSE_QUERY) {
            this.createDistributedIdf(rb);
            nextStage = ResponseBuilder.STAGE_TOP_GROUPS;
        } else if (rb.stage < ResponseBuilder.STAGE_TOP_GROUPS) {
            nextStage = ResponseBuilder.STAGE_TOP_GROUPS;
        } else if (rb.stage == ResponseBuilder.STAGE_TOP_GROUPS) {
            shardRequestFactory = new SearchGroupsRequestFactory();
            nextStage = ResponseBuilder.STAGE_EXECUTE_QUERY;
        } else if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            nextStage = ResponseBuilder.STAGE_EXECUTE_QUERY;
        } else if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            shardRequestFactory = new TopGroupsShardRequestFactory();
            nextStage = ResponseBuilder.STAGE_GET_FIELDS;
        } else if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            nextStage = ResponseBuilder.STAGE_GET_FIELDS;
        } else if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            shardRequestFactory = new StoredFieldsShardRequestFactory();
            nextStage = ResponseBuilder.STAGE_DONE;
        }
        if (shardRequestFactory != null) {
            for (ShardRequest shardRequest : shardRequestFactory.constructRequest(rb)) {
                rb.addRequest(this, shardRequest);
            }
        }
        return nextStage;
    }

    private int regularDistributedProcess(ResponseBuilder rb) {
        if (rb.stage < ResponseBuilder.STAGE_PARSE_QUERY) {
            return ResponseBuilder.STAGE_PARSE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_PARSE_QUERY) {
            this.createDistributedIdf(rb);
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            this.createMainQuery(rb);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage < ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            this.createRetrieveDocs(rb);
            return ResponseBuilder.STAGE_DONE;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (rb.grouping()) {
            this.handleGroupedResponses(rb, sreq);
        } else {
            this.handleRegularResponses(rb, sreq);
        }
    }

    private void handleGroupedResponses(ResponseBuilder rb, ShardRequest sreq) {
        ShardResponseProcessor responseProcessor = null;
        if ((sreq.purpose & 0x800) != 0) {
            responseProcessor = new SearchGroupShardResponseProcessor();
        } else if ((sreq.purpose & 4) != 0) {
            responseProcessor = new TopGroupsShardResponseProcessor();
        } else if ((sreq.purpose & 0x40) != 0) {
            responseProcessor = new StoredFieldsShardResponseProcessor();
        }
        if (responseProcessor != null) {
            responseProcessor.process(rb, sreq);
        }
    }

    private void handleRegularResponses(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 4) != 0) {
            this.mergeIds(rb, sreq);
        }
        if ((sreq.purpose & 0x40) != 0) {
            this.returnFields(rb, sreq);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        if (rb.grouping()) {
            this.groupedFinishStage(rb);
        } else {
            this.regularFinishStage(rb);
        }
    }

    private void groupedFinishStage(final ResponseBuilder rb) {
        EndResultTransformer endResultTransformer;
        GroupingSpecification groupSpec = rb.getGroupingSpec();
        if (rb.mergedTopGroups.isEmpty()) {
            for (String field : groupSpec.getFields()) {
                rb.mergedTopGroups.put(field, (TopGroups<BytesRef>)new TopGroups(null, null, 0, 0, new GroupDocs[0], Float.NaN));
            }
            rb.resultIds = new HashMap<Object, ShardDoc>();
        }
        EndResultTransformer.SolrDocumentSource solrDocumentSource = new EndResultTransformer.SolrDocumentSource(){

            @Override
            public SolrDocument retrieve(ScoreDoc doc) {
                ShardDoc solrDoc = (ShardDoc)doc;
                return rb.retrievedDocuments.get(solrDoc.id);
            }
        };
        if (groupSpec.isMain()) {
            endResultTransformer = MAIN_END_RESULT_TRANSFORMER;
        } else if (Grouping.Format.grouped == groupSpec.getResponseFormat()) {
            endResultTransformer = new GroupedEndResultTransformer(rb.req.getSearcher());
        } else if (Grouping.Format.simple == groupSpec.getResponseFormat() && !groupSpec.isMain()) {
            endResultTransformer = SIMPLE_END_RESULT_TRANSFORMER;
        } else {
            return;
        }
        LinkedHashMap<String, Object> combinedMap = new LinkedHashMap<String, Object>();
        combinedMap.putAll(rb.mergedTopGroups);
        combinedMap.putAll(rb.mergedQueryCommandResults);
        endResultTransformer.transform(combinedMap, rb, solrDocumentSource);
    }

    private void regularFinishStage(ResponseBuilder rb) {
        Iterator iter = rb._responseDocs.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            iter.remove();
            rb._responseDocs.setNumFound(rb._responseDocs.getNumFound() - 1L);
        }
        rb.rsp.add("response", rb._responseDocs);
        if (null != rb.getNextCursorMark()) {
            rb.rsp.add("nextCursorMark", rb.getNextCursorMark().getSerializedTotem());
        }
    }

    private void createDistributedIdf(ResponseBuilder rb) {
    }

    private void createMainQuery(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 4;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        if (rb.shards_start > -1) {
            sreq.params.set("start", rb.shards_start);
        } else {
            sreq.params.set("start", new String[]{"0"});
        }
        if (rb.shards_rows > -1) {
            sreq.params.set("rows", rb.shards_rows);
        } else {
            sreq.params.set("rows", rb.getSortSpec().getOffset() + rb.getSortSpec().getCount());
        }
        sreq.params.set("fsv", new String[]{"true"});
        if ((rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore()) {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName() + ",score"});
        } else {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName()});
        }
        rb.addRequest(this, sreq);
    }

    private void mergeIds(ResponseBuilder rb, ShardRequest sreq) {
        SortSpec ss = rb.getSortSpec();
        Sort sort = ss.getSort();
        SortField[] sortFields = null;
        sortFields = sort != null ? sort.getSort() : new SortField[]{SortField.FIELD_SCORE};
        IndexSchema schema = rb.req.getSchema();
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        HashMap<Object, String> uniqueDoc = new HashMap<Object, String>();
        ShardFieldSortedHitQueue queue = new ShardFieldSortedHitQueue(sortFields, ss.getOffset() + ss.getCount(), rb.req.getSearcher());
        SimpleOrderedMap shardInfo = null;
        if (rb.req.getParams().getBool("shards.info", false)) {
            shardInfo = new SimpleOrderedMap();
            rb.rsp.getValues().add("shards.info", (Object)shardInfo);
        }
        long numFound = 0L;
        Float maxScore = null;
        boolean partialResults = false;
        for (ShardResponse srsp : sreq.responses) {
            NamedList responseHeader;
            SolrDocumentList docs = null;
            if (shardInfo != null) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                if (srsp.getException() != null) {
                    Throwable t = srsp.getException();
                    if (t instanceof SolrServerException) {
                        t = ((SolrServerException)t).getCause();
                    }
                    nl.add("error", (Object)t.toString());
                    StringWriter trace = new StringWriter();
                    t.printStackTrace(new PrintWriter(trace));
                    nl.add("trace", (Object)trace.toString());
                    if (srsp.getShardAddress() != null) {
                        nl.add("shardAddress", (Object)srsp.getShardAddress());
                    }
                } else {
                    docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
                    nl.add("numFound", (Object)docs.getNumFound());
                    nl.add("maxScore", (Object)docs.getMaxScore());
                    nl.add("shardAddress", (Object)srsp.getShardAddress());
                }
                if (srsp.getSolrResponse() != null) {
                    nl.add("time", (Object)srsp.getSolrResponse().getElapsedTime());
                }
                shardInfo.add(srsp.getShard(), (Object)nl);
            }
            if (srsp.getException() != null) {
                partialResults = true;
                continue;
            }
            if (docs == null) {
                docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
            }
            if ((responseHeader = (NamedList)srsp.getSolrResponse().getResponse().get("responseHeader")) != null && Boolean.TRUE.equals(responseHeader.get("partialResults"))) {
                partialResults = true;
            }
            if (docs.getMaxScore() != null) {
                maxScore = Float.valueOf(maxScore == null ? docs.getMaxScore().floatValue() : Math.max(maxScore.floatValue(), docs.getMaxScore().floatValue()));
            }
            numFound += docs.getNumFound();
            NamedList sortFieldValues = (NamedList)srsp.getSolrResponse().getResponse().get("sort_values");
            for (int i = 0; i < docs.size(); ++i) {
                SolrDocument doc = (SolrDocument)docs.get(i);
                Object id = doc.getFieldValue(uniqueKeyField.getName());
                String prevShard = uniqueDoc.put(id, srsp.getShard());
                if (prevShard != null) {
                    --numFound;
                    continue;
                }
                ShardDoc shardDoc = new ShardDoc();
                shardDoc.id = id;
                shardDoc.shard = srsp.getShard();
                shardDoc.orderInShard = i;
                Object scoreObj = doc.getFieldValue("score");
                if (scoreObj != null) {
                    shardDoc.score = scoreObj instanceof String ? Float.valueOf(Float.parseFloat((String)scoreObj)) : (Float)scoreObj;
                }
                shardDoc.sortFieldValues = this.unmarshalSortValues(ss, sortFieldValues, schema);
                queue.insertWithOverflow((Object)shardDoc);
            }
        }
        int resultSize = queue.size() - ss.getOffset();
        resultSize = Math.max(0, resultSize);
        HashMap<Object, ShardDoc> resultIds = new HashMap<Object, ShardDoc>();
        int i = resultSize - 1;
        while (i >= 0) {
            ShardDoc shardDoc = (ShardDoc)((Object)queue.pop());
            shardDoc.positionInResponse = i--;
            resultIds.put(shardDoc.id.toString(), shardDoc);
        }
        rb.rsp.addToLog("hits", numFound);
        SolrDocumentList responseDocs = new SolrDocumentList();
        if (maxScore != null) {
            responseDocs.setMaxScore(maxScore);
        }
        responseDocs.setNumFound(numFound);
        responseDocs.setStart((long)ss.getOffset());
        for (int i2 = 0; i2 < resultSize; ++i2) {
            responseDocs.add(null);
        }
        rb.resultIds = resultIds;
        rb._responseDocs = responseDocs;
        this.populateNextCursorMarkFromMergedShards(rb);
        if (partialResults) {
            rb.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
        }
    }

    private void populateNextCursorMarkFromMergedShards(ResponseBuilder rb) {
        CursorMark lastCursorMark = rb.getCursorMark();
        if (null == lastCursorMark) {
            return;
        }
        assert (null != rb.resultIds) : "resultIds was not set in ResponseBuilder";
        Collection<ShardDoc> docsOnThisPage = rb.resultIds.values();
        if (0 == docsOnThisPage.size()) {
            rb.setNextCursorMark(lastCursorMark);
            return;
        }
        ShardDoc lastDoc = null;
        for (ShardDoc eachDoc : docsOnThisPage) {
            if (null != lastDoc && lastDoc.positionInResponse >= eachDoc.positionInResponse) continue;
            lastDoc = eachDoc;
        }
        SortField[] sortFields = lastCursorMark.getSortSpec().getSort().getSort();
        ArrayList<Object> nextCursorMarkValues = new ArrayList<Object>(sortFields.length);
        for (SortField sf : sortFields) {
            if (sf.getType().equals((Object)SortField.Type.SCORE)) {
                assert (null != lastDoc.score) : "lastDoc has null score";
                nextCursorMarkValues.add(lastDoc.score);
                continue;
            }
            assert (null != sf.getField()) : "SortField has null field";
            List fieldVals = (List)lastDoc.sortFieldValues.get(sf.getField());
            nextCursorMarkValues.add(fieldVals.get(lastDoc.orderInShard));
        }
        CursorMark nextCursorMark = lastCursorMark.createNext(nextCursorMarkValues);
        assert (null != nextCursorMark) : "null nextCursorMark";
        rb.setNextCursorMark(nextCursorMark);
    }

    private NamedList unmarshalSortValues(SortSpec sortSpec, NamedList sortFieldValues, IndexSchema schema) {
        NamedList unmarshalledSortValsPerField = new NamedList();
        if (0 == sortFieldValues.size()) {
            return unmarshalledSortValsPerField;
        }
        List<SchemaField> schemaFields = sortSpec.getSchemaFields();
        SortField[] sortFields = sortSpec.getSort().getSort();
        int marshalledFieldNum = 0;
        for (int sortFieldNum = 0; sortFieldNum < sortFields.length; ++sortFieldNum) {
            SortField sortField = sortFields[sortFieldNum];
            SortField.Type type = sortField.getType();
            if (type == SortField.Type.SCORE || type == SortField.Type.DOC) continue;
            String sortFieldName = sortField.getField();
            String valueFieldName = sortFieldValues.getName(marshalledFieldNum);
            assert (sortFieldName.equals(valueFieldName)) : "sortFieldValues name key does not match expected SortField.getField";
            List sortVals = (List)sortFieldValues.getVal(marshalledFieldNum);
            SchemaField schemaField = schemaFields.get(sortFieldNum);
            if (null == schemaField) {
                unmarshalledSortValsPerField.add(sortField.getField(), (Object)sortVals);
            } else {
                FieldType fieldType = schemaField.getType();
                ArrayList<Object> unmarshalledSortVals = new ArrayList<Object>();
                for (Object sortVal : sortVals) {
                    unmarshalledSortVals.add(fieldType.unmarshalSortValue(sortVal));
                }
                unmarshalledSortValsPerField.add(sortField.getField(), unmarshalledSortVals);
            }
            ++marshalledFieldNum;
        }
        return unmarshalledSortValsPerField;
    }

    private void createRetrieveDocs(ResponseBuilder rb) {
        HashMap shardMap = new HashMap();
        for (ShardDoc sdoc : rb.resultIds.values()) {
            Collection shardDocs = (ArrayList<ShardDoc>)shardMap.get(sdoc.shard);
            if (shardDocs == null) {
                shardDocs = new ArrayList<ShardDoc>();
                shardMap.put(sdoc.shard, shardDocs);
            }
            shardDocs.add(sdoc);
        }
        SchemaField uniqueField = rb.req.getSchema().getUniqueKeyField();
        for (Collection shardDocs : shardMap.values()) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 64;
            sreq.shards = new String[]{((ShardDoc)((Object)shardDocs.iterator().next())).shard};
            sreq.params = new ModifiableSolrParams();
            sreq.params.add(rb.req.getParams());
            sreq.params.remove("sort");
            sreq.params.remove("cursorMark");
            sreq.params.remove("fsv");
            if (!rb.rsp.getReturnFields().wantsField(uniqueField.getName())) {
                sreq.params.add("fl", new String[]{uniqueField.getName()});
            }
            ArrayList<String> ids = new ArrayList<String>(shardDocs.size());
            for (ShardDoc shardDoc : shardDocs) {
                ids.add(shardDoc.id.toString());
            }
            sreq.params.add("ids", new String[]{StrUtils.join(ids, (char)',')});
            rb.addRequest(this, sreq);
        }
    }

    private void returnFields(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 0x40) != 0) {
            boolean returnScores;
            boolean bl = returnScores = (rb.getFieldFlags() & 1) != 0;
            assert (sreq.responses.size() == 1);
            ShardResponse srsp = sreq.responses.get(0);
            SolrDocumentList docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
            String keyFieldName = rb.req.getSchema().getUniqueKeyField().getName();
            boolean removeKeyField = !rb.rsp.getReturnFields().wantsField(keyFieldName);
            for (SolrDocument doc : docs) {
                Object id = doc.getFieldValue(keyFieldName);
                ShardDoc sdoc = rb.resultIds.get(id.toString());
                if (sdoc == null) continue;
                if (returnScores && sdoc.score != null) {
                    doc.setField("score", (Object)sdoc.score);
                }
                if (removeKeyField) {
                    doc.removeFields(keyFieldName);
                }
                rb._responseDocs.set(sdoc.positionInResponse, (Object)doc);
            }
        }
    }

    @Override
    public String getDescription() {
        return COMPONENT_NAME;
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/handler/component/QueryComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

