/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.store.blockcache.BlockCache;
import org.apache.solr.store.blockcache.BlockDirectory;
import org.apache.solr.store.blockcache.BlockDirectoryCache;
import org.apache.solr.store.blockcache.BufferStore;
import org.apache.solr.store.blockcache.Metrics;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.apache.solr.util.HdfsUtil;
import org.apache.solr.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsDirectoryFactory
extends CachingDirectoryFactory {
    public static Logger LOG = LoggerFactory.getLogger(HdfsDirectoryFactory.class);
    public static final String BLOCKCACHE_SLAB_COUNT = "solr.hdfs.blockcache.slab.count";
    public static final String BLOCKCACHE_DIRECT_MEMORY_ALLOCATION = "solr.hdfs.blockcache.direct.memory.allocation";
    public static final String BLOCKCACHE_ENABLED = "solr.hdfs.blockcache.enabled";
    public static final String BLOCKCACHE_READ_ENABLED = "solr.hdfs.blockcache.read.enabled";
    public static final String BLOCKCACHE_WRITE_ENABLED = "solr.hdfs.blockcache.write.enabled";
    public static final String NRTCACHINGDIRECTORY_ENABLE = "solr.hdfs.nrtcachingdirectory.enable";
    public static final String NRTCACHINGDIRECTORY_MAXMERGESIZEMB = "solr.hdfs.nrtcachingdirectory.maxmergesizemb";
    public static final String NRTCACHINGDIRECTORY_MAXCACHEMB = "solr.hdfs.nrtcachingdirectory.maxcachedmb";
    public static final String NUMBEROFBLOCKSPERBANK = "solr.hdfs.blockcache.blocksperbank";
    public static final String KERBEROS_ENABLED = "solr.hdfs.security.kerberos.enabled";
    public static final String KERBEROS_KEYTAB = "solr.hdfs.security.kerberos.keytabfile";
    public static final String KERBEROS_PRINCIPAL = "solr.hdfs.security.kerberos.principal";
    public static final String HDFS_HOME = "solr.hdfs.home";
    public static final String CONFIG_DIRECTORY = "solr.hdfs.confdir";
    private SolrParams params;
    private String hdfsDataDir;
    private String confDir;
    public static Metrics metrics;
    private static Boolean kerberosInit;

    @Override
    public void init(NamedList args) {
        this.params = SolrParams.toSolrParams((NamedList)args);
        this.hdfsDataDir = this.params.get(HDFS_HOME);
        if (this.hdfsDataDir != null && this.hdfsDataDir.length() == 0) {
            this.hdfsDataDir = null;
        }
        boolean kerberosEnabled = this.params.getBool(KERBEROS_ENABLED, false);
        LOG.info("Solr Kerberos Authentication " + (kerberosEnabled ? "enabled" : "disabled"));
        if (kerberosEnabled) {
            this.initKerberos();
        }
    }

    @Override
    protected Directory create(String path, DirectoryFactory.DirContext dirContext) throws IOException {
        LOG.info("creating directory factory for path {}", (Object)path);
        Configuration conf = this.getConf();
        if (metrics == null) {
            metrics = new Metrics(conf);
        }
        boolean blockCacheEnabled = this.params.getBool(BLOCKCACHE_ENABLED, true);
        boolean blockCacheReadEnabled = this.params.getBool(BLOCKCACHE_READ_ENABLED, true);
        boolean blockCacheWriteEnabled = this.params.getBool(BLOCKCACHE_WRITE_ENABLED, true);
        Object dir = null;
        if (blockCacheEnabled && dirContext != DirectoryFactory.DirContext.META_DATA) {
            BlockCache blockCache;
            int numberOfBlocksPerBank = this.params.getInt(NUMBEROFBLOCKSPERBANK, 16384);
            int blockSize = 8192;
            int bankCount = this.params.getInt(BLOCKCACHE_SLAB_COUNT, 1);
            boolean directAllocation = this.params.getBool(BLOCKCACHE_DIRECT_MEMORY_ALLOCATION, true);
            int slabSize = numberOfBlocksPerBank * blockSize;
            LOG.info("Number of slabs of block cache [{}] with direct memory allocation set to [{}]", (Object)bankCount, (Object)directAllocation);
            LOG.info("Block cache target memory usage, slab size of [{}] will allocate [{}] slabs and use ~[{}] bytes", new Object[]{slabSize, bankCount, (long)bankCount * (long)slabSize});
            int bufferSize = this.params.getInt("solr.hdfs.blockcache.bufferstore.buffersize", 128);
            int bufferCount = this.params.getInt("solr.hdfs.blockcache.bufferstore.buffercount", 16384);
            BufferStore.initNewBuffer(bufferSize, bufferCount);
            long totalMemory = (long)bankCount * (long)numberOfBlocksPerBank * (long)blockSize;
            try {
                blockCache = new BlockCache(metrics, directAllocation, totalMemory, slabSize, blockSize);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("The max direct memory is likely too low.  Either increase it (by adding -XX:MaxDirectMemorySize=<size>g -XX:+UseLargePages to your containers startup args) or disable direct allocation using solr.hdfs.blockcache.direct.memory.allocation=false in solrconfig.xml. If you are putting the block cache on the heap, your java heap size might not be large enough. Failed allocating ~" + (double)totalMemory / 1000000.0 + " MB.", e);
            }
            BlockDirectoryCache cache = new BlockDirectoryCache(blockCache, metrics);
            HdfsDirectory hdfsDirectory = new HdfsDirectory(new Path(path), conf);
            dir = new BlockDirectory("solrcore", (Directory)hdfsDirectory, cache, null, blockCacheReadEnabled, blockCacheWriteEnabled);
        } else {
            dir = new HdfsDirectory(new Path(path), conf);
        }
        boolean nrtCachingDirectory = this.params.getBool(NRTCACHINGDIRECTORY_ENABLE, true);
        if (nrtCachingDirectory) {
            double nrtCacheMaxMergeSizeMB = this.params.getInt(NRTCACHINGDIRECTORY_MAXMERGESIZEMB, 16);
            double nrtCacheMaxCacheMB = this.params.getInt(NRTCACHINGDIRECTORY_MAXCACHEMB, 192);
            return new NRTCachingDirectory((Directory)dir, nrtCacheMaxMergeSizeMB, nrtCacheMaxCacheMB);
        }
        return dir;
    }

    @Override
    public boolean exists(String path) {
        boolean bl;
        Path hdfsDirPath = new Path(path);
        Configuration conf = this.getConf();
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystem.newInstance((URI)hdfsDirPath.toUri(), (Configuration)conf);
            bl = fileSystem.exists(hdfsDirPath);
        }
        catch (IOException e) {
            try {
                LOG.error("Error checking if hdfs path exists", (Throwable)e);
                throw new RuntimeException("Error checking if hdfs path exists", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileSystem);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileSystem);
        return bl;
    }

    private Configuration getConf() {
        Configuration conf = new Configuration();
        this.confDir = this.params.get(CONFIG_DIRECTORY, null);
        HdfsUtil.addHdfsResources(conf, this.confDir);
        return conf;
    }

    @Override
    protected synchronized void removeDirectory(CachingDirectoryFactory.CacheValue cacheValue) throws IOException {
        Configuration conf = this.getConf();
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystem.newInstance((URI)new URI(cacheValue.path), (Configuration)conf);
            boolean success = fileSystem.delete(new Path(cacheValue.path), true);
            if (!success) {
                throw new RuntimeException("Could not remove directory");
            }
        }
        catch (Exception e) {
            try {
                LOG.error("Could not remove directory", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not remove directory", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileSystem);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileSystem);
    }

    @Override
    public boolean isAbsolute(String path) {
        return path.startsWith("hdfs:/");
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean searchersReserveCommitPoints() {
        return true;
    }

    @Override
    public String getDataHome(CoreDescriptor cd) throws IOException {
        if (this.hdfsDataDir == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "You must set the " + this.getClass().getSimpleName() + " param " + HDFS_HOME + " for relative dataDir paths to work");
        }
        String path = cd.getCloudDescriptor() != null ? URLEncoder.encode(cd.getCloudDescriptor().getCollectionName(), "UTF-8") + "/" + URLEncoder.encode(cd.getCloudDescriptor().getCoreNodeName(), "UTF-8") : cd.getName();
        return this.normalize(SolrResourceLoader.normalizeDir(ZkController.trimLeadingAndTrailingSlashes(this.hdfsDataDir) + "/" + path + "/" + cd.getDataDir()));
    }

    public String getConfDir() {
        return this.confDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKerberos() {
        String keytabFile = this.params.get(KERBEROS_KEYTAB, "").trim();
        if (keytabFile.length() == 0) {
            throw new IllegalArgumentException("solr.hdfs.security.kerberos.keytabfile required because solr.hdfs.security.kerberos.enabled set to true");
        }
        String principal = this.params.get(KERBEROS_PRINCIPAL, "");
        if (principal.length() == 0) {
            throw new IllegalArgumentException("solr.hdfs.security.kerberos.principal required because solr.hdfs.security.kerberos.enabled set to true");
        }
        Class<HdfsDirectoryFactory> clazz = HdfsDirectoryFactory.class;
        synchronized (HdfsDirectoryFactory.class) {
            if (kerberosInit == null) {
                kerberosInit = new Boolean(true);
                Configuration conf = new Configuration();
                conf.set("hadoop.security.authentication", "kerberos");
                UserGroupInformation.setConfiguration((Configuration)conf);
                LOG.info("Attempting to acquire kerberos ticket with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                LOG.info("Got Kerberos ticket");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

