/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSolrXml
extends ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolrXml.class);
    private final CoresLocator coresLocator;

    public ConfigSolrXml(Config config) {
        super(config);
        try {
            this.checkForIllegalConfig();
            this.fillPropMap();
            config.substituteProperties();
            this.coresLocator = new CorePropertiesLocator(this.getCoreRootDirectory());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForIllegalConfig() throws IOException {
        this.failIfFound("solr/@coreLoadThreads");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/@sharedLib");
        this.failIfFound("solr/@zkHost");
        this.failIfFound("solr/logging/@class");
        this.failIfFound("solr/logging/@enabled");
        this.failIfFound("solr/logging/watcher/@size");
        this.failIfFound("solr/logging/watcher/@threshold");
        this.failIfFound("solr/cores/@adminHandler");
        this.failIfFound("solr/cores/@distribUpdateConnTimeout");
        this.failIfFound("solr/cores/@distribUpdateSoTimeout");
        this.failIfFound("solr/cores/@host");
        this.failIfFound("solr/cores/@hostContext");
        this.failIfFound("solr/cores/@hostPort");
        this.failIfFound("solr/cores/@leaderVoteWait");
        this.failIfFound("solr/cores/@genericCoreNodeNames");
        this.failIfFound("solr/cores/@managementPath");
        this.failIfFound("solr/cores/@shareSchema");
        this.failIfFound("solr/cores/@transientCacheSize");
        this.failIfFound("solr/cores/@zkClientTimeout");
        this.failIfFound("solr/cores/@defaultCoreName");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/cores/@adminPath");
    }

    private void failIfFound(String xPath) {
        if (this.config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    private String doSub(String path) {
        String val = this.config.getVal(path, false);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val;
    }

    private void fillPropMap() {
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, this.doSub("solr/str[@name='adminHandler']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_COLLECTIONSHANDLER, this.doSub("solr/str[@name='collectionsHandler']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_INFOHANDLER, this.doSub("solr/str[@name='infoHandler']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, this.doSub("solr/int[@name='coreLoadThreads']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, this.doSub("solr/str[@name='coreRootDirectory']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateConnTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateSoTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONS, this.doSub("solr/solrcloud/int[@name='maxUpdateConnections']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONSPERHOST, this.doSub("solr/solrcloud/int[@name='maxUpdateConnectionsPerHost']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOST, this.doSub("solr/solrcloud/str[@name='host']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, this.doSub("solr/solrcloud/str[@name='hostContext']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTPORT, this.doSub("solr/solrcloud/int[@name='hostPort']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, this.doSub("solr/solrcloud/int[@name='leaderVoteWait']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, this.doSub("solr/solrcloud/bool[@name='genericCoreNodeNames']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, this.doSub("solr/str[@name='managementPath']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHAREDLIB, this.doSub("solr/str[@name='sharedLib']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, this.doSub("solr/str[@name='shareSchema']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, this.doSub("solr/int[@name='transientCacheSize']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, this.doSub("solr/solrcloud/int[@name='zkClientTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKHOST, this.doSub("solr/solrcloud/str[@name='zkHost']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, this.doSub("solr/logging/str[@name='class']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, this.doSub("solr/logging/str[@name='enabled']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, this.doSub("solr/logging/watcher/int[@name='size']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, this.doSub("solr/logging/watcher/int[@name='threshold']"));
    }

    @Override
    public String getDefaultCoreName() {
        return "collection1";
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected String getShardHandlerFactoryConfigPath() {
        return "solr/shardHandlerFactory";
    }

    @Override
    public String getAdminPath() {
        return "/admin/cores";
    }

    @Override
    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }
}

