/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.ShardLeaderElectionContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZkController {
    private static Logger log = LoggerFactory.getLogger(ZkController.class);
    static final String NEWL = System.getProperty("line.separator");
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final DistributedQueue overseerJobQueue;
    private final DistributedQueue overseerCollectionQueue;
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String COLLECTION_PARAM_PREFIX = "collection.";
    public static final String CONFIGNAME_PROP = "configName";
    private final Map<ContextKey, ElectionContext> electionContexts = Collections.synchronizedMap(new HashMap());
    private final SolrZkClient zkClient;
    private final ZkCmdExecutor cmdExecutor;
    private final ZkStateReader zkStateReader;
    private final LeaderElector leaderElector;
    private final String zkServerAddress;
    private final String localHostPort;
    private final String localHostContext;
    private final String hostName;
    private final String nodeName;
    private final String baseURL;
    private LeaderElector overseerElector;
    private CoreContainer cc;
    protected volatile Overseer overseer;
    private int leaderVoteWait;
    private boolean genericCoreNodeNames;
    private int clientTimeout;
    private volatile boolean isClosed;

    public ZkController(final CoreContainer cc, String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, String localHost, String locaHostPort, String localHostContext, int leaderVoteWait, boolean genericCoreNodeNames, final CurrentCoreDescriptorProvider registerOnReconnect) throws InterruptedException, TimeoutException, IOException {
        if (cc == null) {
            throw new IllegalArgumentException("CoreContainer cannot be null.");
        }
        this.cc = cc;
        this.genericCoreNodeNames = genericCoreNodeNames;
        localHostContext = ZkController.trimLeadingAndTrailingSlashes(localHostContext);
        this.zkServerAddress = zkServerAddress;
        this.localHostPort = locaHostPort;
        this.localHostContext = localHostContext;
        this.hostName = this.normalizeHostName(localHost);
        this.nodeName = ZkController.generateNodeName(this.hostName, this.localHostPort, this.localHostContext);
        this.leaderVoteWait = leaderVoteWait;
        this.clientTimeout = zkClientTimeout;
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, (ZkClientConnectionStrategy)new DefaultConnectionStrategy(), new OnReconnect(){

            public void command() {
                try {
                    cc.cancelCoreRecoveries();
                    ZkController.this.registerAllCoresAsDown(registerOnReconnect, false);
                    OverseerElectionContext context = new OverseerElectionContext(ZkController.this.zkClient, ZkController.this.overseer, ZkController.this.getNodeName());
                    ElectionContext prevContext = ZkController.this.overseerElector.getContext();
                    if (prevContext != null) {
                        prevContext.cancelElection();
                    }
                    ZkController.this.overseerElector.setup(context);
                    ZkController.this.overseerElector.joinElection(context, true);
                    ZkController.this.zkStateReader.createClusterStateWatchersAndUpdate();
                    ZkController.this.createEphemeralLiveNode();
                    List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
                    if (descriptors != null) {
                        for (CoreDescriptor descriptor : descriptors) {
                            try {
                                ZkController.this.register(descriptor.getName(), descriptor, true, true);
                            }
                            catch (Exception e) {
                                SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)e);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
        }, new BeforeReconnect(){

            public void command() {
                try {
                    ZkController.this.overseer.close();
                }
                catch (Exception e) {
                    log.error("Error trying to stop any Overseer threads", (Throwable)e);
                }
                ZkController.this.markAllAsNotLeader(registerOnReconnect);
            }
        });
        this.overseerJobQueue = Overseer.getInQueue(this.zkClient);
        this.overseerCollectionQueue = Overseer.getCollectionQueue(this.zkClient);
        this.cmdExecutor = new ZkCmdExecutor(zkClientTimeout);
        this.leaderElector = new LeaderElector(this.zkClient);
        this.zkStateReader = new ZkStateReader(this.zkClient);
        this.baseURL = this.zkStateReader.getBaseUrlForNodeName(this.nodeName);
        this.init(registerOnReconnect);
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public void forceOverSeer() {
        try {
            this.zkClient.delete("/overseer_elect/leader", -1, true);
            log.info("Forcing me to be leader  {} ", (Object)this.getBaseUrl());
            this.overseerElector.getContext().runLeaderProcess(true, 1600);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, " Error becoming overseer ", (Throwable)e);
        }
    }

    private void registerAllCoresAsDown(CurrentCoreDescriptorProvider registerOnReconnect, boolean updateLastPublished) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (this.isClosed) {
            return;
        }
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                try {
                    descriptor.getCloudDescriptor().setLeader(false);
                    this.publish(descriptor, "down", updateLastPublished);
                }
                catch (Exception e) {
                    if (this.isClosed) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        this.publish(descriptor, "down");
                    }
                    catch (Exception e2) {
                        SolrException.log((Logger)log, (String)"", (Throwable)e2);
                    }
                }
            }
            for (CoreDescriptor descriptor : descriptors) {
                CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
                String collection = cloudDesc.getCollectionName();
                String slice = cloudDesc.getShardId();
                try {
                    int children = this.zkStateReader.getZkClient().getChildren("/collections/" + collection + "/leader_elect/" + slice + "/election", null, true).size();
                    if (children == 0) {
                        log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                        continue;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    log.warn("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                String coreZkNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
                try {
                    log.debug("calling waitForLeaderToSeeDownState for coreZkNodeName={} collection={} shard={}", new Object[]{coreZkNodeName, collection, slice});
                    this.waitForLeaderToSeeDownState(descriptor, coreZkNodeName);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                    if (this.isClosed) {
                        return;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private void markAllAsNotLeader(CurrentCoreDescriptorProvider registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                descriptor.getCloudDescriptor().setLeader(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        try {
            for (ElectionContext context : this.electionContexts.values()) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    log.error("Error closing overseer", (Throwable)e);
                }
            }
        }
        finally {
            try {
                try {
                    this.overseer.close();
                }
                catch (Exception e) {
                    log.error("Error closing overseer", (Throwable)e);
                }
            }
            finally {
                try {
                    try {
                        this.zkStateReader.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkStateReader", (Throwable)e);
                    }
                }
                finally {
                    try {
                        this.zkClient.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkClient", (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean configFileExists(String collection, String fileName) throws KeeperException, InterruptedException {
        Stat stat = this.zkClient.exists("/configs/" + collection + "/" + fileName, null, true);
        return stat != null;
    }

    public ClusterState getClusterState() {
        return this.zkStateReader.getClusterState();
    }

    public byte[] getConfigFileData(String zkConfigName, String fileName) throws KeeperException, InterruptedException {
        String zkPath = "/configs/" + zkConfigName + "/" + fileName;
        byte[] bytes = this.zkClient.getData(zkPath, null, null, true);
        if (bytes == null) {
            log.error("Config file contains no data:" + zkPath);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Config file contains no data:" + zkPath);
        }
        return bytes;
    }

    private String normalizeHostName(String host) throws IOException {
        if (host == null || host.length() == 0) {
            String hostaddress;
            try {
                hostaddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostaddress = "127.0.0.1";
            }
            if ("127.0.0.1".equals(hostaddress)) {
                Enumeration<NetworkInterface> netInterfaces = null;
                try {
                    netInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (netInterfaces.hasMoreElements()) {
                        NetworkInterface ni = netInterfaces.nextElement();
                        Enumeration<InetAddress> ips = ni.getInetAddresses();
                        while (ips.hasMoreElements()) {
                            InetAddress ip = ips.nextElement();
                            if (!ip.isSiteLocalAddress()) continue;
                            hostaddress = ip.getHostAddress();
                        }
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Error while looking for a better host name than 127.0.0.1", (Throwable)e);
                }
            }
            host = hostaddress;
        } else if (URLUtil.hasScheme((String)host)) {
            host = URLUtil.removeScheme((String)host);
        }
        return host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostPort() {
        return this.localHostPort;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    private void init(CurrentCoreDescriptorProvider registerOnReconnect) {
        try {
            boolean createdWatchesAndUpdated = false;
            if (this.zkClient.exists("/live_nodes", true).booleanValue()) {
                this.zkStateReader.createClusterStateWatchersAndUpdate();
                createdWatchesAndUpdated = true;
                this.publishAndWaitForDownStates();
            }
            this.cmdExecutor.ensureExists("/live_nodes", this.zkClient);
            this.createEphemeralLiveNode();
            this.cmdExecutor.ensureExists("/collections", this.zkClient);
            ShardHandler shardHandler = this.cc.getShardHandlerFactory().getShardHandler();
            String adminPath = this.cc.getAdminPath();
            this.overseerElector = new LeaderElector(this.zkClient);
            this.overseer = new Overseer(shardHandler, adminPath, this.zkStateReader);
            OverseerElectionContext context = new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName());
            this.overseerElector.setup(context);
            this.overseerElector.joinElection(context, false);
            if (!createdWatchesAndUpdated) {
                this.zkStateReader.createClusterStateWatchersAndUpdate();
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't create ZooKeeperController", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    public void publishAndWaitForDownStates() throws KeeperException, InterruptedException {
        ClusterState clusterState = this.zkStateReader.getClusterState();
        Set collections = clusterState.getCollections();
        ArrayList<String> updatedNodes = new ArrayList<String>();
        for (String collectionName : collections) {
            DocCollection collection = clusterState.getCollection(collectionName);
            Collection slices = collection.getSlices();
            for (Slice slice : slices) {
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    if (!replica.getNodeName().equals(this.getNodeName()) || replica.getStr("state").equals("down")) continue;
                    ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "state", "state", "down", "base_url", this.getBaseUrl(), "core", replica.getStr("core"), "roles", replica.getStr("roles"), "node_name", this.getNodeName(), "shard", replica.getStr("shard"), "collection", collectionName, "core_node_name", replica.getName()});
                    updatedNodes.add(replica.getStr("core"));
                    this.overseerJobQueue.offer(ZkStateReader.toJSON((Object)m));
                }
            }
        }
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean foundStates = false;
        while (System.currentTimeMillis() < timeout) {
            clusterState = this.zkStateReader.getClusterState();
            collections = clusterState.getCollections();
            for (String collectionName : collections) {
                DocCollection collection = clusterState.getCollection(collectionName);
                Collection slices = collection.getSlices();
                for (Slice slice : slices) {
                    Collection replicas = slice.getReplicas();
                    for (Replica replica : replicas) {
                        if (!replica.getStr("state").equals("down")) continue;
                        updatedNodes.remove(replica.getStr("core"));
                    }
                }
            }
            if (updatedNodes.size() == 0) {
                foundStates = true;
                Thread.sleep(1000L);
                break;
            }
            Thread.sleep(1000L);
        }
        if (!foundStates) {
            log.warn("Timed out waiting to see all nodes published as DOWN in our cluster state.");
        }
    }

    public static boolean checkChrootPath(String zkHost, boolean create) throws KeeperException, InterruptedException {
        if (!ZkController.containsChroot(zkHost)) {
            return true;
        }
        log.info("zkHost includes chroot");
        String chrootPath = zkHost.substring(zkHost.indexOf("/"), zkHost.length());
        SolrZkClient tmpClient = new SolrZkClient(zkHost.substring(0, zkHost.indexOf("/")), 60000);
        boolean exists = tmpClient.exists(chrootPath, true);
        if (!exists && create) {
            tmpClient.makePath(chrootPath, false, true);
            exists = true;
        }
        tmpClient.close();
        return exists;
    }

    private static boolean containsChroot(String zkHost) {
        return zkHost.contains("/");
    }

    public boolean isConnected() {
        return this.zkClient.isConnected();
    }

    private void createEphemeralLiveNode() throws KeeperException, InterruptedException {
        block5: {
            String nodeName = this.getNodeName();
            String nodePath = "/live_nodes/" + nodeName;
            log.info("Register node as live in ZooKeeper:" + nodePath);
            try {
                boolean nodeDeleted = true;
                try {
                    this.zkClient.delete(nodePath, -1, true);
                }
                catch (KeeperException.NoNodeException e) {
                    nodeDeleted = false;
                }
                if (nodeDeleted) {
                    log.info("Found a previous node that still exists while trying to register a new live node " + nodePath + " - removing existing node to create another.");
                }
                this.zkClient.makePath(nodePath, CreateMode.EPHEMERAL, true);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block5;
                throw e;
            }
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean pathExists(String path) throws KeeperException, InterruptedException {
        return this.zkClient.exists(path, true);
    }

    public String register(String coreName, CoreDescriptor desc) throws Exception {
        return this.register(coreName, desc, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String register(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean afterExpiration) throws Exception {
        String baseUrl = this.getBaseUrl();
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String coreZkNodeName = desc.getCloudDescriptor().getCoreNodeName();
        assert (coreZkNodeName != null) : "we should have a coreNodeName by now";
        String shardId = cloudDesc.getShardId();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("base_url", baseUrl);
        props.put("core", coreName);
        props.put("node_name", this.getNodeName());
        if (log.isInfoEnabled()) {
            log.info("Register replica - core:" + coreName + " address:" + baseUrl + " collection:" + cloudDesc.getCollectionName() + " shard:" + shardId);
        }
        ZkNodeProps leaderProps = new ZkNodeProps(props);
        try {
            this.joinElection(desc, afterExpiration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (IOException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        String leaderUrl = this.getLeader(cloudDesc, this.leaderVoteWait + 600000);
        String ourUrl = ZkCoreNodeProps.getCoreUrl((String)baseUrl, (String)coreName);
        log.info("We are " + ourUrl + " and leader is " + leaderUrl);
        boolean isLeader = leaderUrl.equals(ourUrl);
        SolrCore core = null;
        try {
            core = this.cc.getCore(desc.getName());
            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
            if (!core.isReloaded() && ulog != null) {
                boolean didRecovery;
                Slice slice = this.getClusterState().getSlice(collection, shardId);
                if (!Slice.CONSTRUCTION.equals(slice.getState()) || !isLeader) {
                    Future<UpdateLog.RecoveryInfo> recoveryFuture = core.getUpdateHandler().getUpdateLog().recoverFromLog();
                    if (recoveryFuture != null) {
                        recoveryFuture.get();
                    } else {
                        log.info("No LogReplay needed for core=" + core.getName() + " baseURL=" + baseUrl);
                    }
                }
                if (!(didRecovery = this.checkRecovery(coreName, desc, recoverReloadedCores, isLeader, cloudDesc, collection, coreZkNodeName, shardId, leaderProps, core, this.cc))) {
                    this.publish(desc, "active");
                }
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
        this.zkStateReader.updateClusterState(true);
        return shardId;
    }

    private String getLeader(CloudDescriptor cloudDesc, int timeoutms) {
        String leaderUrl;
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            String clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms * 2);
            int tries = 0;
            while (!leaderUrl.equals(clusterStateLeaderUrl)) {
                if (tries == 60) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There is conflicting information about the leader of shard: " + cloudDesc.getShardId() + " our state says:" + clusterStateLeaderUrl + " but zookeeper says:" + leaderUrl);
                }
                Thread.sleep(1000L);
                ++tries;
                clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms);
                leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            }
        }
        catch (Exception e) {
            log.error("Error getting leader from zk", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting leader from zk for shard " + shardId, (Throwable)e);
        }
        return leaderUrl;
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms) throws InterruptedException {
        return this.getLeaderProps(collection, slice, timeoutms, false);
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms, boolean failImmediatelyOnExpiration) throws InterruptedException {
        int iterCount = timeoutms / 1000;
        Throwable exp = null;
        while (iterCount-- > 0) {
            try {
                byte[] data = this.zkClient.getData(ZkStateReader.getShardLeadersPath((String)collection, (String)slice), null, null, true);
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(ZkNodeProps.load((byte[])data));
                return leaderProps;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (KeeperException.SessionExpiredException e) {
                if (failImmediatelyOnExpiration) {
                    throw new RuntimeException("Session has expired - could not get leader props", exp);
                }
                exp = e;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                exp = e;
                Thread.sleep(1000L);
            }
            if (!this.cc.isShutDown()) continue;
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "CoreContainer is shutdown");
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Could not get leader props", exp);
    }

    private void joinElection(CoreDescriptor cd, boolean afterExpiration) throws InterruptedException, KeeperException, IOException {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.cancelElection();
        }
        String shardId = cd.getCloudDescriptor().getShardId();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("base_url", this.getBaseUrl());
        props.put("core", cd.getName());
        props.put("node_name", this.getNodeName());
        ZkNodeProps ourProps = new ZkNodeProps(props);
        ShardLeaderElectionContext context = new ShardLeaderElectionContext(this.leaderElector, shardId, collection, coreNodeName, ourProps, this, this.cc);
        this.leaderElector.setup(context);
        this.electionContexts.put(contextKey, context);
        this.leaderElector.joinElection(context, false);
    }

    private boolean checkRecovery(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean isLeader, CloudDescriptor cloudDesc, String collection, String shardZkNodeName, String shardId, ZkNodeProps leaderProps, SolrCore core, CoreContainer cc) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return false;
        }
        boolean doRecovery = true;
        if (!isLeader) {
            if (core.isReloaded() && !recoverReloadedCores) {
                doRecovery = false;
            }
            if (doRecovery) {
                log.info("Core needs to recover:" + core.getName());
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
        } else {
            log.info("I am the leader, no recovery necessary");
        }
        return false;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void publish(CoreDescriptor cd, String state) throws KeeperException, InterruptedException {
        this.publish(cd, state, true);
    }

    public void publish(CoreDescriptor cd, String state, boolean updateLastState) throws KeeperException, InterruptedException {
        this.publish(cd, state, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(CoreDescriptor cd, String state, boolean updateLastState, boolean forcePublish) throws KeeperException, InterruptedException {
        if (!forcePublish) {
            SolrCore core = this.cc.getCore(cd.getName());
            if (core == null) {
                return;
            }
            try {
                if (core.isClosed()) {
                    return;
                }
            }
            finally {
                core.close();
            }
        }
        log.info("publishing core={} state={}", (Object)cd.getName(), (Object)state);
        Integer numShards = cd.getCloudDescriptor().getNumShards();
        if (numShards == null) {
            log.info("numShards not found on descriptor - reading it from system property");
            numShards = Integer.getInteger("numShards");
        }
        assert (cd.getCloudDescriptor().getCollectionName() != null && cd.getCloudDescriptor().getCollectionName().length() > 0);
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "state", "state", state, "base_url", this.getBaseUrl(), "core", cd.getName(), "roles", cd.getCloudDescriptor().getRoles(), "node_name", this.getNodeName(), "shard", cd.getCloudDescriptor().getShardId(), "collection", cd.getCloudDescriptor().getCollectionName(), "numShards", numShards != null ? numShards.toString() : null, "core_node_name", coreNodeName != null ? coreNodeName : null});
        if (updateLastState) {
            cd.getCloudDescriptor().lastPublished = state;
        }
        this.overseerJobQueue.offer(ZkStateReader.toJSON((Object)m));
    }

    private boolean needsToBeAssignedShardId(CoreDescriptor desc, ClusterState state, String coreNodeName) {
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String shardId = state.getShardId(this.getBaseUrl(), desc.getName());
        if (shardId != null) {
            cloudDesc.setShardId(shardId);
            return false;
        }
        return true;
    }

    public void unregister(String coreName, CoreDescriptor cd) throws InterruptedException, KeeperException {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        String collection = cd.getCloudDescriptor().getCollectionName();
        assert (collection != null);
        ElectionContext context = this.electionContexts.remove(new ContextKey(collection, coreNodeName));
        if (context != null) {
            context.cancelElection();
        }
        CloudDescriptor cloudDescriptor = cd.getCloudDescriptor();
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletecore", "core", coreName, "node_name", this.getNodeName(), "collection", cloudDescriptor.getCollectionName(), "core_node_name", coreNodeName});
        this.overseerJobQueue.offer(ZkStateReader.toJSON((Object)m));
    }

    public void createCollection(String collection) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "createcollection", "node_name", this.getNodeName(), "collection", collection});
        this.overseerJobQueue.offer(ZkStateReader.toJSON((Object)m));
    }

    public void uploadToZK(File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, zkPath);
    }

    public void uploadConfigDir(File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, "/configs/" + configName);
    }

    void printLayoutToStdOut() throws KeeperException, InterruptedException {
        this.zkClient.printLayoutToStdOut();
    }

    public void createCollectionZkNode(CloudDescriptor cd) throws KeeperException, InterruptedException {
        block16: {
            String collection = cd.getCollectionName();
            log.info("Check for collection zkNode:" + collection);
            String collectionPath = "/collections/" + collection;
            try {
                if (!this.zkClient.exists(collectionPath, true).booleanValue()) {
                    log.info("Creating collection in ZooKeeper:" + collection);
                    SolrParams params = cd.getParams();
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        String defaultConfigName = System.getProperty("collection.configName", collection);
                        if (params != null) {
                            Iterator iter = params.getParameterNamesIterator();
                            while (iter.hasNext()) {
                                String paramName = (String)iter.next();
                                if (!paramName.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(paramName.substring(COLLECTION_PARAM_PREFIX.length()), params.get(paramName));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                this.getConfName(collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            log.info("Setting config for collection:" + collection + " to " + defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(sprop.substring(COLLECTION_PARAM_PREFIX.length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                collectionProps.put(CONFIGNAME_PROP, defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put(CONFIGNAME_PROP, cd.getCollectionName());
                        } else {
                            this.getConfName(collection, collectionPath, collectionProps);
                        }
                        collectionProps.remove("numShards");
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        this.zkClient.makePath(collectionPath, ZkStateReader.toJSON((Object)zkProps), CreateMode.PERSISTENT, null, true);
                        break block16;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block16;
                    }
                }
                log.info("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block16;
                throw e;
            }
        }
    }

    private void getConfName(String collection, String collectionPath, Map<String, Object> collectionProps) throws KeeperException, InterruptedException {
        ZkNodeProps cProps;
        int retry;
        log.info("Looking for collection configName");
        List configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || this.zkClient.exists(collectionPath, true).booleanValue() && (cProps = ZkNodeProps.load((byte[])this.zkClient.getData(collectionPath, null, null, true))).containsKey(CONFIGNAME_PROP)); ++retry) {
            try {
                configNames = this.zkClient.getChildren(CONFIGS_ZKNODE, null, true);
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
            if (configNames != null && configNames.size() == 1) {
                log.info("Only one config set found in zk - using it:" + (String)configNames.get(0));
                collectionProps.put(CONFIGNAME_PROP, configNames.get(0));
                break;
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put(CONFIGNAME_PROP, collection);
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: " + retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection " + collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    private void doGetShardIdAndNodeNameProcess(CoreDescriptor cd) {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName != null) {
            this.waitForShardId(cd);
        } else {
            this.waitForCoreNodeName(cd);
            this.waitForShardId(cd);
        }
    }

    private void waitForCoreNodeName(CoreDescriptor descriptor) {
        int retryCount = 320;
        log.info("look for our core node name");
        while (retryCount-- > 0) {
            Map slicesMap = this.zkStateReader.getClusterState().getSlicesMap(descriptor.getCloudDescriptor().getCollectionName());
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String baseUrl = replica.getStr("base_url");
                        String core = replica.getStr("core");
                        String msgBaseUrl = this.getBaseUrl();
                        String msgCore = descriptor.getName();
                        if (!baseUrl.equals(msgBaseUrl) || !core.equals(msgCore)) continue;
                        descriptor.getCloudDescriptor().setCoreNodeName(replica.getName());
                        return;
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void waitForShardId(CoreDescriptor cd) {
        log.info("waiting to find shard id in clusterstate for " + cd.getName());
        int retryCount = 320;
        while (retryCount-- > 0) {
            String shardId = this.zkStateReader.getClusterState().getShardId(this.getBaseUrl(), cd.getName());
            if (shardId != null) {
                cd.getCloudDescriptor().setShardId(shardId);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get shard id for core: " + cd.getName());
    }

    public static void uploadToZK(SolrZkClient zkClient, File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Illegal directory: " + dir);
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (!file.isDirectory()) {
                zkClient.makePath(zkPath + "/" + file.getName(), file, false, true);
                continue;
            }
            ZkController.uploadToZK(zkClient, file, zkPath + "/" + file.getName());
        }
    }

    public static void downloadFromZK(SolrZkClient zkClient, String zkPath, File dir) throws IOException, KeeperException, InterruptedException {
        List files = zkClient.getChildren(zkPath, null, true);
        for (String file : files) {
            List children = zkClient.getChildren(zkPath + "/" + file, null, true);
            if (children.size() == 0) {
                byte[] data = zkClient.getData(zkPath + "/" + file, null, null, true);
                dir.mkdirs();
                log.info("Write file " + new File(dir, file));
                FileUtils.writeByteArrayToFile((File)new File(dir, file), (byte[])data);
                continue;
            }
            ZkController.downloadFromZK(zkClient, zkPath + "/" + file, new File(dir, file));
        }
    }

    public String getCoreNodeName(CoreDescriptor descriptor) {
        String coreNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName == null && !this.genericCoreNodeNames) {
            return this.getNodeName() + "_" + descriptor.getName();
        }
        return coreNodeName;
    }

    public static void uploadConfigDir(SolrZkClient zkClient, File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(zkClient, dir, "/configs/" + configName);
    }

    public static void downloadConfigDir(SolrZkClient zkClient, String configName, File dir) throws IOException, KeeperException, InterruptedException {
        ZkController.downloadFromZK(zkClient, "/configs/" + configName, dir);
    }

    public void preRegister(CoreDescriptor cd) {
        String coreNodeName = this.getCoreNodeName(cd);
        try {
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            if (cloudDesc.getCoreNodeName() == null) {
                cloudDesc.setCoreNodeName(coreNodeName);
            }
            this.publish(cd, "down", false, true);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        if (cd.getCloudDescriptor().getShardId() == null && this.needsToBeAssignedShardId(cd, this.zkStateReader.getClusterState(), coreNodeName)) {
            this.doGetShardIdAndNodeNameProcess(cd);
        } else {
            this.doGetShardIdAndNodeNameProcess(cd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkCoreNodeProps waitForLeaderToSeeDownState(CoreDescriptor descriptor, String coreZkNodeName) {
        CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shard = cloudDesc.getShardId();
        ZkCoreNodeProps leaderProps = null;
        int retries = 6;
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.isClosed) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                }
                leaderProps = this.getLeaderProps(collection, shard, 30000);
                break;
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"There was a problem finding the leader in zk", (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (i != retries - 1) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem finding the leader in zk");
            }
        }
        String leaderBaseUrl = leaderProps.getBaseUrl();
        String leaderCoreName = leaderProps.getCoreName();
        String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.getBaseUrl(), (String)descriptor.getName());
        boolean isLeader = leaderProps.getCoreUrl().equals(ourUrl);
        if (!isLeader && !this.SKIP_AUTO_RECOVERY) {
            HttpSolrServer server = null;
            server = new HttpSolrServer(leaderBaseUrl);
            try {
                server.setConnectionTimeout(15000);
                server.setSoTimeout(120000);
                CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
                prepCmd.setCoreName(leaderCoreName);
                prepCmd.setNodeName(this.getNodeName());
                prepCmd.setCoreNodeName(coreZkNodeName);
                prepCmd.setState("down");
                retries = 6;
                for (int i = 0; i < retries; ++i) {
                    if (this.isClosed) {
                        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                    }
                    try {
                        server.request((SolrRequest)prepCmd);
                        break;
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, (String)"There was a problem making a request to the leader", (Throwable)e);
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                        if (i != retries - 1) continue;
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem making a request to the leader");
                    }
                }
            }
            finally {
                server.shutdown();
            }
        }
        return leaderProps;
    }

    public static void linkConfSet(SolrZkClient zkClient, String collection, String confSetName) throws KeeperException, InterruptedException {
        byte[] data;
        String path = "/collections/" + collection;
        if (log.isInfoEnabled()) {
            log.info("Load collection config from:" + path);
        }
        try {
            data = zkClient.getData(path, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            ZkNodeProps props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
            try {
                zkClient.makePath(path, ZkStateReader.toJSON((Object)props), CreateMode.PERSISTENT, null, true);
            }
            catch (KeeperException e2) {
                if (e2.code() != KeeperException.Code.NODEEXISTS) {
                    throw e;
                }
                zkClient.setData(path, ZkStateReader.toJSON((Object)props), true);
            }
            return;
        }
        ZkNodeProps props = null;
        if (data != null) {
            props = ZkNodeProps.load((byte[])data);
            HashMap<String, String> newProps = new HashMap<String, String>();
            newProps.putAll(props.getProperties());
            newProps.put(CONFIGNAME_PROP, confSetName);
            props = new ZkNodeProps(newProps);
        } else {
            props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
        }
        zkClient.setData(path, ZkStateReader.toJSON((Object)props), true);
    }

    public static void bootstrapConf(SolrZkClient zkClient, CoreContainer cc, String solrHome) throws IOException, KeeperException, InterruptedException {
        List<CoreDescriptor> cds = cc.getCoresLocator().discover(cc);
        log.info("bootstrapping config for " + cds.size() + " cores into ZooKeeper using solr.xml from " + solrHome);
        for (CoreDescriptor cd : cds) {
            String coreName = cd.getName();
            String confName = cd.getCollectionName();
            if (StringUtils.isEmpty((String)confName)) {
                confName = coreName;
            }
            String instanceDir = cd.getInstanceDir();
            File udir = new File(instanceDir, "conf");
            log.info("Uploading directory " + udir + " with name " + confName + " for SolrCore " + coreName);
            ZkController.uploadConfigDir(zkClient, udir, confName);
        }
    }

    public DistributedQueue getOverseerJobQueue() {
        return this.overseerJobQueue;
    }

    public DistributedQueue getOverseerCollectionQueue() {
        return this.overseerCollectionQueue;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public Overseer getOverseer() {
        return this.overseer;
    }

    public LeaderElector getOverseerElector() {
        return this.overseerElector;
    }

    static String generateNodeName(String hostName, String hostPort, String hostContext) {
        try {
            return hostName + ':' + hostPort + '_' + URLEncoder.encode(ZkController.trimLeadingAndTrailingSlashes(hostContext), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM Does not seem to support UTF-8", e);
        }
    }

    public static String trimLeadingAndTrailingSlashes(String in) {
        if (null == in) {
            return in;
        }
        String out = in;
        if (out.startsWith("/")) {
            out = out.substring(1);
        }
        if (out.endsWith("/")) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public void rejoinOverseerElection() {
        try {
            this.overseerElector.retryElection();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
    }

    static class ContextKey {
        private String collection;
        private String coreNodeName;

        public ContextKey(String collection, String coreNodeName) {
            this.collection = collection;
            this.coreNodeName = coreNodeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.coreNodeName == null ? 0 : this.coreNodeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
                return false;
            }
            return !(this.coreNodeName == null ? other.coreNodeName != null : !this.coreNodeName.equals(other.coreNodeName));
        }
    }
}

