/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final ShardHandler shardHandler;
    private volatile boolean isClosed;
    private final HttpClient client;
    private final ExecutorService updateExecutor;

    public SyncStrategy(CoreContainer cc) {
        UpdateShardHandler updateShardHandler = cc.getUpdateShardHandler();
        this.client = updateShardHandler.getHttpClient();
        this.shardHandler = cc.getShardHandlerFactory().getShardHandler();
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
    }

    public boolean sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        return this.sync(zkController, core, leaderProps, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps, boolean peerSyncOnlyWithActive) {
        boolean success;
        if (this.SKIP_AUTO_RECOVERY) {
            return true;
        }
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
        SolrQueryResponse rsp = new SolrQueryResponse();
        SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
        try {
            if (this.isClosed) {
                this.log.warn("Closed, skipping sync up.");
                boolean bl = false;
                return bl;
            }
            this.log.info("Sync replicas to " + ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps));
            if (core.getUpdateHandler().getUpdateLog() == null) {
                this.log.error("No UpdateLog found - cannot sync");
                boolean bl = false;
                return bl;
            }
            success = this.syncReplicas(zkController, core, leaderProps, peerSyncOnlyWithActive);
        }
        finally {
            SolrRequestInfo.clearRequestInfo();
        }
        return success;
    }

    private boolean syncReplicas(ZkController zkController, SolrCore core, ZkNodeProps leaderProps, boolean peerSyncOnlyWithActive) {
        boolean success = false;
        CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        if (this.isClosed) {
            this.log.info("We have been closed, won't sync with replicas");
            return false;
        }
        try {
            success = this.syncWithReplicas(zkController, core, leaderProps, collection, shardId, peerSyncOnlyWithActive);
        }
        catch (Exception e) {
            SolrException.log((Logger)this.log, (String)"Sync Failed", (Throwable)e);
        }
        try {
            if (this.isClosed) {
                this.log.info("We have been closed, won't attempt to sync replicas back to leader");
                return false;
            }
            if (success) {
                this.log.info("Sync Success - now sync replicas to me");
                this.syncToMe(zkController, collection, shardId, leaderProps, core.getCoreDescriptor());
            } else {
                this.log.info("Leader's attempt to sync with shard failed, moving to the next candidate");
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)this.log, (String)"Sync Failed", (Throwable)e);
        }
        return success;
    }

    private boolean syncWithReplicas(ZkController zkController, SolrCore core, ZkNodeProps props, String collection, String shardId, boolean peerSyncOnlyWithActive) {
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName(), props.getStr("core"));
        if (nodes == null) {
            return true;
        }
        ArrayList<String> syncWith = new ArrayList<String>();
        for (ZkCoreNodeProps node : nodes) {
            syncWith.add(node.getCoreUrl());
        }
        PeerSync peerSync = new PeerSync(core, syncWith, core.getUpdateHandler().getUpdateLog().numRecordsToKeep, true, true, peerSyncOnlyWithActive);
        return peerSync.sync();
    }

    private void syncToMe(ZkController zkController, String collection, String shardId, ZkNodeProps leaderProps, CoreDescriptor cd) {
        ShardResponse srsp;
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, cd.getCloudDescriptor().getCoreNodeName(), leaderProps.getStr("core"));
        if (nodes == null) {
            this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + " has no replicas");
            return;
        }
        ZkCoreNodeProps zkLeader = new ZkCoreNodeProps(leaderProps);
        for (ZkCoreNodeProps node : nodes) {
            try {
                this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": try and ask " + node.getCoreUrl() + " to sync");
                this.requestSync(node.getBaseUrl(), node.getCoreUrl(), zkLeader.getCoreUrl(), node.getCoreName());
            }
            catch (Exception e) {
                SolrException.log((Logger)this.log, (String)"Error syncing replica to leader", (Throwable)e);
            }
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            boolean success = this.handleResponse(srsp);
            if (srsp.getException() != null) {
                SolrException.log((Logger)this.log, (String)("Sync request error: " + srsp.getException()));
            }
            if (!success) {
                try {
                    this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Sync failed - asking replica (" + srsp.getShardAddress() + ") to recover.");
                    if (this.isClosed) {
                        this.log.info("We have been closed, don't request that a replica recover");
                        continue;
                    }
                    this.requestRecovery(leaderProps, ((ShardCoreRequest)srsp.getShardRequest()).baseUrl, ((ShardCoreRequest)srsp.getShardRequest()).coreName);
                }
                catch (Exception e) {
                    SolrException.log((Logger)this.log, (String)(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Could not tell a replica to recover"), (Throwable)e);
                }
                continue;
            }
            this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": " + " sync completed with " + srsp.getShardAddress());
        }
    }

    private boolean handleResponse(ShardResponse srsp) {
        NamedList response = srsp.getSolrResponse().getResponse();
        if (response == null) {
            return false;
        }
        Boolean success = (Boolean)response.get("sync");
        if (success == null) {
            success = false;
        }
        return success;
    }

    private void requestSync(String baseUrl, String replica, String leaderUrl, String coreName) {
        ShardCoreRequest sreq = new ShardCoreRequest();
        sreq.coreName = coreName;
        sreq.baseUrl = baseUrl;
        sreq.purpose = 1;
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", new String[]{Integer.toString(100)});
        sreq.params.set("sync", new String[]{leaderUrl});
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    public void close() {
        this.isClosed = true;
    }

    private void requestRecovery(final ZkNodeProps leaderProps, final String baseUrl, final String coreName) throws SolrServerException, IOException {
        Thread thread = new Thread(){
            {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(coreName);
                HttpSolrServer server = new HttpSolrServer(baseUrl, SyncStrategy.this.client);
                try {
                    server.setConnectionTimeout(30000);
                    server.setSoTimeout(120000);
                    server.request((SolrRequest)recoverRequestCmd);
                }
                catch (Throwable t) {
                    SolrException.log((Logger)SyncStrategy.this.log, (String)(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Could not tell a replica to recover"), (Throwable)t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                }
                finally {
                    server.shutdown();
                }
            }
        };
        this.updateExecutor.execute(thread);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    private static class ShardCoreRequest
    extends ShardRequest {
        String coreName;
        public String baseUrl;

        private ShardCoreRequest() {
        }
    }
}

