/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.resource.ResourceContext;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicParameterHandler;
import org.seasar.robot.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.robot.dbflute.twowaysql.node.Node;

public abstract class TnAbstractTwoWaySqlCommand
extends TnAbstractBasicSqlCommand {
    public TnAbstractTwoWaySqlCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        Node rootNode = this.getRootNode(args);
        CommandContext ctx = this.apply(rootNode, args, this.getArgNames(args), this.getArgTypes(args));
        String executedSql = this.filterExecutedSql(ctx.getSql());
        TnBasicParameterHandler handler = this.createBasicParameterHandler(ctx, executedSql);
        Object[] bindVariables = ctx.getBindVariables();
        Class<?>[] bindVariableTypes = ctx.getBindVariableTypes();
        return this.filterReturnValue(handler.execute(bindVariables, bindVariableTypes));
    }

    protected abstract Node getRootNode(Object[] var1);

    protected abstract String[] getArgNames(Object[] var1);

    protected abstract Class<?>[] getArgTypes(Object[] var1);

    protected TnBasicParameterHandler createBasicParameterHandler(CommandContext context, String executedSql) {
        TnBasicParameterHandler handler = this.newBasicParameterHandler(executedSql);
        Object[] bindVariables = context.getBindVariables();
        handler.setExceptionMessageSqlArgs(bindVariables);
        return handler;
    }

    protected abstract TnBasicParameterHandler newBasicParameterHandler(String var1);

    protected String filterExecutedSql(String executedSql) {
        return executedSql;
    }

    protected Object filterReturnValue(Object returnValue) {
        return returnValue;
    }

    protected Node analyzeTwoWaySql(String twoWaySql) {
        return this.createSqlAnalyzer(twoWaySql).analyze();
    }

    protected SqlAnalyzer createSqlAnalyzer(String twoWaySql) {
        return ResourceContext.createSqlAnalyzer(twoWaySql, this.isBlockNullParameter());
    }

    protected boolean isBlockNullParameter() {
        return false;
    }

    protected CommandContext apply(Node rootNode, Object[] args, String[] argNames, Class<?>[] argTypes) {
        CommandContext ctx = this.createCommandContext(args, argNames, argTypes);
        rootNode.accept(ctx);
        return ctx;
    }

    protected CommandContext createCommandContext(Object[] args, String[] argNames, Class<?>[] argTypes) {
        return this.createCommandContextCreator(argNames, argTypes).createCommandContext(args);
    }

    protected CommandContextCreator createCommandContextCreator(String[] argNames, Class<?>[] argTypes) {
        return new CommandContextCreator(argNames, argTypes);
    }
}

