/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.helper.StringKeyMap;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.robot.dbflute.util.DfCollectionUtil;

public abstract class TnAbstractMapResultSetHandler
implements TnResultSetHandler {
    protected Map<String, ValueType> createPropertyTypeMap(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        LinkedHashMap<String, ValueType> propertyTypeMap = DfCollectionUtil.newLinkedHashMap();
        for (int i = 0; i < count; ++i) {
            String propertyName = rsmd.getColumnLabel(i + 1);
            ValueType valueType = TnValueTypes.getValueType(rsmd.getColumnType(i + 1));
            propertyTypeMap.put(propertyName, valueType);
        }
        return propertyTypeMap;
    }

    protected Map<String, Object> createRow(ResultSet rs, Map<String, ValueType> propertyTypeMap) throws SQLException {
        StringKeyMap<Object> row = StringKeyMap.createAsFlexibleOrdered();
        Set<Map.Entry<String, ValueType>> entrySet = propertyTypeMap.entrySet();
        int index = 0;
        for (Map.Entry<String, ValueType> entry : entrySet) {
            String propertyName = entry.getKey();
            ValueType valueType = entry.getValue();
            Object value = valueType.getValue(rs, index + 1);
            row.put(propertyName, value);
            ++index;
        }
        return row;
    }
}

